package com.bringspring.oauth.service;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.oauth.model.PcUserVO;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
public interface LoginService {

    /**
     * 租戶登录验证
     *
     * @param loginForm
     * @return
     * @throws LoginException
     */
    UserInfo checkTenant(LoginForm loginForm) throws LoginException;

    /**
     * 信息
     *
     * @param userInfoVo
     * @return
     */
    UserInfo userInfo(UserInfo userInfo, UserEntity userInfoVo, BaseSystemInfo sysConfigInfo) throws LoginException;

    /**
     * 验证账号是否可以使用
     * @param account
     * @return
     * @throws LoginException
     */
    UserEntity isExistUser(String account) throws LoginException, PermissionException;

    /**
     * 用户统一登录操作
     * 组装用户信息
     * @param userEntity
     * @return
     * @throws LoginException
     */
    UserInfo loginProcess(UserEntity userEntity) throws LoginException;


    /**
     * 获取用户登陆信息
     *
     * @return
     */
    PcUserVO getCurrentUser(String type,String appliactionId);


    /**
     *
     * @param weComCode
     * @return
     * @throws Exception
     */
    String getAccountByWeComCode(String weComCode,String cropId) throws Exception;


    /**
     * 获取打开的网页的用户身份信息
     *
     * @param weComCode 构造网页授权链接获取code参数
     * @param cropId 企业的CorpID
     * @param agentId 应用agentid
     * @return
     * @throws Exception
     */
    String getAccountByWeComCode(String weComCode, String cropId, Integer agentId) throws Exception;

    /**
     *
     * @param dingCode
     * @return
     * @throws Exception
     */
    String getAccountByDingCode(String dingCode) throws Exception;

    String getAccountByDingCodeH5(String dingCode) throws Exception;

}
