package com.bringspring.oauth.config.detail;

import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.permission.exception.PermissionException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public interface MoreMethodUserDetailService extends UserDetailsService {
    /**
     * 用户名密码登录
     * @param username
     * @return
     * @throws UsernameNotFoundException, LoginException, PermissionException
     */
    UserDetails loadUserByUsername(String username) throws UsernameNotFoundException;

    /**
     * 企业微信授权码Code登录
     * @param code
     * @return
     * @throws Exception
     */
    UserDetails loadUserByWeComCode(String code,String cropId) throws Exception;

    /**
     * 企业微信授权码Code登录
     * @param code
     * @return
     * @throws Exception
     */
    UserDetails loadUserByWeComCode(String code, String cropId, Integer agentId) throws Exception;

    /**
     * 钉钉授权码Code登录
     * @param code
     * @return
     * @throws Exception
     */
    UserDetails loadUserByDingCode(String code) throws Exception;

    UserDetails loadUserByDingCodeH5(String code) throws Exception;
}
