package com.bringspring.oauth.method.dingding.provider;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.oauth.method.dingding.token.DingTalkAuthenticationToken;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class DingTalkAuthenticationProvider implements AuthenticationProvider {


    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        DingTalkAuthenticationToken authenticationToken = (DingTalkAuthenticationToken) authentication;
        String code = authenticationToken.getCode();
        if (ObjectUtil.isNotEmpty(code)) {
            //如果密码匹配，则返回Authentication接口的实现以及必要的详细信息
            return authentication;
        } else {    //密码不匹配，抛出异常
            throw new BadCredentialsException("钉钉授权码为空!");
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return authentication.equals(DingTalkAuthenticationToken.class);
    }
}
