package com.bringspring.oauth.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 租户信息
 *
 * @author RKKJ开发平台组
 * @version V1.2.191207
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("base_tenant")
public class TenantEntity {
    /**
     * 租户主键
     */
    @TableId("ID")
    private String id;

    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 姓名
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 密码
     */
    @TableField("PASSWORD")
    private String password;

    /**
     * 公司
     */
    @TableField("COMPANYNAME")
    private String companyName;

    /**
     * 过期时间
     */
    @TableField("EXPIRESTIME")
    private String expiresTime;

    /**
     * 连接驱动
     */
    @TableField("DBTYPE")
    private String dbType;

    /**
     * 主机地址
     */
    @TableField("DBHOST")
    private String dbHost;

    /**
     * 端口
     */
    @TableField("DBPORT")
    private String dbPort;

    /**
     * 用户
     */
    @TableField("DBUSERNAME")
    private String dbUserName;

    /**
     * 密码
     */
    @TableField("DBPASSWORD")
    private String dbPassword;

    /**
     * 服务名
     */
    @TableField("DBSERVICENAME")
    private String dbServiceName;

    /**
     * ip
     */
    @TableField("IPADDRESS")
    private String ipAddress;

    /**
     * ip城市
     */
    @TableField("IPADDRESSNAME")
    private String ipAddressName;

    /**
     * 来源
     */
    @TableField("SOURCEWEBSITE")
    private String sourceWebsite;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
