package com.bringspring.oauth.method.wxminiapp.granter;

import com.bringspring.oauth.method.detail.UserDetailsServiceImpl;
import com.bringspring.oauth.method.wxminiapp.token.WxMiniappAuthenticationToken;
import lombok.SneakyThrows;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.provider.*;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

import java.util.Map;

public class WxMiniappAbstractTokenGranter extends AbstractTokenGranter {

    private final UserDetailsServiceImpl userDetailsService;
    private static final String GRANT_TYPE = "WxMiniapp";
    private final AuthenticationManager authenticationManager;

    public WxMiniappAbstractTokenGranter(UserDetailsServiceImpl userDetailsService,
                                         AuthenticationManager authenticationManager,
                                         AuthorizationServerTokenServices tokenServices,
                                         ClientDetailsService clientDetailsService,
                                         OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        this.authenticationManager = authenticationManager;
        this.userDetailsService = userDetailsService;

    }

    @SneakyThrows
    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map<String, String> requestParameters = tokenRequest.getRequestParameters();
        String code = requestParameters.get("code");
        String appid = requestParameters.get("appid");
        String phoneCode = requestParameters.get("phoneCode");
        UserDetails u = userDetailsService.loadUserByWxMiniappCode(appid, code, phoneCode);
        WxMiniappAuthenticationToken wxMiniappAuthenticationToken = new WxMiniappAuthenticationToken(code,
                u.getUsername(), u.getPassword());
        wxMiniappAuthenticationToken.setDetails(requestParameters);
        authenticationManager.authenticate(wxMiniappAuthenticationToken);
        OAuth2Request oAuth2Request = getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(oAuth2Request, wxMiniappAuthenticationToken);
    }
}
