package com.bringspring.oauth.config.detail;

import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public interface MoreMethodUserDetailService extends UserDetailsService {
    /**
     * 用户名密码登录
     * @param username
     * @return
     * @throws UsernameNotFoundException, LoginException, PermissionException
     */
    UserDetails loadUserByUsername(String username) throws UsernameNotFoundException;

    /**
     * @param account
     * @return
     * @throws Exception
     */
    UserDetails loadUserByAccount(String account) throws Exception;
    /**
     * 短信验证码登陆
     *
     * @param account 手机号
     * @param code 验证码
     * @return
     * @throws Exception
     */
    UserDetails loadUserBySmsCode(String account,String code) throws Exception;
    /**
     * 企业微信授权码Code登录
     * @param code
     * @return
     * @throws Exception
     */
//    UserDetails loadUserByWeComCode(String code,String cropId) throws Exception;

    /**
     * 企业微信授权码Code登录
     * @param code
     * @return
     * @throws Exception
     */
    UserDetails loadUserByWeComCode(String code, String cropId, Integer agentId) throws Exception;

    /**
     * 钉钉授权码Code登录
     * @param code
     * @return
     * @throws Exception
     */
    UserDetails loadUserByDingCode(String code) throws Exception;

    UserDetails loadUserByDingCodeH5(String code) throws Exception;

    /**
     * 微信小程序授权码Code登录
     * @param code
     * @return
     * @throws Exception
     */
    UserDetails loadUserByWxMiniappCode(String appid, String code, String phoneCode) throws Exception;
}
