/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.common.model.login.LoginVO;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oauth.model.LoginModel;
import com.bringspring.oauth.model.PcUserVO;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.service.SmsTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.user.form.UserCrForm;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u767b\u9646\u6570\u636e"}, value="oauth")
@RestController
@RequestMapping(value={"/api/oauth"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private TokenEndpoint tokenEndpoint;
    @Autowired
    private LoginService loginService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private SmsTemplateService smsTemplateService;

    @ApiOperation(value="\u767b\u9646")
    @RequestMapping(value={"/Login"}, consumes={"application/x-www-form-urlencoded"})
    public ActionResult<LoginVO> Login(Principal principal, @RequestParam Map<String, String> parameters) throws LoginException {
        OAuth2AccessToken oAuth2AccessToken;
        try {
            oAuth2AccessToken = (OAuth2AccessToken)this.tokenEndpoint.postAccessToken(principal, parameters).getBody();
        }
        catch (LoginException e) {
            if (ObjectUtil.isNotEmpty((Object)e.getCode()) && e.getCode() > 900) {
                return ActionResult.warning((Integer)e.getCode(), (String)e.getMessage());
            }
            e.printStackTrace();
            throw new LoginException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(e.getMessage());
        }
        this.loginService.loginUpdateUser(oAuth2AccessToken.getTokenType() + " " + oAuth2AccessToken.getValue());
        LoginVO loginVO = new LoginVO();
        loginVO.setToken(oAuth2AccessToken.getTokenType() + " " + oAuth2AccessToken.getValue());
        return ActionResult.success((Object)loginVO);
    }

    @ApiOperation(value="\u9501\u5c4f\u89e3\u9501\u767b\u5f55")
    @PostMapping(value={"/LockScreen"})
    public ActionResult lockScreen(@RequestBody LoginForm loginForm) throws LoginException, PermissionException {
        UserEntity userEntity = this.userService.getUserByAccount(loginForm.getAccount());
        if (!Md5Util.getStringMd5((String)(loginForm.getPassword().toLowerCase() + userEntity.getSecretkey().toLowerCase())).equals(userEntity.getPassword())) {
            throw new LoginException(MsgCode.LOG101.get());
        }
        return ActionResult.success((String)MsgCode.SU017.get());
    }

    @ApiOperation(value="\u9000\u51fa")
    @GetMapping(value={"/Logout"})
    public ActionResult logout() {
        if (ObjectUtil.isNotEmpty((Object)this.userProvider.get())) {
            if (Objects.nonNull(this.sysConfigService.getSysInfo()) && "1".equals(String.valueOf(this.sysConfigService.getSysInfo().getSingleLogin()))) {
                this.userProvider.removeCurrent();
            } else {
                String id = this.userProvider.get().getId();
                this.cacheUtil.remove("loginCacheSpace", id);
            }
        }
        return ActionResult.success((String)MsgCode.LOG002.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f")
    @GetMapping(value={"/CurrentUser"})
    public ActionResult<PcUserVO> currentUser(String type, String applicationId) throws LoginException, BaseException {
        PcUserVO pcUserVO = this.loginService.getCurrentUser(type, applicationId);
        if (pcUserVO == null) {
            throw new LoginException(MsgCode.LOG001.get());
        }
        return ActionResult.success((Object)pcUserVO);
    }

    @NoDataSourceBind
    @ApiOperation(value="\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/ImageCode/{codeLength}/{timestamp}"})
    public void imageCode(@PathVariable(value="codeLength") Integer codeLength, @PathVariable(value="timestamp") String timestamp) {
        DownUtil.downCode((Integer)codeLength);
        this.cacheUtil.insert("loginCacheSpace", timestamp, ServletUtils.getSession().getAttribute("RANDOMCODEKEY"), 300L);
    }

    @NoDataSourceBind
    @ApiOperation(value="\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/SmsCode/{phoneNumber}"})
    public ActionResult SmsCode(@PathVariable(value="timestamp") String phoneNumber) {
        this.cacheUtil.insert("loginCacheSpace", phoneNumber, (Object)"1234", 300L);
        return ActionResult.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
    }

    @NoDataSourceBind
    @ApiOperation(value="\u6ce8\u518c\u7528\u6237")
    @PostMapping(value={"/register"})
    public ActionResult<String> register(@RequestBody @Valid UserCrForm userCrForm) throws Exception {
        UserEntity entity = (UserEntity)JsonUtil.getJsonToBean((Object)userCrForm, UserEntity.class);
        this.userService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @NoDataSourceBind
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getConfig/{account}"})
    public ActionResult check(@PathVariable(value="account") String account) throws LoginException {
        BaseSystemInfo sysConfigInfo;
        LoginModel loginModel = new LoginModel();
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            LoginForm loginForm = new LoginForm();
            loginForm.setAccount(account);
            UserInfo userInfo = this.loginService.checkTenant(loginForm);
            DataSourceContextHolder.setDatasource((String)userInfo.getTenantId(), (String)userInfo.getTenantDbConnectionString());
        }
        if (Objects.nonNull(sysConfigInfo = this.sysConfigService.getSysInfo()) && "1".equals(String.valueOf(sysConfigInfo.getEnableVerificationCode()))) {
            loginModel.setEnableVerificationCode(1);
            Integer verificationCodeNumber = sysConfigInfo.getVerificationCodeNumber();
            loginModel.setVerificationCodeNumber(verificationCodeNumber == null ? 4 : verificationCodeNumber);
            return ActionResult.success((Object)loginModel);
        }
        loginModel.setEnableVerificationCode(0);
        return ActionResult.success((Object)loginModel);
    }

    @NoDataSourceBind
    @ApiOperation(value="\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e")
    @GetMapping(value={"/getQyhConfig"})
    public ActionResult getQyhConfig() throws BaseException {
        List qyChatModelList = this.sysConfigService.getQyChatModelList();
        return ActionResult.success((Object)qyChatModelList);
    }

    @NoDataSourceBind
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5730\u5740")
    @GetMapping(value={"/getSystemAddress/{terminal}"})
    public ActionResult getSystemAddress(@PathVariable(value="terminal") String terminal) {
        try {
            if ("pc".equals(terminal)) {
                String sysComputerUrl = this.sysConfigService.getConfigByKeyName("sysComputerUrl").getKeyValue();
                return ActionResult.success((String)sysComputerUrl);
            }
            String sysMobileUrl = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
            return ActionResult.success((String)sysMobileUrl);
        }
        catch (BaseException e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u83b7\u53d6\u7cfb\u7edf\u5730\u5740\u5931\u8d25\uff0c" + e.getMessage()));
        }
    }
}

