/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.method.detail;

import com.bringspring.common.util.CacheUtil;
import com.bringspring.oauth.config.MyRoleHierarchy;
import com.bringspring.oauth.config.detail.MoreMethodUserDetailService;
import com.bringspring.oauth.method.detail.UserExtend;
import com.bringspring.oauth.model.LoginBySignUpModel;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.oauth.service.ThirdPartyAuthService;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.permission.entity.UserEntity;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceImpl
implements MoreMethodUserDetailService {
    @Autowired
    private LoginService loginService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private ThirdPartyAuthService thirdPartyAuthService;

    public UserExtend loadUserByUsername(String username) throws UsernameNotFoundException {
        if (username.endsWith("@admin")) {
            UserEntity userEntity = this.loginService.isExistUser("admin");
            ArrayList list = new ArrayList();
            UserExtend user = new UserExtend(userEntity.getAccount(), userEntity.getSecretkey(), userEntity.getPassword(), list);
            return user;
        }
        UserEntity userEntity = this.loginService.isExistUser(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        UserExtend user = new UserExtend(userEntity.getAccount(), userEntity.getSecretkey(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByAccount(String account) throws Exception {
        UserEntity userEntity = this.loginService.isExistUser(account);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserBySmsCode(String account, String code) throws Exception {
        String tempCode = String.valueOf(this.cacheUtil.query(account));
        if (!tempCode.equals(code)) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        UserEntity userEntity = this.loginService.isExistUser(account);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByThirdAuth(String account, String thirdType, String productId, String code) throws Exception {
        boolean verifyResult = false;
        try {
            verifyResult = this.thirdPartyAuthService.thirdPartyVerify(thirdType, productId, code);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        if (!verifyResult) {
            throw new LoginException("\u7b2c\u4e09\u65b9\u6388\u6743\u9a8c\u8bc1\u672a\u901a\u8fc7");
        }
        UserEntity userEntity = this.loginService.isExistUser(account);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByWeComCode(String code, String cropId, Integer agentId) throws Exception {
        String username = this.loginService.getAccountByWxCode(code, cropId);
        UserEntity userEntity = this.loginService.isExistUser(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByDingCode(String code) throws Exception {
        String username = this.loginService.getAccountByDingCode(code);
        UserEntity userEntity = this.loginService.isExistUser(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByDingCodeH5(String code) throws Exception {
        String username = this.loginService.getAccountByDingCodeH5(code);
        UserEntity userEntity = this.loginService.isExistUser(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByWxMiniappCode(LoginBySignUpModel loginBySignUpModel) throws Exception {
        String username = this.loginService.getAccountByWxMiniappCode(loginBySignUpModel);
        UserEntity userEntity = this.loginService.isExistUser(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }
}

