package com.bringspring.oauth.method.thirdauth.provider;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.oauth.method.thirdauth.token.ThirdAuthAuthenticationToken;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ThirdAuthAuthenticationProvider implements AuthenticationProvider {


    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ThirdAuthAuthenticationToken authenticationToken = (ThirdAuthAuthenticationToken) authentication;
        String code = authenticationToken.getCode();
        if (ObjectUtil.isNotEmpty(code)) {
            //如果code不为空，返回Authentication接口的实现以及必要的详细信息
            return authentication;
        } else {    //如果code为空，抛出异常
            throw new BadCredentialsException("企业微信验证失败，验证码为空!");
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return authentication.equals(ThirdAuthAuthenticationToken.class);
    }
}
