package com.bringspring.oauth.service;

import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.oauth.model.LoginBySignUpModel;
import com.bringspring.oauth.model.PcUserVO;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
public interface LoginService {

    /**
     * 租戶登录验证
     *
     * @param loginForm
     * @return
     * @throws LoginException
     */
    UserInfo checkTenant(LoginForm loginForm) throws LoginException;

    /**
     * 获取用户信息
     *
     * @param userInfoVo
     * @return
     */
    UserInfo userInfo(UserInfo userInfo, UserEntity userInfoVo, BaseSystemInfo sysConfigInfo) throws LoginException;

    /**
     * 验证账号是否可以使用
     * @param account
     * @return
     * @throws LoginException
     */
    UserEntity isExistUser(String account) throws LoginException, PermissionException;

    /**
     * 用户统一登录操作
     * 组装用户信息
     * @param userEntity
     * @return
     * @throws LoginException
     */
    UserInfo loginProcess(UserEntity userEntity) throws LoginException;
    /**
     * 组装登录信息
     *
     * @return
     * @throws LoginException
     */
    void loginUpdateUser(String token) throws LoginException;
    /**
     * 获取用户登陆信息
     *
     * @return
     */
    PcUserVO getCurrentUser(String type,String appliactionId) throws BaseException;


    /**
     * 根据企业微信授权码code获取用户名
     * @param weComCode
     * @return
     * @throws Exception
     */
//    String getAccountByWeComCode(String weComCode,String cropId) throws Exception;


    /**
     * 获取打开的网页的用户身份信息
     *
     * @param weComCode 构造网页授权链接获取code参数
     * @param cropId 企业的CorpID
     * @return
     * @throws Exception
     */
    String getAccountByWxCode(String weComCode, String cropId) throws Exception;

    /**
     *
     * @param dingCode
     * @return
     * @throws Exception
     */
    String getAccountByDingCode(String dingCode) throws Exception;

    String getAccountByDingCodeH5(String dingCode) throws Exception;

    /**
     * 根据微信小程序授权code获取系统账户
     * @return
     * @throws Exception
     */
    String getAccountByWxMiniappCode(LoginBySignUpModel loginBySignUpModel) throws Exception;

}
