package com.bringspring.oauth.method.thirdauth.granter;

import com.bringspring.oauth.method.detail.UserDetailsServiceImpl;
import com.bringspring.oauth.method.thirdauth.token.ThirdAuthAuthenticationToken;
import lombok.SneakyThrows;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.provider.*;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

import java.util.Map;

public class ThirdAuthAbstractTokenGranter extends AbstractTokenGranter {

    private final UserDetailsServiceImpl userDetailsService;
    private static final String GRANT_TYPE = "thirdauth";
    private final AuthenticationManager authenticationManager;

    public ThirdAuthAbstractTokenGranter(UserDetailsServiceImpl userDetailsService, AuthenticationManager authenticationManager, AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        this.authenticationManager = authenticationManager;
        this.userDetailsService = userDetailsService;

    }

    @SneakyThrows
    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map<String, String> requestParameters = tokenRequest.getRequestParameters();
        String account = requestParameters.get("account"); // 账号
        String thirdType = requestParameters.get("thirdType"); // thirdType(rkkjWxwork：智行企微验证码)
        String productId = requestParameters.get("productId"); // 演示产品唯一标识
        String code = requestParameters.get("code"); // 验证码
        UserDetails u = userDetailsService.loadUserByThirdAuth(account, thirdType, productId, code);
        ThirdAuthAuthenticationToken authenticationToken = new ThirdAuthAuthenticationToken(code, u.getUsername(), u.getPassword());
        authenticationToken.setDetails(requestParameters);
        authenticationManager.authenticate(authenticationToken);
        OAuth2Request oAuth2Request = getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(oAuth2Request, authenticationToken);
    }
}
