package com.bringspring.oauth.method.dingding.granter;

import com.bringspring.oauth.method.detail.UserDetailsServiceImpl;
import com.bringspring.oauth.method.dingding.token.DingTalkAuthenticationToken;
import lombok.SneakyThrows;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.provider.*;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

import java.util.Map;

public class DingTalkAbstractTokenGranter extends AbstractTokenGranter {

    private final UserDetailsServiceImpl userDetailsService;
    private static final String GRANT_TYPE = "DingTalk";
    private final AuthenticationManager authenticationManager;

    public DingTalkAbstractTokenGranter(UserDetailsServiceImpl userDetailsService, AuthenticationManager authenticationManager, AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        this.authenticationManager = authenticationManager;
        this.userDetailsService = userDetailsService;

    }

    @SneakyThrows
    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map<String, String> requestParameters = tokenRequest.getRequestParameters();
        String code = requestParameters.get("code");
        UserDetails u = userDetailsService.loadUserByDingCode(code);
        DingTalkAuthenticationToken dingTalkAuthenticationToken = new DingTalkAuthenticationToken(code, u.getUsername(), u.getPassword());
        dingTalkAuthenticationToken.setDetails(requestParameters);
        OAuth2Request oAuth2Request = getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(oAuth2Request, dingTalkAuthenticationToken);
    }
}
