/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.method.wxminiapp.granter;

import com.bringspring.oauth.method.detail.UserDetailsServiceImpl;
import com.bringspring.oauth.method.wxminiapp.token.WxMiniappAuthenticationToken;
import com.bringspring.oauth.model.LoginBySignUpModel;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class WxMiniappAbstractTokenGranter
extends AbstractTokenGranter {
    private final UserDetailsServiceImpl userDetailsService;
    private static final String GRANT_TYPE = "WxMiniapp";
    private final AuthenticationManager authenticationManager;

    public WxMiniappAbstractTokenGranter(UserDetailsServiceImpl userDetailsService, AuthenticationManager authenticationManager, AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        this.authenticationManager = authenticationManager;
        this.userDetailsService = userDetailsService;
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map requestParameters = tokenRequest.getRequestParameters();
        String code = (String)requestParameters.get("code");
        String appid = (String)requestParameters.get("appid");
        String phoneCode = (String)requestParameters.get("phoneCode");
        String isTourist = (String)requestParameters.get("isTourist");
        String deptId = (String)requestParameters.get("deptId");
        String roleId = (String)requestParameters.get("roleId");
        LoginBySignUpModel loginBySignUpModel = new LoginBySignUpModel.Builder().appid(appid).code(code).phoneCode(phoneCode).isTourist(isTourist).deptId(deptId).roleId(roleId).build();
        UserDetails u = this.userDetailsService.loadUserByWxMiniappCode(loginBySignUpModel);
        WxMiniappAuthenticationToken wxMiniappAuthenticationToken = new WxMiniappAuthenticationToken(code, u.getUsername(), u.getPassword());
        wxMiniappAuthenticationToken.setDetails(requestParameters);
        this.authenticationManager.authenticate((Authentication)wxMiniappAuthenticationToken);
        OAuth2Request oAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(oAuth2Request, (Authentication)wxMiniappAuthenticationToken);
    }
}

