/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.config;

import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.stereotype.Component;

@Component
public class MyRoleHierarchy
implements RoleHierarchy {
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    public static final SimpleGrantedAuthority adminAuth = new SimpleGrantedAuthority("isAdmin");

    public Collection<? extends GrantedAuthority> getReachableGrantedAuthorities(Collection<? extends GrantedAuthority> authorities) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            boolean isAdmin = authorities.size() == 1 && authorities.contains(adminAuth);
            String interfacePermissionKey = "authorize_:" + this.cacheKeyUtil.getUserAuthorize() + "authority_" + (isAdmin ? "admin" : authentication.getName());
            String rolesKey = "authorize_:" + this.cacheKeyUtil.getUserAuthorize() + "role_" + (isAdmin ? "admin" : authentication.getName());
            Set permissions = Optional.ofNullable(this.cacheUtil.getSet(interfacePermissionKey)).orElse(new HashSet());
            permissions.addAll(Optional.ofNullable(this.cacheUtil.getSet(rolesKey)).orElse(Collections.emptySet()));
            Set permissionList = permissions.stream().map(s -> new SimpleGrantedAuthority(s.toString())).collect(Collectors.toSet());
            return permissionList;
        }
        return Collections.emptyList();
    }

    @Bean
    public HttpFirewall httpFirewall() {
        return new DefaultHttpFirewall();
    }
}

