/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.service.impl;

import com.bringspring.common.util.StringUtils;
import com.bringspring.oauth.config.ThirdPartyConfig;
import com.bringspring.oauth.model.ThirdPartyResponse;
import com.bringspring.oauth.service.ThirdPartyAuthService;
import com.bringspring.system.base.exception.LoginException;
import java.util.HashMap;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ThirdPartyAuthServiceImpl
implements ThirdPartyAuthService {
    private final ThirdPartyConfig thirdPartyConfig;
    private final RestTemplate restTemplate;

    public ThirdPartyAuthServiceImpl(ThirdPartyConfig thirdPartyConfig, RestTemplate restTemplate) {
        this.thirdPartyConfig = thirdPartyConfig;
        this.restTemplate = restTemplate;
    }

    @Override
    public boolean thirdPartyVerify(String thirdType, String productId, String code) {
        if (StringUtils.isBlank((CharSequence)thirdType)) {
            throw new LoginException("\u7b2c\u4e09\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)productId)) {
            throw new LoginException("\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (thirdType) {
            case "rkkjWxwork": {
                return this.rkkjWxworkVerifyCode(productId, code);
            }
        }
        return false;
    }

    @Override
    public boolean rkkjWxworkVerifyCode(String productId, String code) {
        String url = this.thirdPartyConfig.getRkkjWxworkVerifyCodeUrl() + productId;
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("code", code);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, ThirdPartyResponse.class, new Object[0]);
            return response.getStatusCode() == HttpStatus.OK && response.getBody() != null && ((ThirdPartyResponse)response.getBody()).isData();
        }
        catch (RestClientException e) {
            throw new LoginException(e.getMessage());
        }
    }
}

