package com.bringspring.oauth.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 登录自动注册参数模型
 *
 * @author zcx
 * @date 2025/5/15 14:30
 */
@Data
public class LoginBySignUpModel implements Serializable {

    /**
     * 应用ID
     */
    private String appid;
    /**
     * session key
     * 指的是当前的登录请求: 指的是一次会话
     * openid换取登录的用户(javaxl)相对于微信小程序这款软件的唯一标识
     */
    private String code;
    /**
     * 换取用户手机号的code
     */
    private String phoneCode;

    /**
     * 是否注册游客账户
     * 0：否
     * 1：是
     */
    private String isTourist;
    /**
     * 注册用户的部门ID
     */
    private String deptId;
    /**
     * 注册用户的角色ID
     */
    private String roleId;

    // 私有化构造函数，强制使用 Builder 构建对象
    private LoginBySignUpModel(Builder builder) {
        this.appid = builder.appid;
        this.code = builder.code;
        this.phoneCode = builder.phoneCode;
        this.isTourist = builder.isTourist;
        this.deptId = builder.deptId;
        this.roleId = builder.roleId;
    }

    // 静态内部类 Builder
    public static class Builder {
        private String appid;
        private String code;
        private String phoneCode;
        private String isTourist;
        private String deptId;
        private String roleId;

        // 可链式调用的构造方法
        public Builder() {
        }

        public Builder appid(String appid) {
            this.appid = appid;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder phoneCode(String phoneCode) {
            this.phoneCode = phoneCode;
            return this;
        }

        public Builder isTourist(String isTourist) {
            this.isTourist = isTourist;
            return this;
        }

        public Builder deptId(String deptId) {
            this.deptId = deptId;
            return this;
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        // 构建最终的对象
        public LoginBySignUpModel build() {
            return new LoginBySignUpModel(this);
        }
    }
}
