/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.config;

import cn.hutool.json.JSONUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.oauth.config.jwt.JwtTokenEnhancer;
import com.bringspring.oauth.config.password.MyPasswordEncoder;
import com.bringspring.oauth.method.cas.granter.CasAbstractTokenGranter;
import com.bringspring.oauth.method.detail.UserDetailsServiceImpl;
import com.bringspring.oauth.method.dingding.granter.DingTalkAbstractTokenGranter;
import com.bringspring.oauth.method.dingdingH5.granter.DingTalkH5AbstractTokenGranter;
import com.bringspring.oauth.method.password.granter.AccountPasswordAbstractTokenGranter;
import com.bringspring.oauth.method.qywechat.granter.WeComAbstractTokenGranter;
import com.bringspring.oauth.method.sms.granter.SmsCodeAbstractTokenGranter;
import com.bringspring.oauth.method.wxminiapp.granter.WxMiniappAbstractTokenGranter;
import java.util.ArrayList;
import java.util.Collections;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenGranter;
import org.springframework.security.oauth2.provider.password.ResourceOwnerPasswordTokenGranter;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenGranter;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.web.AuthenticationEntryPoint;

@EnableAuthorizationServer
@Configuration
public class AuthorizationServerConfig
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private UserDetailsServiceImpl userDetailsService;
    @Autowired
    private JwtTokenEnhancer jwtTokenEnhancer;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private AuthenticationManager authenticationManagers;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private JwtAccessTokenConverter jwtAccessTokenConverter;
    @Autowired
    private MyPasswordEncoder myPasswordEncoder;
    @Autowired
    private AuthorizationServerTokenServices tokenServices;

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        JdbcClientDetailsService jdbcClientDetailsService = new JdbcClientDetailsService(this.dataSource);
        jdbcClientDetailsService.setPasswordEncoder((PasswordEncoder)this.myPasswordEncoder);
        clients.withClientDetails((ClientDetailsService)jdbcClientDetailsService);
    }

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        security.allowFormAuthenticationForClients();
    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return (request, response, e) -> {
            response.setStatus(200);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Cache-Control", "no-cache");
            ActionResult result = ActionResult.fail((String)"\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25");
            response.getWriter().print(JSONUtil.toJsonStr((Object)result));
            response.getWriter().flush();
        };
    }

    public CompositeTokenGranter getTokenGrater(AuthorizationServerEndpointsConfigurer endpoints) {
        ClientDetailsService clientDetailsService = endpoints.getClientDetailsService();
        endpoints.setClientDetailsService(clientDetailsService);
        OAuth2RequestFactory requestFactory = endpoints.getOAuth2RequestFactory();
        ArrayList<TokenGranter> granters = new ArrayList<TokenGranter>(Collections.singletonList(endpoints.getTokenGranter()));
        granters.add((TokenGranter)new AuthorizationCodeTokenGranter(this.tokenServices, endpoints.getAuthorizationCodeServices(), endpoints.getClientDetailsService(), requestFactory));
        granters.add((TokenGranter)new RefreshTokenGranter(this.tokenServices, endpoints.getClientDetailsService(), requestFactory));
        granters.add((TokenGranter)new ImplicitTokenGranter(this.tokenServices, endpoints.getClientDetailsService(), requestFactory));
        granters.add((TokenGranter)new ClientCredentialsTokenGranter(this.tokenServices, endpoints.getClientDetailsService(), requestFactory));
        granters.add((TokenGranter)new ResourceOwnerPasswordTokenGranter(this.authenticationManager, this.tokenServices, endpoints.getClientDetailsService(), requestFactory));
        granters.add((TokenGranter)new SmsCodeAbstractTokenGranter(this.userDetailsService, this.authenticationManager, endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory()));
        granters.add((TokenGranter)new WeComAbstractTokenGranter(this.userDetailsService, this.authenticationManager, endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory()));
        granters.add((TokenGranter)new DingTalkAbstractTokenGranter(this.userDetailsService, this.authenticationManagers, endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory()));
        granters.add((TokenGranter)new DingTalkH5AbstractTokenGranter(this.userDetailsService, this.authenticationManagers, endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory()));
        granters.add((TokenGranter)new WxMiniappAbstractTokenGranter(this.userDetailsService, this.authenticationManager, endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory()));
        granters.add((TokenGranter)new CasAbstractTokenGranter(this.userDetailsService, this.authenticationManager, endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory()));
        granters.add((TokenGranter)new AccountPasswordAbstractTokenGranter(this.authenticationManager, endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory()));
        return new CompositeTokenGranter(granters);
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        TokenEnhancerChain tokenEnhancerChain = new TokenEnhancerChain();
        CompositeTokenGranter tokenGrater = this.getTokenGrater(endpoints);
        ArrayList<JwtTokenEnhancer> tokenEnhancer = new ArrayList<JwtTokenEnhancer>();
        tokenEnhancerChain.setTokenEnhancers(tokenEnhancer);
        tokenEnhancer.add(this.jwtTokenEnhancer);
        tokenEnhancer.add((JwtTokenEnhancer)this.jwtAccessTokenConverter);
        endpoints.authenticationManager(this.authenticationManager).tokenGranter((TokenGranter)tokenGrater).userDetailsService((UserDetailsService)this.userDetailsService).accessTokenConverter((AccessTokenConverter)this.jwtAccessTokenConverter).tokenEnhancer((TokenEnhancer)tokenEnhancerChain).pathMapping("/oauth/token", "/api/oauth/Login").tokenStore(this.tokenStore).reuseRefreshTokens(false);
    }
}

