/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.controller;

import cn.hutool.core.net.URLEncodeUtil;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.util.StringUtils;
import com.bringspring.oauth.method.cas.token.CasAuthenticationToken;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.service.SysConfigService;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/cas"})
public class CasLoginController {
    @Autowired
    private TokenEndpoint tokenEndpoint;
    @Autowired
    private SysConfigService sysConfigService;

    @NotCheckLogin
    @RequestMapping(value={"/casLogin/{terminal}/{applicationId}"})
    public String casTest(HttpSession session, @PathVariable String terminal, @PathVariable String applicationId) throws BaseException {
        OAuth2AccessToken oAuth2AccessToken;
        Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
        AttributePrincipal principal = assertion.getPrincipal();
        String loginName = principal.getName();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("account", loginName);
        parameters.put("client_id", "admin");
        parameters.put("client_secret", "e10adc3949ba59abbe56e057f20f883e");
        parameters.put("scope", "all");
        parameters.put("origin", "CasLogin");
        parameters.put("grant_type", "CasLogin");
        try {
            CasAuthenticationToken casAuthenticationToken = new CasAuthenticationToken("admin", null);
            oAuth2AccessToken = (OAuth2AccessToken)this.tokenEndpoint.postAccessToken((Principal)((Object)casAuthenticationToken), parameters).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(e.getMessage());
        }
        String systemAddress = this.sysConfigService.getSystemAddress(terminal);
        if (StringUtils.isEmpty((String)applicationId)) {
            applicationId = "all";
        }
        return "redirect:" + systemAddress + "?applicationId=" + applicationId + "&token=" + URLEncodeUtil.encodeAll((String)(oAuth2AccessToken.getTokenType() + " " + oAuth2AccessToken.getValue()));
    }
}

