/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.granter;

import cn.dev33.satoken.context.SaHolder;
import com.bringspring.common.auth.consts.DeviceType;
import com.bringspring.common.auth.granter.AbstractTokenGranter;
import com.bringspring.common.auth.granter.UserDetailsServiceBuilder;
import com.bringspring.common.auth.model.LoginTicketModel;
import com.bringspring.common.auth.util.TicketUtil;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.TenantVO;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.common.model.login.LoginVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.StringUtils;
import com.bringspring.oauth.model.SocialUnbindModel;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.oauth.util.LoginHolder;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="password")
public class PasswordTokenGranter
extends AbstractTokenGranter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordTokenGranter.class);
    public static final String GRANT_TYPE = "password";
    public static final Integer ORDER = 1;
    private static final String URL_LOGIN = "";
    @Autowired
    private UserService userApi;
    @Autowired
    protected LoginService loginService;
    @Autowired
    private UserDetailsServiceBuilder userDetailsServiceBuilder;

    public PasswordTokenGranter() {
        super(URL_LOGIN);
    }

    public PasswordTokenGranter(String authenticationUrl) {
        super(authenticationUrl);
    }

    public ActionResult<LoginVO> granter(Map<String, String> loginParameters) throws LoginException {
        LoginForm loginForm = (LoginForm)JsonUtil.getJsonToBean(loginParameters, LoginForm.class);
        UserInfo userInfo = UserProvider.getUser();
        try {
            this.switchTenant(userInfo);
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
        BaseSystemInfo baseSystemInfo = this.getSysconfig(userInfo);
        this.preAuthenticate(loginForm, userInfo, baseSystemInfo);
        super.loginAccount(userInfo, baseSystemInfo);
        LoginVO loginResult = this.getLoginVo(userInfo);
        return ActionResult.success((Object)loginResult);
    }

    public int getOrder() {
        return ORDER;
    }

    protected void preAuthenticate(LoginForm loginForm, UserInfo userInfo, BaseSystemInfo sysConfigInfo) throws LoginException {
        UserEntity userEntity = null;
        try {
            userEntity = (UserEntity)this.userDetailsServiceBuilder.getUserDetailService("USERDETAIL_UserAccount").loadUserEntity(userInfo);
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
        userInfo.setUserId(userEntity.getId());
        userInfo.setUserName(userEntity.getRealName());
        UserProvider.setLocalLoginUser((UserInfo)userInfo);
        if (Objects.nonNull(sysConfigInfo) && "1".equals(String.valueOf(sysConfigInfo.getEnableVerificationCode()))) {
            String code = loginForm.getCode();
            String timestamp = (String)this.redisUtil.getString(loginForm.getTimestamp());
            if (StringUtils.isEmpty((String)code)) {
                throw new LoginException(MsgCode.LOG103.get());
            }
            if (StringUtils.isEmpty((String)timestamp)) {
                throw new LoginException("\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String codeCache = String.valueOf(this.cacheUtil.query("loginCacheSpace", timestamp));
            if (StringUtils.isEmpty((String)codeCache)) {
                throw new LoginException(MsgCode.LOG107.get());
            }
            if (!code.toLowerCase().equals(codeCache.toLowerCase())) {
                throw new LoginException(MsgCode.LOG106.get());
            }
        }
        try {
            this.authenticate(loginForm, userEntity, sysConfigInfo);
        }
        catch (Exception e) {
            this.authenticateFailure(userEntity, sysConfigInfo);
            throw e;
        }
        LoginHolder.setUserEntity(userEntity);
    }

    protected void authenticate(LoginForm loginForm, UserEntity userEntity, BaseSystemInfo systemInfo) throws LoginException {
        this.authenticateLock(userEntity, systemInfo);
        this.authenticatePassword(loginForm, userEntity, systemInfo);
        this.loginService.isExistUser(userEntity, systemInfo);
    }

    protected void authenticateLock(UserEntity userEntity, BaseSystemInfo systemInfo) throws LoginException {
        Integer lockMark = userEntity.getEnabledMark();
        if (Objects.nonNull(lockMark) && lockMark == 2) {
            Date unlockTime = userEntity.getUnlockTime();
            if (systemInfo.getLockType() == 1 || Objects.isNull(unlockTime)) {
                throw new LoginException(MsgCode.LOG012.get());
            }
            long millis = System.currentTimeMillis();
            if (unlockTime.getTime() > millis) {
                int time = (int)((unlockTime.getTime() - millis) / 60000L);
                throw new LoginException(MsgCode.LOG108.get(new Object[]{time + 1}));
            }
            if (unlockTime.getTime() < millis && userEntity.getLogErrorCount() >= systemInfo.getPasswordErrorsNumber()) {
                userEntity.setLogErrorCount(Integer.valueOf(0));
                userEntity.setEnabledMark(Integer.valueOf(1));
                this.userApi.updateById((Object)userEntity);
            }
        }
    }

    protected void authenticatePassword(LoginForm loginForm, UserEntity userEntity, BaseSystemInfo systemInfo) throws LoginException {
        String inputPwd = loginForm.getPassword();
        if (!this.matches(inputPwd, userEntity.getSecretkey(), userEntity.getPassword())) {
            throw new LoginException(MsgCode.LOG101.get());
        }
    }

    public boolean matches(CharSequence rawEncoder, String secretkey, String encoder) {
        return encoder.equals(Md5Util.getStringMd5((String)(String.valueOf(rawEncoder) + secretkey.toLowerCase())));
    }

    protected void authenticateFailure(UserEntity entity, BaseSystemInfo sysConfigInfo) {
        Integer errorsNumber;
        if (entity != null && !"admin".equals(entity.getAccount()) && (errorsNumber = sysConfigInfo.getPasswordErrorsNumber()) != null && errorsNumber > 2) {
            Integer errorCount = entity.getLogErrorCount() != null ? entity.getLogErrorCount() + 1 : 1;
            entity.setLogErrorCount(errorCount);
            Integer lockType = sysConfigInfo.getLockType();
            if (errorCount >= errorsNumber) {
                entity.setEnabledMark(Integer.valueOf(2));
                if (Objects.nonNull(lockType) && lockType == 2) {
                    Integer lockTime = sysConfigInfo.getLockTime();
                    Date date = new Date(System.currentTimeMillis() + (long)(lockTime * 60 * 1000));
                    entity.setUnlockTime(date);
                }
            }
            if (lockType == 1) {
                entity.setUnlockTime(null);
            }
            this.userApi.updateById((Object)entity);
        }
    }

    protected void preLogin(UserInfo userInfo, BaseSystemInfo baseSystemInfo) throws LoginException {
    }

    protected void loginSuccess(UserInfo userInfo, BaseSystemInfo baseSystemInfo) {
        String Client_Id;
        SocialUnbindModel jsonToBean;
        String ticket;
        LoginTicketModel ticketModel;
        super.loginSuccess(userInfo, baseSystemInfo);
        if (!SaHolder.getRequest().hasParam("jsbos_ticket") || (ticketModel = (LoginTicketModel)TicketUtil.parseTicket((String)(ticket = SaHolder.getRequest().getParam("jsbos_ticket")))) == null || (jsonToBean = (SocialUnbindModel)JsonUtil.getJsonToBean((String)ticketModel.getValue(), SocialUnbindModel.class)) != null) {
            // empty if block
        }
        if (!(SaHolder.getRequest().hasParam("Client_Id") && StringUtils.isNotBlank((CharSequence)(Client_Id = SaHolder.getRequest().getParam("Client_Id"))) && "null".equals(Client_Id))) {
            // empty if block
        }
    }

    protected LoginVO getLoginVo(UserInfo userInfo) {
        TenantVO tenantVO;
        LoginVO loginVO = new LoginVO();
        loginVO.setTheme(userInfo.getTheme());
        loginVO.setToken(userInfo.getToken());
        if (this.configValueUtil.isMultiTenancy() && (tenantVO = TenantDataSourceUtil.getCacheTenantInfo((String)userInfo.getTenantId())) != null && tenantVO.getWl_qrcode() != null) {
            loginVO.setWl_qrcode(tenantVO.getWl_qrcode());
            tenantVO.setWl_qrcode(null);
            TenantDataSourceUtil.setTenantInfo((TenantVO)tenantVO);
        }
        return loginVO;
    }

    public ActionResult logout() {
        UserInfo userInfo = UserProvider.getUser();
        if (userInfo.getUserId() != null) {
            if ("1".equals(String.valueOf(this.loginSatokenService.getBaseSystemConfig(userInfo.getTenantId()).getSingleLogin()))) {
                UserProvider.logoutByUserId((String)userInfo.getUserId(), (DeviceType)DeviceType.valueOf((String)userInfo.getLoginDevice()));
            } else {
                UserProvider.logoutByToken((String)userInfo.getToken());
            }
        }
        return ActionResult.success((String)MsgCode.OA014.get());
    }

    protected String getGrantType() {
        return GRANT_TYPE;
    }

    protected String getUserDetailKey() {
        return "USERDETAIL_UserAccount";
    }
}

