/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.service.impl;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.bringspring.common.auth.granter.UserDetailsServiceBuilder;
import com.bringspring.common.auth.service.LoginSatokenService;
import com.bringspring.common.auth.service.ThirdPartyAuthService;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.TenantVO;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.exception.TenantDatabaseException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.PcUserVO;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.RequestContext;
import com.bringspring.oauth.util.LoginHolder;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.LogService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginSatokenServiceImpl
implements LoginSatokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginSatokenServiceImpl.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private UserDetailsServiceBuilder userDetailsServiceBuilder;
    @Autowired
    private ThirdPartyAuthService thirdPartyAuthService;
    @Autowired
    private LogService logService;

    public UserInfo getTenantAccount(UserInfo userInfo) throws LoginException {
        String tenantId = null;
        if (this.configValueUtil.isMultiTenancy()) {
            String[] tenantAccount = userInfo.getUserAccount().split("\\@");
            if (tenantAccount.length == 1) {
                String apiHost;
                String remoteHost;
                String referer = ServletUtil.getHeader((String)"Referer");
                if (StringUtils.isNotEmpty((String)referer) && !ObjectUtil.equals((Object)(remoteHost = UrlBuilder.of((String)referer).getHost()), (Object)(apiHost = UrlBuilder.of((String)(RequestContext.isOrignPc() ? this.configValueUtil.getFrontDomain() : this.configValueUtil.getAppDomain())).getHost())) && remoteHost.endsWith(apiHost)) {
                    tenantId = remoteHost.split("\\.")[0];
                    userInfo.setUserAccount(tenantAccount[0]);
                }
                if (tenantId == null) {
                    tenantId = tenantAccount[0];
                    userInfo.setUserAccount("admin");
                }
            } else {
                tenantId = tenantAccount[0];
                userInfo.setUserAccount(tenantAccount[1]);
            }
            if (StringUtils.isEmpty((String)tenantId) || tenantAccount.length > 2 || StringUtils.isEmpty((String)userInfo.getUserAccount())) {
                throw new LoginException(MsgCode.LOG102.get());
            }
            TenantVO tenantVO = TenantDataSourceUtil.getRemoteTenantInfo((String)tenantId);
            TenantDataSourceUtil.switchTenant((String)tenantId, (TenantVO)tenantVO);
            userInfo.setTenantId(tenantId);
            userInfo.setTenantDbConnectionString(tenantVO.getDbName());
            userInfo.setTenantDbType(tenantVO.getType());
            BaseSystemInfo baseSystemInfo = null;
            try {
                baseSystemInfo = this.getBaseSystemConfig(userInfo.getTenantId());
            }
            catch (Exception e) {
                log.error("\u767b\u5f55\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u5931\u8d25: {}", (Object)e.getMessage());
            }
            if (baseSystemInfo == null || baseSystemInfo.getSingleLogin() == null) {
                throw new TenantDatabaseException();
            }
        }
        return userInfo;
    }

    public UserInfo userInfo(UserInfo userInfo, BaseSystemInfo sysConfigInfo) throws LoginException {
        String time;
        UserEntity userEntity = LoginHolder.getUserEntity();
        if (userEntity == null) {
            userEntity = (UserEntity)this.userDetailsServiceBuilder.getUserDetailService(userInfo.getUserDetailKey()).loadUserEntity(userInfo);
            LoginHolder.setUserEntity(userEntity);
        }
        this.checkUser(userEntity, userInfo, sysConfigInfo);
        userInfo.setUserId(userEntity.getId());
        userInfo.setUserAccount(userEntity.getAccount());
        userInfo.setUserName(userEntity.getRealName());
        userInfo.setUserIcon(userEntity.getHeadIcon());
        userInfo.setTheme(userEntity.getTheme());
        userInfo.setOrganizeId(userEntity.getOrganizeId());
        userInfo.setPortalId(userEntity.getPortalId());
        userInfo.setIsAdministrator(Boolean.valueOf(BooleanUtil.toBoolean((String)String.valueOf(userEntity.getIsAdministrator()))));
        if (!"admin".equals(userInfo.getUserAccount())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty((String)(time = sysConfigInfo.getTokenTimeout()))) {
            Integer minu = Integer.valueOf(time);
            userInfo.setOverdueTime(DateUtil.dateAddMinutes(null, (int)minu));
            userInfo.setTokenTimeout(minu);
        }
        String ipAddr = IpUtil.getIpAddr();
        userInfo.setLoginIpAddress(ipAddr);
        userInfo.setLoginIpAddressName(IpUtil.getIpCity((String)ipAddr));
        userInfo.setLoginTime(DateUtil.getmmNow());
        UserAgent userAgent = UserAgentUtil.parse((String)ServletUtil.getUserAgent());
        if (userAgent != null) {
            userInfo.setLoginPlatForm(userAgent.getPlatform().getName() + " " + userAgent.getOsVersion());
            userInfo.setBrowser(userAgent.getBrowser().getName() + " " + userAgent.getVersion());
        }
        userInfo.setPrevLoginTime(userEntity.getPrevLogTime());
        userInfo.setPrevLoginIpAddress(userEntity.getPrevLogIp());
        userInfo.setPrevLoginIpAddressName(IpUtil.getIpCity((String)userEntity.getPrevLogIp()));
        String token = RandomUtil.uuId();
        userInfo.setId(this.cacheKeyUtil.getLoginToken(userInfo.getTenantId()) + token);
        this.createUserOnline(userInfo);
        return userInfo;
    }

    public PcUserVO getCurrentUser(String type, String systemCode, Integer isBackend) {
        return null;
    }

    private void createUserOnline(UserInfo userInfo) {
        String userId = userInfo.getUserId();
        String authorize = String.valueOf(this.redisUtil.getString(this.cacheKeyUtil.getUserAuthorize() + userId));
        this.redisUtil.remove(authorize);
        if (ServletUtil.getIsMobileDevice() && ServletUtil.getHeader((String)"clientId") != null) {
            String clientId = ServletUtil.getHeader((String)"clientId");
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put(userInfo.getUserId(), clientId);
            this.redisUtil.insert(this.cacheKeyUtil.getMobileDeviceList(), map);
        }
    }

    public UserEntity checkUser(UserEntity userEntity, UserInfo userInfo, BaseSystemInfo sysConfigInfo) throws LoginException {
        List<String> ipList;
        if (userEntity == null) {
            throw new LoginException(MsgCode.LOG101.get());
        }
        if (!"admin".equals(userEntity.getAccount()) || userEntity.getIsAdministrator() != 1) {
            ArrayList arrayList = new ArrayList();
        }
        if (userEntity.getIsAdministrator() == 0) {
            if (userEntity.getEnabledMark() == null) {
                throw new LoginException(MsgCode.LOG005.get());
            }
            if (userEntity.getEnabledMark() == 0) {
                throw new LoginException(MsgCode.LOG006.get());
            }
        }
        if (userEntity.getDeleteMark() != null && userEntity.getDeleteMark() == 1) {
            throw new LoginException(MsgCode.LOG007.get());
        }
        String ipAddr = IpUtil.getIpAddr();
        userInfo.setLoginIpAddress(IpUtil.getIpAddr());
        if (!"admin".equals(userEntity.getAccount()) && "1".equals(sysConfigInfo.getWhitelistSwitch()) && !(ipList = Arrays.asList(sysConfigInfo.getWhitelistIp().split(","))).contains(ipAddr)) {
            throw new LoginException(MsgCode.LOG010.get());
        }
        Integer lockMark = userEntity.getEnabledMark();
        if (Objects.nonNull(lockMark) && lockMark == 2) {
            int logErrorCount;
            Date unlockTime = userEntity.getUnlockTime();
            if (sysConfigInfo.getLockType() == 1 || Objects.isNull(unlockTime)) {
                throw new LoginException(MsgCode.LOG012.get());
            }
            long millis = System.currentTimeMillis();
            int passwordErrorsNumber = sysConfigInfo.getPasswordErrorsNumber() != null ? sysConfigInfo.getPasswordErrorsNumber() : 0;
            int n = logErrorCount = userEntity.getLogErrorCount() != null ? userEntity.getLogErrorCount() : 0;
            if (unlockTime.getTime() > millis) {
                int time = (int)((unlockTime.getTime() - millis) / 60000L);
                throw new LoginException(MsgCode.LOG108.get(new Object[]{time + 1}));
            }
            if (unlockTime.getTime() < millis && logErrorCount >= passwordErrorsNumber) {
                userEntity.setLogErrorCount(Integer.valueOf(0));
                userEntity.setEnabledMark(Integer.valueOf(1));
                this.userService.updateById((Object)userEntity);
            }
        }
        return userEntity;
    }

    public void updatePasswordMessage() {
        UserInfo userInfo = UserProvider.getUser();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        BaseSystemInfo baseSystemInfo = this.sysConfigService.getSysInfo();
        if (baseSystemInfo.getPasswordIsUpdatedRegularly() == 1) {
            Date changePasswordDate = userEntity.getCreatorTime();
            if (userEntity.getChangePasswordDate() != null) {
                changePasswordDate = userEntity.getChangePasswordDate();
            }
            Date nowDate = DateUtil.getNowDate();
            Integer updateCycle = baseSystemInfo.getUpdateCycle();
            Integer updateInAdvance = baseSystemInfo.getUpdateInAdvance();
            Integer day = DateUtil.getDiffDays((Date)changePasswordDate, (Date)nowDate);
            if (day >= updateCycle - updateInAdvance) {
                // empty if block
            }
        }
    }

    public BaseSystemInfo getBaseSystemConfig(String tenantId) {
        if (tenantId != null) {
            TenantDataSourceUtil.switchTenant((String)tenantId);
        }
        return this.sysConfigService.getSysInfo();
    }

    public String getConfigByKeyName(String keyName) {
        SysConfigEntity sysConfigEntity;
        if (keyName == null || keyName.trim().isEmpty()) {
            throw new LoginException("\u83b7\u53d6SysConfig\u914d\u7f6e\u5931\u8d25\uff1a\u914d\u7f6e\u952e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            sysConfigEntity = this.sysConfigService.getConfigByKeyName(keyName);
        }
        catch (BaseException e) {
            log.error("\u6839\u636e\u952e\u540d[{}]\u67e5\u8be2SysConfig\u914d\u7f6e\u5931\u8d25", (Object)keyName, (Object)e);
            throw new LoginException("\u83b7\u53d6SysConfig\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u952e\u540d[{}]\u67e5\u8be2SysConfig\u914d\u7f6e\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38", (Object)keyName, (Object)e);
            throw new LoginException("\u83b7\u53d6SysConfig\u914d\u7f6e\u5931\u8d25\uff1a\u7cfb\u7edf\u5f02\u5e38", (Object)e);
        }
        if (ObjectUtil.isEmpty((Object)sysConfigEntity)) {
            log.warn("\u6839\u636e\u952e\u540d[{}]\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684SysConfig\u914d\u7f6e", (Object)keyName);
            throw new LoginException("\u83b7\u53d6SysConfig\u914d\u7f6e\u5931\u8d25\uff1a\u672a\u627e\u5230\u952e\u540d\u4e3a[" + keyName + "]\u7684\u914d\u7f6e");
        }
        String keyValue = sysConfigEntity.getKeyValue();
        if (keyValue == null || keyValue.trim().isEmpty()) {
            log.warn("\u952e\u540d[{}]\u5bf9\u5e94\u7684SysConfig\u914d\u7f6e\u503c\u4e3a\u7a7a", (Object)keyName);
            throw new LoginException("\u83b7\u53d6SysConfig\u914d\u7f6e\u5931\u8d25\uff1a\u952e\u540d\u4e3a[" + keyName + "]\u7684\u914d\u7f6e\u503c\u4e3a\u7a7a");
        }
        return keyValue;
    }
}

