package com.bringspring.oauth.service;

import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.systemconfig.SysConfigCropModel;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.common.model.login.PcUserVO;
import com.bringspring.oauth.model.LoginBySignUpModel;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.permission.entity.UserEntity;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
public interface LoginService {

    /**
     * 租戶登录验证
     *
     * @param loginForm
     * @return
     * @throws LoginException
     */
    UserInfo checkTenant(LoginForm loginForm) throws LoginException;

    /**
     * 获取用户信息
     *
     * @param userInfoVo
     * @return
     */
    UserInfo userInfo(UserInfo userInfo, UserEntity userInfoVo, BaseSystemInfo sysConfigInfo) throws LoginException;

    /**
     * 验证账号是否可以使用
     *
     * @param userEntity
     * @return
     * @throws LoginException
     */
    void isExistUser(UserEntity userEntity, BaseSystemInfo sysConfigInfo) throws LoginException;

    /**
     * 用户统一登录操作
     * 组装用户信息
     *
     * @param userEntity
     * @return
     * @throws LoginException
     */
    UserInfo loginProcess(UserEntity userEntity) throws LoginException;

    /**
     * 组装登录信息
     *
     * @return
     * @throws LoginException
     */
    void loginUpdateUser(String token) throws LoginException;

    /**
     * 获取用户登陆信息
     *
     * @return
     */
    PcUserVO getCurrentUser(String type, String appliactionId) throws BaseException;


    /**
     * 获取打开的网页的用户身份信息
     *
     * @param weComCode 构造网页授权链接获取code参数
     * @param cropId    企业的CorpID
     * @return
     * @throws Exception
     */
    String getAccountByQywechat(String weComCode, String cropId) throws LoginException;

    /**
     * @param dingCode
     * @return
     * @throws Exception
     */
    String getAccountByDingCode(String dingCode, SysConfigCropModel sysConfigCropModel) throws LoginException;

    String getAccountByDingCodeH5(String dingCode, SysConfigCropModel sysConfigCropModel) throws LoginException;

    /**
     * 根据微信小程序授权code获取系统账户
     *
     * @return
     * @throws Exception
     */
    String getAccountByWxMiniappCode(LoginBySignUpModel loginBySignUpModel) throws LoginException;

}
