/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.granter;

import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import com.bringspring.common.auth.consts.DeviceType;
import com.bringspring.common.auth.granter.AbstractTokenGranter;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginVO;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="tempuser")
public class TempUserTokenGranter
extends AbstractTokenGranter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TempUserTokenGranter.class);
    public static final String GRANT_TYPE = "tempuser";
    public static final Integer ORDER = 4;
    private static final String URL_LOGIN = "";

    public TempUserTokenGranter() {
        super(URL_LOGIN);
    }

    public ActionResult granter(Map<String, String> loginParameters) throws LoginException {
        String token = loginParameters.get("token");
        if (!UserProvider.isValidInnerToken((String)token)) {
            throw new LoginException(MsgCode.OA018.get());
        }
        String userId = loginParameters.get("userId");
        String tenantId = loginParameters.get("tenantId");
        boolean limited = Boolean.valueOf(loginParameters.get("limited"));
        String device = limited ? DeviceType.TEMPUSERLIMITED.getDevice() : DeviceType.TEMPUSER.getDevice();
        UserInfo userInfo = limited ? UserProvider.getUser((String)userId, (String)tenantId, Arrays.asList(DeviceType.TEMPUSERLIMITED.getDevice()), null) : UserProvider.getUser((String)userId, (String)tenantId, null, Arrays.asList(DeviceType.TEMPUSERLIMITED.getDevice()));
        if (userInfo.getUserId() != null) {
            return ActionResult.success((Object)this.getLoginVo(userInfo));
        }
        userInfo = UserProvider.getUser();
        userInfo.setUserAccount(tenantId);
        userInfo.setUserId(userId);
        this.switchTenant(userInfo);
        BaseSystemInfo baseSystemInfo = this.getSysconfig(userInfo);
        userInfo.setLoginDevice(device);
        super.loginAccount(userInfo, baseSystemInfo);
        LoginVO loginResult = this.getLoginVo(userInfo);
        return ActionResult.success((Object)loginResult);
    }

    public int getOrder() {
        return ORDER;
    }

    protected void preLogin(UserInfo userInfo, BaseSystemInfo baseSystemInfo) throws LoginException {
    }

    protected void login(UserInfo userInfo, BaseSystemInfo baseSystemInfo) throws LoginException {
        UserProvider.loginNoRequest((UserInfo)userInfo, (SaLoginParameter)this.getLoginModel(userInfo, baseSystemInfo));
    }

    protected void loginSuccess(UserInfo userInfo, BaseSystemInfo baseSystemInfo) {
        super.loginSuccess(userInfo, baseSystemInfo);
    }

    protected DeviceType getDeviceType() {
        return DeviceType.TEMPUSER;
    }

    protected LoginVO getLoginVo(UserInfo userInfo) {
        LoginVO loginVO = new LoginVO();
        loginVO.setTheme(userInfo.getTheme());
        loginVO.setToken(userInfo.getToken());
        return loginVO;
    }

    public ActionResult logout() {
        UserInfo userInfo = UserProvider.getUser();
        if (UserProvider.isTempUser((UserInfo)userInfo)) {
            UserProvider.logoutByToken((String)userInfo.getToken());
        }
        return ActionResult.success((String)MsgCode.OA014.get());
    }

    protected String getGrantType() {
        return GRANT_TYPE;
    }

    protected String getUserDetailKey() {
        return "USERDETAIL_UserId";
    }
}

