/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.util;

import com.bringspring.common.util.StringUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.util.Timeout;

public class HttpUtils {
    private static final RequestConfig DEFAULT_REQUEST_CONFIG = RequestConfig.custom().setResponseTimeout(Timeout.of((long)30L, (TimeUnit)TimeUnit.SECONDS)).setConnectTimeout(Timeout.of((long)30L, (TimeUnit)TimeUnit.SECONDS)).setConnectionRequestTimeout(Timeout.of((long)30L, (TimeUnit)TimeUnit.SECONDS)).build();

    public static CloseableHttpResponse doGet(String host, String path, String method, Map<String, String> headers, Map<String, String> querys) throws Exception {
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(host);){
            HttpGet request = new HttpGet(HttpUtils.buildUri(host, path, querys));
            HttpUtils.addHeaders((HttpUriRequestBase)request, headers);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((ClassicHttpRequest)request);
            return closeableHttpResponse;
        }
    }

    public static CloseableHttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys) throws Exception {
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(host);){
            HttpPost request = new HttpPost(HttpUtils.buildUri(host, path, querys));
            HttpUtils.addHeaders((HttpUriRequestBase)request, headers);
            if (bodys != null && !bodys.isEmpty()) {
                StringBuilder formData = new StringBuilder();
                for (Map.Entry<String, String> entry : bodys.entrySet()) {
                    if (formData.length() > 0) {
                        formData.append("&");
                    }
                    formData.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name()));
                    formData.append("=");
                    formData.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                }
                StringEntity entity = new StringEntity(formData.toString(), ContentType.APPLICATION_FORM_URLENCODED);
                request.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((ClassicHttpRequest)request);
            return closeableHttpResponse;
        }
    }

    public static CloseableHttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, String body) throws Exception {
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(host);){
            HttpPost request = new HttpPost(HttpUtils.buildUri(host, path, querys));
            HttpUtils.addHeaders((HttpUriRequestBase)request, headers);
            if (StringUtils.isNotEmpty((String)body)) {
                StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
                request.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((ClassicHttpRequest)request);
            return closeableHttpResponse;
        }
    }

    public static CloseableHttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, byte[] body) throws Exception {
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(host);){
            HttpPost request = new HttpPost(HttpUtils.buildUri(host, path, querys));
            HttpUtils.addHeaders((HttpUriRequestBase)request, headers);
            if (body != null) {
                ByteArrayEntity entity = new ByteArrayEntity(body, ContentType.APPLICATION_OCTET_STREAM);
                request.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((ClassicHttpRequest)request);
            return closeableHttpResponse;
        }
    }

    public static CloseableHttpResponse doPut(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, String body) throws Exception {
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(host);){
            HttpPut request = new HttpPut(HttpUtils.buildUri(host, path, querys));
            HttpUtils.addHeaders((HttpUriRequestBase)request, headers);
            if (StringUtils.isNotEmpty((String)body)) {
                StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
                request.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((ClassicHttpRequest)request);
            return closeableHttpResponse;
        }
    }

    public static CloseableHttpResponse doPut(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, byte[] body) throws Exception {
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(host);){
            HttpPut request = new HttpPut(HttpUtils.buildUri(host, path, querys));
            HttpUtils.addHeaders((HttpUriRequestBase)request, headers);
            if (body != null) {
                ByteArrayEntity entity = new ByteArrayEntity(body, ContentType.APPLICATION_OCTET_STREAM);
                request.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((ClassicHttpRequest)request);
            return closeableHttpResponse;
        }
    }

    public static CloseableHttpResponse doDelete(String host, String path, String method, Map<String, String> headers, Map<String, String> querys) throws Exception {
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(host);){
            HttpDelete request = new HttpDelete(HttpUtils.buildUri(host, path, querys));
            HttpUtils.addHeaders((HttpUriRequestBase)request, headers);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((ClassicHttpRequest)request);
            return closeableHttpResponse;
        }
    }

    private static URI buildUri(String host, String path, Map<String, String> querys) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(host + path);
        if (querys != null) {
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (!StringUtils.isNotEmpty((String)query.getKey()) || !StringUtils.isNotEmpty((String)query.getValue())) continue;
                uriBuilder.addParameter(query.getKey(), query.getValue());
            }
        }
        return uriBuilder.build();
    }

    private static CloseableHttpClient createHttpClient(String host) throws Exception {
        if (host.startsWith("https://")) {
            return HttpUtils.createSSLHttpClient();
        }
        return HttpClients.custom().setDefaultRequestConfig(DEFAULT_REQUEST_CONFIG).build();
    }

    private static CloseableHttpClient createSSLHttpClient() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContext).build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        return HttpClients.custom().setDefaultRequestConfig(DEFAULT_REQUEST_CONFIG).setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    private static void addHeaders(HttpUriRequestBase request, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.addHeader(header.getKey(), (Object)header.getValue());
            }
        }
    }

    public static String getResponseContent(CloseableHttpResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            String string = EntityUtils.toString((HttpEntity)entity);
            return string;
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse response entity", e);
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
            response.close();
        }
    }

    public static Integer getUrlLength(String urlStr) {
        Integer length = 0;
        try (InputStream is = new URL(urlStr).openStream();
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            int charsRead;
            StringBuffer sb = new StringBuffer();
            char[] c = new char[10240];
            while ((charsRead = br.read(c)) != -1) {
                sb.append(c, 0, charsRead);
            }
            length = sb.toString().length();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return length;
    }

    public static void main(String[] args) throws Exception {
        String text = "https://open.work.weixin.qq.com/wwopen/sso/qrConnect?";
        int width = 400;
        int height = 400;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        File outputFile = new File("D:\\\u9080\u8bf7\u4e8c\u7ef4\u7801" + File.separator + "20210013.jpg");
    }
}

