package com.bringspring.oauth.service.impl;

import com.bringspring.common.auth.consts.AuthConsts;
import com.bringspring.common.auth.service.UserDetailService;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.LoginException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 默认使用用户名获取用户信息
 */
@Service(AuthConsts.USERDETAIL_ACCOUNT)
public class UserDetailsByUserAccountServiceImpl implements UserDetailService {

    @Autowired
    private UserService userApi;

    @Override
    public UserEntity loadUserEntity(UserInfo userInfo) throws LoginException {
        UserEntity userEntity = userApi.getUserByAccount(userInfo.getUserAccount());
        if (userEntity == null) {
            throw new LoginException(MsgCode.LOG101.get());
        }
        return userEntity;
    }


    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

}
