/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.granter;

import com.bringspring.common.auth.consts.DeviceType;
import com.bringspring.common.auth.granter.AbstractTokenGranter;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginVO;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scancode")
public class ScanCodeTokenGranter
extends AbstractTokenGranter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScanCodeTokenGranter.class);
    public static final String GRANT_TYPE = "scancode";
    public static final Integer ORDER = 5;
    private static final String URL_LOGIN = "";
    @Autowired
    protected ConfigValueUtil configValueUtil;

    public ScanCodeTokenGranter() {
        super(URL_LOGIN);
    }

    public ActionResult granter(Map<String, String> loginParameters) throws LoginException {
        String token = loginParameters.get("token");
        UserInfo userInfo = UserProvider.getUser((String)token);
        if (this.configValueUtil.isMultiTenancy()) {
            userInfo.setUserAccount(userInfo.getTenantId() + "@" + userInfo.getUserAccount());
        }
        this.switchTenant(userInfo);
        BaseSystemInfo baseSystemInfo = this.getSysconfig(userInfo);
        super.loginAccount(userInfo, baseSystemInfo);
        LoginVO loginResult = this.getLoginVo(userInfo);
        return ActionResult.success((Object)loginResult);
    }

    public int getOrder() {
        return ORDER;
    }

    protected LoginVO getLoginVo(UserInfo userInfo) {
        LoginVO loginVO = new LoginVO();
        loginVO.setTheme(userInfo.getTheme());
        loginVO.setToken(userInfo.getToken());
        return loginVO;
    }

    public ActionResult logout() {
        UserInfo userInfo = UserProvider.getUser();
        if (userInfo.getUserId() != null) {
            if ("1".equals(String.valueOf(this.loginSatokenService.getBaseSystemConfig(userInfo.getTenantId()).getSingleLogin()))) {
                UserProvider.logoutByUserId((String)userInfo.getUserId(), (DeviceType)DeviceType.valueOf((String)userInfo.getLoginDevice()));
            } else {
                UserProvider.logoutByToken((String)userInfo.getToken());
            }
        }
        return ActionResult.success((String)MsgCode.OA014.get());
    }

    protected String getGrantType() {
        return GRANT_TYPE;
    }

    protected String getUserDetailKey() {
        return "USERDETAIL_UserId";
    }
}

