/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.service.impl;

import com.bringspring.common.auth.granter.TokenGranter;
import com.bringspring.common.auth.granter.TokenGranterBuilder;
import com.bringspring.common.auth.util.TenantProvider;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.exception.TenantDatabaseException;
import com.bringspring.common.exception.TenantInvalidException;
import com.bringspring.common.model.login.LoginVO;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.oauth.service.AuthService;
import com.bringspring.oauth.util.LoginHolder;
import com.bringspring.system.base.service.LogService;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    @Autowired
    private TokenGranterBuilder tokenGranterBuilder;
    @Autowired
    private LogService logApi;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public ActionResult<LoginVO> login(Map<String, String> parameters) throws LoginException {
        ActionResult result;
        long millis = System.currentTimeMillis();
        String grantType = parameters.getOrDefault("grant_type", "");
        TokenGranter tokenGranter = this.tokenGranterBuilder.getGranter(grantType);
        UserInfo userInfo = new UserInfo();
        try {
            String account = parameters.get("account");
            userInfo.setUserAccount(account);
            UserProvider.setLocalLoginUser((UserInfo)userInfo);
            result = tokenGranter.granter(parameters);
            if (userInfo.getUserId() != null && !UserProvider.isTempUser((UserInfo)userInfo)) {
                this.logApi.writeLogAsync(userInfo.getUserId(), userInfo.getUserName() + "/" + userInfo.getUserAccount(), MsgCode.OA015.get(), System.currentTimeMillis() - millis);
            }
        }
        catch (TenantDatabaseException tdex) {
            throw tdex;
        }
        catch (Exception e) {
            if (!(e instanceof LoginException) && !(e instanceof TenantInvalidException)) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = MsgCode.OA007.get();
                }
                log.error("{}, Account: {}, Error: {}", new Object[]{MsgCode.OA007.get(), parameters.getOrDefault("account", ""), e.getMessage(), e});
                throw new LoginException(msg);
            }
            String userName = StringUtils.isNotEmpty((String)userInfo.getUserName()) ? userInfo.getUserName() + "/" + userInfo.getUserAccount() : userInfo.getUserAccount();
            this.logApi.writeLogAsync(userInfo.getUserId(), userName, e.getMessage(), userInfo, 0, null, System.currentTimeMillis() - millis);
            throw e;
        }
        finally {
            LoginHolder.clearUserEntity();
            TenantProvider.clearBaseSystemIfo();
            String imgCode = parameters.get("timestamp");
            if (StringUtils.isNotEmpty((String)imgCode)) {
                this.redisUtil.remove(imgCode);
            }
        }
        return result;
    }

    @Override
    public ActionResult kickoutByToken(String ... tokens) {
        UserProvider.kickoutByToken((String[])tokens);
        return ActionResult.success();
    }

    @Override
    public ActionResult kickoutByUserId(String userId, String tenantId) {
        UserProvider.kickoutByUserId((String)userId, (String)tenantId);
        return ActionResult.success();
    }
}

