/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.util;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.LoginVO;
import com.bringspring.common.util.Constants;
import com.bringspring.common.util.TenantHolder;
import com.bringspring.oauth.service.AuthService;
import com.bringspring.system.base.exception.LoginException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthUtil.class);
    public static AuthService authApi;

    @Autowired
    public void setAuthApi(AuthService authApi) {
        AuthUtil.authApi = authApi;
    }

    public static String loginTempUser(String userId, String tenantId) {
        return AuthUtil.loginTempUser(userId, tenantId, false);
    }

    public static String loginTempUser(String userId, String tenantId, boolean limited) {
        ImmutableMap loginInfo = ImmutableMap.of((Object)"grant_type", (Object)"tempuser", (Object)"token", (Object)UserProvider.getInnerAuthToken(), (Object)"userId", (Object)userId, (Object)"tenantId", (Object)Optional.ofNullable(tenantId).orElse(""), (Object)"limited", (Object)String.valueOf(limited));
        ActionResult<LoginVO> result = authApi.login((Map<String, String>)loginInfo);
        if (Constants.SUCCESS.equals(result.getCode())) {
            return ((LoginVO)result.getData()).getToken();
        }
        log.error("\u767b\u5f55\u4e34\u65f6\u7528\u6237\u5931\u8d25: {}", (Object)result.getMsg());
        throw new LoginException(result.getMsg());
    }

    public static void kickoutByToken(String ... tokens) {
        authApi.kickoutByToken(tokens);
    }

    public static void kickoutByUserId(String userId) {
        String tenantId = TenantHolder.getDatasourceId();
        if (tenantId == null) {
            UserInfo userInfo = UserProvider.getUser();
            if (userInfo.getUserId() == null) {
                throw new RuntimeException("\u8bf7\u8bbe\u7f6eUserInfo");
            }
            tenantId = userInfo.getTenantId();
        }
        authApi.kickoutByUserId(userId, tenantId);
    }
}

