package com.bringspring.oauth.config;

import com.bringspring.oauth.method.cas.provider.CasAuthenticationProvider;
import com.bringspring.oauth.method.dingding.provider.DingTalkAuthenticationProvider;
import com.bringspring.oauth.method.dingdingH5.provider.DingTalkH5AuthenticationProvider;
import com.bringspring.oauth.method.password.provider.AccountPasswordAuthenticationProvider;
import com.bringspring.oauth.method.qywechat.provider.WeComAuthenticationProvider;
import com.bringspring.oauth.method.sms.provider.SmsCodeAuthenticationProvider;
import com.bringspring.oauth.method.wxminiapp.provider.WxMiniappAuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
@Configuration
@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter {

    @Autowired
    private WeComAuthenticationProvider weComAuthenticationProvider;
    @Autowired
    private SmsCodeAuthenticationProvider smsCodeAuthenticationProvider;
    @Autowired
    private AccountPasswordAuthenticationProvider passwordAuthenticationProvider;

    @Autowired
    private DingTalkAuthenticationProvider dingTalkAuthenticationProvider;

    @Autowired
    private DingTalkH5AuthenticationProvider dingTalkH5AuthenticationProvider;
    @Autowired
    private WxMiniappAuthenticationProvider wxMiniappAuthenticationProvider;
    @Autowired
    private CasAuthenticationProvider casAuthenticationProvider;

    /**
     * 配置请求路径
     *
     * @param http
     * @throws Exception
     */
    @Override
    protected void configure(HttpSecurity http) throws Exception {
        //解决iframe拒绝问题
        http.headers().frameOptions().disable();
        http.csrf().disable().authorizeRequests().antMatchers("/RSA/publicKey").permitAll();
    }

    /**
     * 保证成功刷新token
     *
     * @param auth
     * @throws Exception
     */
    @Autowired
    public void globalUserDetails(AuthenticationManagerBuilder auth) throws Exception {
        // 用户来源于数据库
        auth.authenticationProvider(smsCodeAuthenticationProvider);
        auth.authenticationProvider(passwordAuthenticationProvider);
        auth.authenticationProvider(weComAuthenticationProvider);
        auth.authenticationProvider(dingTalkAuthenticationProvider);
        auth.authenticationProvider(dingTalkH5AuthenticationProvider);
        auth.authenticationProvider(wxMiniappAuthenticationProvider);
        auth.authenticationProvider(casAuthenticationProvider);

    }

    @Bean
    @Override
    public AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }

}
