package com.bringspring.oauth.model;

import com.bringspring.common.model.login.MenuTreeVO;
import com.bringspring.common.model.login.PermissionModel;
import com.bringspring.common.model.login.UserCommonInfoVO;
import com.bringspring.system.base.model.module.ModuleModel;
import com.bringspring.system.base.model.systemconfig.SystemInfo;
import lombok.Builder;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:54
 */
@Builder
public class PcUserVO {

    private List<ModuleModel> systemList;
    private List<MenuTreeVO> menuList;
    private List<PermissionModel> permissionList;
    private UserCommonInfoVO userInfo;

    /**
     * 系统配置
     */
    private SystemInfo sysConfigInfo;

    public PcUserVO() {
    }

    public PcUserVO(List<ModuleModel> systemList,List<MenuTreeVO> menuList, List<PermissionModel> permissionList, UserCommonInfoVO userInfo, SystemInfo sysConfigInfo) {
        this.systemList = systemList;
        this.menuList = menuList;
        this.permissionList = permissionList;
        this.userInfo = userInfo;
        this.sysConfigInfo = sysConfigInfo;
    }

    public List<MenuTreeVO> getMenuList() {
        return menuList;
    }

    public void setMenuList(List<MenuTreeVO> menuList) {
        this.menuList = menuList;
    }

    public List<PermissionModel> getPermissionList() {
        return permissionList;
    }

    public void setPermissionList(List<PermissionModel> permissionList) {
        this.permissionList = permissionList;
    }

    public UserCommonInfoVO getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserCommonInfoVO userInfo) {
        this.userInfo = userInfo;
    }

    public SystemInfo getSysConfigInfo() {
        return sysConfigInfo;
    }

    public void setSysConfigInfo(SystemInfo sysConfigInfo) {
        this.sysConfigInfo = sysConfigInfo;
    }

    public List<ModuleModel> getSystemList() {
        return systemList;
    }

    public void setSystemList(List<ModuleModel> systemList) {
        this.systemList = systemList;
    }
}
