/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.method.wxminiapp.token;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class WxMiniappAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 560L;
    private final String code;
    private final Object principal;
    private Object credentials;

    public WxMiniappAuthenticationToken(String code, String principal, String credentials) {
        super((Collection)null);
        this.code = code;
        this.principal = principal;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }

    public WxMiniappAuthenticationToken(String code, Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.code = code;
        this.principal = principal;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }

    public String getCode() {
        return this.code;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        Assert.isTrue((!isAuthenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        super.setAuthenticated(false);
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.credentials = null;
    }
}

