/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.system.base.model.cachemanage.CacheManageInfoVO;
import com.bringspring.system.base.model.cachemanage.CacheManageListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f13\u5b58\u7ba1\u7406"}, value="CacheManage")
@RestController
@RequestMapping(value={"/api/system/CacheManage"})
public class CacheManageController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserProvider userProvider;

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u5217\u8868")
    @GetMapping
    public ActionResult<ListVO<CacheManageListVO>> getList(Page page) {
        String tenantId = this.userProvider.get().getTenantId();
        List<Object> list = new ArrayList();
        Set data = this.redisUtil.getAllKeys();
        for (String key : data) {
            try {
                CacheManageListVO model;
                if (!StringUtils.isEmpty((String)tenantId) && key.contains(tenantId)) {
                    model = new CacheManageListVO();
                    model.setName(key);
                    model.setCacheSize(String.valueOf(this.redisUtil.getString(key)).getBytes().length);
                    model.setOverdueTime(new Date((DateUtil.getTime((Date)new Date()) + this.redisUtil.getLiveTime(key)) * 1000L).getTime());
                    list.add(model);
                    continue;
                }
                if (!StringUtils.isEmpty((String)tenantId)) continue;
                model = new CacheManageListVO();
                model.setName(key);
                model.setCacheSize(String.valueOf(this.redisUtil.getString(key)).getBytes().length);
                model.setOverdueTime(new Date((DateUtil.getTime((Date)new Date()) + this.redisUtil.getLiveTime(key)) * 1000L).getTime());
                list.add(model);
            }
            catch (Exception exception) {}
        }
        list = list.stream().sorted(Comparator.comparing(CacheManageListVO::getOverdueTime)).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((String)page.getKeyword())) {
            list = list.stream().filter(t -> t.getName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u4fe1\u606f")
    @GetMapping(value={"/{name}"})
    public ActionResult info(@PathVariable(value="name") String name) {
        name = XSSEscape.escape((String)name);
        String json = String.valueOf(this.redisUtil.getString(name));
        CacheManageInfoVO vo = new CacheManageInfoVO();
        vo.setName(name);
        vo.setValue(json);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6e05\u7a7a\u6240\u6709\u7f13\u5b58")
    @PostMapping(value={"/Actions/ClearAll"})
    public ActionResult clearAll() {
        String tenantId = this.userProvider.get().getTenantId();
        if ("".equals(tenantId)) {
            Set keys = this.redisUtil.getAllKeys();
            for (String key : keys) {
                this.redisUtil.remove(key);
            }
        } else {
            Set data = this.redisUtil.getAllKeys();
            for (String key : data) {
                if (!key.contains(tenantId)) continue;
                this.redisUtil.remove(key);
            }
        }
        return ActionResult.success((String)"\u6e05\u7406\u6210\u529f");
    }

    @ApiOperation(value="\u6e05\u7a7a\u5355\u4e2a\u7f13\u5b58")
    @DeleteMapping(value={"/{name}"})
    public ActionResult clear(@PathVariable(value="name") String name) {
        this.redisUtil.remove(name);
        return ActionResult.success((String)"\u6e05\u7a7a\u6210\u529f");
    }
}

