/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.model.logs.ErrorLogVO;
import com.bringspring.system.base.model.logs.HandleLogVO;
import com.bringspring.system.base.model.logs.LogDelForm;
import com.bringspring.system.base.model.logs.LoginLogVO;
import com.bringspring.system.base.model.logs.PaginationLogModel;
import com.bringspring.system.base.model.logs.RequestLogVO;
import com.bringspring.system.base.service.LogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u65e5\u5fd7"}, value="Log")
@RestController
@RequestMapping(value={"/api/system/Log"})
public class LogController {
    @Autowired
    private LogService logService;

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868")
    @GetMapping(value={"/{category}"})
    public ActionResult getInfoList(@PathVariable(value="category") String category, PaginationLogModel paginationTime) {
        if (StringUtils.isEmpty((String)category) || !StringUtils.isNumeric((CharSequence)category)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25");
        }
        List<LogEntity> list = this.logService.getList(Integer.parseInt(category), paginationTime);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationTime), PaginationVO.class);
        int i = Integer.parseInt(category);
        switch (i) {
            case 1: {
                List loginLogVOList = JsonUtil.getJsonToList(list, LoginLogVO.class);
                return ActionResult.page((List)loginLogVOList, (PaginationVO)paginationVO);
            }
            case 3: {
                List handleLogVOList = JsonUtil.getJsonToList(list, HandleLogVO.class);
                for (int j = 0; j < handleLogVOList.size(); ++j) {
                    ((HandleLogVO)handleLogVOList.get(j)).setJson(list.get(j).getJsons());
                }
                return ActionResult.page((List)handleLogVOList, (PaginationVO)paginationVO);
            }
            case 4: {
                List errorLogVOList = JsonUtil.getJsonToList(list, ErrorLogVO.class);
                for (int j = 0; j < errorLogVOList.size(); ++j) {
                    ((ErrorLogVO)errorLogVOList.get(j)).setJson(list.get(j).getJsons());
                }
                return ActionResult.page((List)errorLogVOList, (PaginationVO)paginationVO);
            }
            case 5: {
                List requestLogVOList = JsonUtil.getJsonToList(list, RequestLogVO.class);
                return ActionResult.page((List)requestLogVOList, (PaginationVO)paginationVO);
            }
        }
        return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u65e5\u5fd7")
    @DeleteMapping
    public ActionResult delete(@RequestBody LogDelForm logDelForm) {
        boolean flag = this.logService.delete(logDelForm.getIds());
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u4e00\u952e\u6e05\u7a7a\u64cd\u4f5c\u65e5\u5fd7")
    @DeleteMapping(value={"/{type}"})
    public ActionResult deleteHandelLog(@PathVariable(value="type") String type) {
        this.logService.deleteHandleLog(type);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u540d")
    @GetMapping(value={"/ModuleName"})
    public ActionResult<List<Map<String, String>>> moduleName() {
        ArrayList<HashedMap> list = new ArrayList<HashedMap>(16);
        Set<String> set = this.logService.queryList();
        for (String moduleName : set) {
            HashedMap map = new HashedMap(1);
            map.put("moduleName", moduleName);
            list.add(map);
        }
        return ActionResult.success(list);
    }
}

