/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.emoji.EmojiUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.controller.DIngStream;
import com.bringspring.system.base.exception.WxErrorException;
import com.bringspring.system.base.model.dingding.DingDeptModel;
import com.bringspring.system.base.model.dingding.DingUserIdModel;
import com.bringspring.system.base.model.dingding.DingUserModel;
import com.bringspring.system.base.model.link.WeChatDepartment;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.aes.QyWxConfig;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.OraganizeListVO;
import com.bringspring.system.message.model.message.SynThirdInfoCrForm;
import com.bringspring.system.message.model.message.SynThirdInfoUpForm;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.service.SynThirdQyService;
import com.bringspring.system.message.util.SynDingTalkUtil;
import com.bringspring.system.message.util.SynQyWebChatUtil;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.QyLinkUserEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiUserListidRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiUserListidResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.dingtalk.open.app.api.GenericEventListener;
import com.dingtalk.open.app.api.OpenDingTalkStreamClientBuilder;
import com.dingtalk.open.app.api.message.GenericOpenDingTalkEvent;
import com.dingtalk.open.app.api.security.AuthClientCredential;
import com.dingtalk.open.app.api.security.DingTalkCredential;
import com.dingtalk.open.app.stream.protocol.event.EventAckStatus;
import com.taobao.api.TaobaoRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.xml.parsers.DocumentBuilderFactory;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import org.apdplat.word.tagging.PinyinTagging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Api(tags={"\u7b2c\u4e09\u65b9\u4fe1\u606f\u540c\u6b65"}, value="SynThirdInfo")
@RestController
@RequestMapping(value={"/api/system/SynThirdInfo"})
public class SynThirdInfoController {
    private static final Logger log = LoggerFactory.getLogger(SynThirdInfoController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private SynThirdQyService synThirdQyService;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    QyWxConfig qyWxConfig;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private DIngStream dIngStream;
    private WxCpService wxCpService;

    @ApiOperation(value="\u65b0\u589e\u540c\u6b65\u8868\u4fe1\u606f")
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid SynThirdInfoCrForm synThirdInfoCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        SynThirdInfoEntity entity = (SynThirdInfoEntity)JsonUtil.getJsonToBean((Object)synThirdInfoCrForm, SynThirdInfoEntity.class);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setId(RandomUtil.uuId());
        this.synThirdInfoService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u540c\u6b65\u8868\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public SynThirdInfoEntity getInfo(@PathVariable(value="id") String id) {
        SynThirdInfoEntity entity = this.synThirdInfoService.getInfo(id);
        return entity;
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u7684\u540c\u6b65\u5bf9\u8c61")
    @GetMapping(value={"/getInfoBySysObjId/{thirdType}/{dataType}/{id}"})
    public SynThirdInfoEntity getInfoBySysObjId(@PathVariable(value="thirdType") String thirdType, @PathVariable(value="dataType") String dataType, @PathVariable(value="id") String id) {
        SynThirdInfoEntity entity = this.synThirdInfoService.getInfoBySysObjId(thirdType, dataType, id);
        return entity;
    }

    @ApiOperation(value="\u66f4\u65b0\u540c\u6b65\u8868\u4fe1\u606f")
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SynThirdInfoUpForm synThirdInfoUpForm) throws DataException {
        SynThirdInfoEntity entity = this.synThirdInfoService.getInfo(id);
        UserInfo userInfo = this.userProvider.get();
        if (entity != null) {
            SynThirdInfoEntity entityUpd = (SynThirdInfoEntity)JsonUtil.getJsonToBean((Object)synThirdInfoUpForm, SynThirdInfoEntity.class);
            entityUpd.setCreatorUserId(entity.getCreatorUserId());
            entityUpd.setCreatorTime(entity.getCreatorTime());
            entityUpd.setLastModifyUserId(userInfo.getUserId());
            entityUpd.setLastModifyTime(DateUtil.getNowDate());
            this.synThirdInfoService.update(id, entityUpd);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u5220\u9664\u540c\u6b65\u8868\u4fe1\u606f")
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        SynThirdInfoEntity entity = this.synThirdInfoService.getInfo(id);
        if (entity != null) {
            this.synThirdInfoService.delete(entity);
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u7b2c\u4e09\u65b9(\u5982\uff1a\u4f01\u4e1a\u5fae\u4fe1\u3001\u9489\u9489)\u7684\u7ec4\u7ec7\u4e0e\u7528\u6237\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/getSynThirdTotal/{thirdType}"})
    public ActionResult getSynThirdTotal(@PathVariable(value="thirdType") String thirdType) {
        ArrayList<SynThirdTotal> synTotalList = new ArrayList<SynThirdTotal>();
        synTotalList.add(this.synThirdInfoService.getSynTotal(thirdType, "1"));
        synTotalList.add(this.synThirdInfoService.getSynTotal(thirdType, "2"));
        return ActionResult.success(synTotalList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7b2c\u4e09\u65b9(\u5982\uff1a\u4f01\u4e1a\u5fae\u4fe1\u3001\u9489\u9489)\u7684\u7ec4\u7ec7\u6216\u7528\u6237\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/getSynThirdTotal/{thirdType}/{dataType}"})
    public SynThirdTotal getSynThirdTotal(@PathVariable(value="thirdType") String thirdType, @PathVariable(value="dataType") String dataType) {
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal(thirdType, dataType);
        return synThirdTotal;
    }

    @ApiOperation(value="\u672c\u5730\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u4f01\u4e1a\u5fae\u4fe1")
    @PostMapping(value={"/synAllOrganizeSysToQy"})
    public ActionResult synAllOrganizeSysToQy(@RequestBody BaseSystemInfo config) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        String access_token = "";
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
            }
            access_token = tokenObject.getString("access_token");
            WxCpDepart depart = new WxCpDepart();
            Long departId = 2L;
            depart.setId(departId);
            depart.setName("\u5b50\u90e8\u95e8\u6539\u540d" + System.currentTimeMillis());
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getListByCrop("1", "1", corpId);
            List<OrganizeEntity> organizeList = this.organizeService.getList();
            List organizeModelList = JsonUtil.getJsonToList(organizeList, OrganizeModel.class);
            List trees = TreeDotUtils.convertListToTreeDot((List)organizeModelList);
            List listVO = JsonUtil.getJsonToList((Object)trees, OraganizeListVO.class);
            ArrayList<OrganizeEntity> listByOrder = new ArrayList<OrganizeEntity>();
            for (OraganizeListVO organizeVo : listVO) {
                OrganizeEntity entity = organizeList.stream().filter(t -> t.getId().equals(organizeVo.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                SynQyWebChatUtil.getOrganizeTreeToList(organizeVo, organizeList, listByOrder);
            }
            synThirdInfoList = this.synThirdInfoService.getListByCrop("1", "1", config.getQyhCorpId());
            for (OrganizeEntity organizeEntity : listByOrder) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(organizeEntity.getId())).count() > 0L) {
                    retMsg = this.synThirdQyService.updateDepartmentSysToQy(true, organizeEntity, access_token, config);
                    continue;
                }
                retMsg = this.synThirdQyService.createDepartmentSysToQy(true, organizeEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("1", "1");
        return ActionResult.success((Object)synThirdTotal);
    }

    @ApiOperation(value="\u672c\u5730\u6240\u6709\u7528\u6237\u4fe1\u606f\u540c\u6b65\u5230\u4f01\u4e1a\u5fae\u4fe1")
    @GetMapping(value={"/synAllUserSysToQy"})
    public ActionResult synAllUserSysToQy() throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        BaseSystemInfo config = this.synThirdQyService.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        String access_token = "";
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
            }
            access_token = tokenObject.getString("access_token");
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getList("1", "2");
            List<UserEntity> userList = this.userService.getList();
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (userList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                retMsg = this.synThirdQyService.deleteUserSysToQy(true, synThirdInfoEntity.getSystemObjectId(), access_token);
            }
            for (UserEntity userEntity : userList) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(userEntity.getId())).count() == 0L) {
                    retMsg = this.synThirdQyService.createUserSysToQy(true, userEntity, access_token);
                    continue;
                }
                retMsg = this.synThirdQyService.updateUserSysToQy(true, userEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("1", "2");
        return ActionResult.success((Object)synThirdTotal);
    }

    @ApiOperation(value="\u672c\u5730\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u9489\u9489")
    @PostMapping(value={"/synAllOrganizeSysToDing"})
    public ActionResult synAllOrganizeSysToDing(@RequestBody BaseSystemInfo config) {
        JSONObject retMsg = new JSONObject();
        String corpId = config.getClientId();
        String corpSecret = config.getClientSecrent();
        try {
            JSONObject tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getList("2", "1");
            List<OrganizeEntity> organizeList = this.organizeService.getList();
            List organizeModelList = JsonUtil.getJsonToList(organizeList, OrganizeModel.class);
            List trees = TreeDotUtils.convertListToTreeDot((List)organizeModelList);
            List listVO = JsonUtil.getJsonToList((Object)trees, OraganizeListVO.class);
            ArrayList<OrganizeEntity> listByOrder = new ArrayList<OrganizeEntity>();
            for (OraganizeListVO organizeVo : listVO) {
                OrganizeEntity entity = organizeList.stream().filter(t -> t.getId().equals(organizeVo.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                SynDingTalkUtil.getOrganizeTreeToList(organizeVo, organizeList, listByOrder);
            }
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (organizeList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                retMsg = this.synThirdDingTalkService.deleteDepartmentSysToDing(true, synThirdInfoEntity.getSystemObjectId(), access_token);
            }
            synThirdInfoList = this.synThirdInfoService.getList("2", "1");
            for (OrganizeEntity organizeEntity : listByOrder) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(organizeEntity.getId())).count() > 0L) {
                    retMsg = this.synThirdDingTalkService.updateDepartmentSysToDing(true, organizeEntity, access_token);
                    continue;
                }
                retMsg = this.synThirdDingTalkService.createDepartmentSysToDing(true, organizeEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }

    @ApiOperation(value="\u672c\u5730\u6240\u6709\u7528\u6237\u4fe1\u606f\u540c\u6b65\u5230\u9489\u9489")
    @PostMapping(value={"/synAllUserSysToDing"})
    public ActionResult synAllUserSysToDing(@RequestBody BaseSystemInfo config) throws ParseException {
        JSONObject retMsg = new JSONObject();
        String corpId = config.getClientId();
        String corpSecret = config.getClientSecrent();
        try {
            JSONObject tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.success((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getList("2", "2");
            List<UserEntity> userList = this.userService.getList();
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (userList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                retMsg = this.synThirdDingTalkService.deleteUserSysToDing(true, synThirdInfoEntity.getSystemObjectId(), access_token);
            }
            for (UserEntity userEntity : userList) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(userEntity.getId())).count() == 0L) {
                    retMsg = this.synThirdDingTalkService.createUserSysToDing(true, userEntity, access_token);
                    continue;
                }
                retMsg = this.synThirdDingTalkService.updateUserSysToDing(true, userEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "2");
        return ActionResult.success((Object)synThirdTotal);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u5355\u4e2a\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u672c\u5730")
    @GetMapping(value={"/synQyToOrganizeSys"})
    public ActionResult synQyToOrganizeSys(String id, String companyId) throws Exception {
        this.synThirdQyService.synQyToOrganizeSys(id, companyId);
        return ActionResult.success(null);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u5355\u4e2a\u7528\u6237\u540c\u6b65\u5230\u672c\u5730")
    @GetMapping(value={"/synQyToUserSys"})
    public ActionResult synQyToUserSys(String id, String companyId) throws Exception {
        this.synThirdQyService.synQyToUserSys(id, companyId);
        return ActionResult.success(null);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synQyToAllOrganizeSys"})
    public ActionResult synQyToAllOrganizeSys(@RequestBody BaseSystemInfo config) {
        JSONObject retMsg = new JSONObject();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        String access_token = "";
        UserInfo userInfo = this.userProvider.get();
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
            }
            access_token = tokenObject.getString("access_token");
            JSONObject departmentList = SynQyWebChatUtil.getDepartmentList(null, access_token);
            ArrayList<OrganizeEntity> departmentQy = new ArrayList<OrganizeEntity>();
            JSONObject jo = JSONObject.parseObject((String)String.valueOf(departmentList));
            String department = String.valueOf(jo.get((Object)"department"));
            List jsonToListMap = JsonUtil.getJsonToListMap((String)department);
            List<OrganizeEntity> listOrgan = this.organizeService.getList();
            String organize = "";
            for (Map organizeEntity : jsonToListMap) {
                OrganizeEntity organizeEntityQy = new OrganizeEntity();
                organizeEntityQy.setId(corpId + organizeEntity.get("id"));
                organizeEntityQy.setFullName(String.valueOf(organizeEntity.get("name")));
                organizeEntityQy.setParentId(corpId + organizeEntity.get("parentid"));
                organizeEntityQy.setSortCode((long)Long.valueOf(String.valueOf(organizeEntity.get("order"))));
                organizeEntityQy.setManagerId(String.valueOf(organizeEntity.get("department_leader")).replaceAll("\\[", "").replaceAll("]", "").replaceAll("\"", ""));
                organizeEntityQy.setCategory("department");
                if ("1".equals(String.valueOf(organizeEntity.get("id")))) {
                    organizeEntityQy.setCategory("company");
                    organizeEntityQy.setEnCode("R");
                    organizeEntityQy.setParentId("0");
                    organize = corpId + organizeEntity.get("id");
                } else {
                    organizeEntityQy.setCategory("department");
                }
                organizeEntityQy.setOrganizeId(organize);
                if (listOrgan.stream().filter(t -> t.getId().equals(String.valueOf(organizeEntityQy.getId()))).count() == 0L) {
                    SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
                    synThirdInfoEntity.setThirdObjectId(String.valueOf(organizeEntity.get("id")));
                    synThirdInfoEntity.setSystemObjectId(String.valueOf(organizeEntityQy.getId()));
                    synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
                    synThirdInfoEntity.setDataType(Integer.valueOf("1"));
                    synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                    synThirdInfoEntity.setCreatorUserId(userInfo.getUserId());
                    synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
                    synThirdInfoEntity.setId(RandomUtil.uuId());
                    synThirdInfoEntity.setCropId(corpId);
                    this.synThirdInfoService.saveOrUpdate(synThirdInfoEntity);
                }
                departmentQy.add(organizeEntityQy);
            }
            this.organizeService.saveOrUpdateBatch(departmentQy);
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        this.dIngStream.setOrganizeCode();
        this.dIngStream.setOrganizedTree();
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }

    public static void main(String[] args) throws Exception {
        OpenDingTalkStreamClientBuilder.custom().credential((DingTalkCredential)new AuthClientCredential("dingqgbtl0pzm45qbonu", "299RRMGBuD-Hsw9LE76DzJi-ApKmq3MABXm-tS8-plFFt189RrSJi_qB0U7tAot1")).registerAllEventListener(new GenericEventListener(){

            public EventAckStatus onEvent(GenericOpenDingTalkEvent event) {
                try {
                    String eventId = event.getEventId();
                    String eventType = event.getEventType();
                    Long bornTime = event.getEventBornTime();
                    JSONObject bizData = event.getData();
                    PinyinTagging.process((List)((List)bizData));
                    return EventAckStatus.SUCCESS;
                }
                catch (Exception e) {
                    return EventAckStatus.LATER;
                }
            }
        }).build().start();
    }

    @ApiOperation(value="\u9489\u9489\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synDingToAllOrganizeSys"})
    public ActionResult synDingToAllOrganizeSys(@RequestBody BaseSystemInfo config) throws Exception {
        DefaultDingTalkClient clientToken = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest req = new OapiGettokenRequest();
        req.setAppkey(config.getQyhCorpId());
        req.setAppsecret(config.getQyhCorpSecret());
        req.setHttpMethod("GET");
        OapiGettokenResponse rsp = (OapiGettokenResponse)clientToken.execute((TaobaoRequest)req);
        System.out.println(rsp.getBody());
        Map stringObjectMap = JsonUtil.stringToMap((String)rsp.getBody());
        if (!stringObjectMap.containsKey("access_token")) {
            throw new Exception("\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiGettokenResponse execute = (OapiGettokenResponse)client.execute((TaobaoRequest)req, String.valueOf(stringObjectMap.get("access_token")));
        System.out.println(execute.getBody());
        List resultDepart = JsonUtil.getJsonToList((String)String.valueOf(JsonUtil.stringToMap((String)execute.getBody()).get("result")), DingDeptModel.class);
        return this.dIngStream.orgAOD(resultDepart, config.getQyhCorpId());
    }

    @ApiOperation(value="\u9489\u9489\u6240\u6709\u7528\u6237\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synDingToAllUserSys"})
    public ActionResult synDingToAllUserSys(@RequestBody BaseSystemInfo config) throws Exception {
        String qyhCorpId = config.getQyhCorpId();
        DefaultDingTalkClient clientToken = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest req = new OapiGettokenRequest();
        req.setAppkey(qyhCorpId);
        req.setAppsecret(config.getQyhCorpSecret());
        req.setHttpMethod("GET");
        OapiGettokenResponse rsp = (OapiGettokenResponse)clientToken.execute((TaobaoRequest)req);
        System.out.println(rsp.getBody());
        Map stringObjectMap = JsonUtil.stringToMap((String)rsp.getBody());
        if (!stringObjectMap.containsKey("access_token")) {
            throw new Exception("\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        String accessToken = String.valueOf(stringObjectMap.get("access_token"));
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiGettokenResponse execute = (OapiGettokenResponse)client.execute((TaobaoRequest)req, accessToken);
        System.out.println(execute.getBody());
        ArrayList<DingDeptModel> resultDepart = new ArrayList<DingDeptModel>();
        DingDeptModel dingDeptModelPar = new DingDeptModel();
        dingDeptModelPar.setDept_id("1");
        resultDepart.add(dingDeptModelPar);
        resultDepart.addAll(JsonUtil.getJsonToList((String)String.valueOf(JsonUtil.stringToMap((String)execute.getBody()).get("result")), DingDeptModel.class));
        ArrayList<DingUserModel> resultUserList = new ArrayList<DingUserModel>();
        List<RoleEntity> listByEnCode = this.roleService.getListByEnCode("SimpleUser");
        List<SynThirdInfoEntity> listThird = this.synThirdInfoService.getList("1", "2");
        UserInfo userInfo = this.userProvider.get();
        if (!ObjectUtil.isEmpty(resultDepart)) {
            for (int i = 0; i < resultDepart.size(); ++i) {
                DingDeptModel dingDeptModel = (DingDeptModel)resultDepart.get(i);
                DefaultDingTalkClient clientUserId = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/listid");
                OapiUserListidRequest reqUserId = new OapiUserListidRequest();
                reqUserId.setDeptId(Long.valueOf(dingDeptModel.getDept_id()));
                OapiUserListidResponse rspUserId = (OapiUserListidResponse)clientUserId.execute((TaobaoRequest)reqUserId, accessToken);
                System.out.println(rspUserId.getBody());
                DingUserIdModel resultId = (DingUserIdModel)JsonUtil.getJsonToBean((String)String.valueOf(JsonUtil.stringToMap((String)rspUserId.getBody()).get("result")), DingUserIdModel.class);
                if (ObjectUtil.isEmpty((Object)resultId)) continue;
                DefaultDingTalkClient clientUser = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
                OapiV2UserGetRequest reqUser = new OapiV2UserGetRequest();
                reqUser.setUserid("141410123526265934");
                OapiV2UserGetResponse rspUser = (OapiV2UserGetResponse)clientUser.execute((TaobaoRequest)reqUser, accessToken);
                DingUserModel resultUser = (DingUserModel)JsonUtil.getJsonToBean((String)String.valueOf(JsonUtil.stringToMap((String)rspUser.getBody()).get("result")), DingUserModel.class);
                resultUser.setDepartmentId(dingDeptModel.getDept_id());
                System.out.println(rsp.getBody());
                this.dIngStream.userAOD(resultUser.getUserid(), qyhCorpId);
                resultUserList.add(resultUser);
            }
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u6240\u6709\u7528\u6237\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synQyToAllUserSys"})
    public ActionResult synQyToAllUserSys(@RequestBody BaseSystemInfo config) {
        JSONObject retMsg = new JSONObject();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        String access_token = "";
        UserInfo userInfo = this.userProvider.get();
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
            }
            access_token = tokenObject.getString("access_token");
            ArrayList<UserEntity> jsonToListMap = new ArrayList<UserEntity>();
            List<SynThirdInfoEntity> listOrgan = this.synThirdInfoService.getListByCrop("1", "1", corpId);
            List<SynThirdInfoEntity> listUser = this.synThirdInfoService.getListByCrop("1", "2", corpId);
            List<RoleEntity> listByEnCode = this.roleService.getListByEnCode("SimpleUser");
            if (listOrgan.size() > 0) {
                for (SynThirdInfoEntity organizeEntity : listOrgan) {
                    JSONObject departmentList = SynQyWebChatUtil.getUserDetailList(String.valueOf(organizeEntity.getThirdObjectId()), "0", access_token);
                    JSONObject jo = JSONObject.parseObject((String)String.valueOf(departmentList));
                    String userlist = String.valueOf(jo.get((Object)"userlist"));
                    if (!StringUtils.isNotEmpty((String)userlist)) continue;
                    List jsonToListMap1 = JsonUtil.getJsonToListMap((String)userlist);
                    for (Map map : jsonToListMap1) {
                        OrganizeEntity orgInfo;
                        UserEntity userEntity = new UserEntity();
                        String userid = String.valueOf(map.get("userid"));
                        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
                        if (!StringUtils.isNull(map.get("userid"))) {
                            List<SynThirdInfoEntity> synThirdInfoEntityList = this.synThirdInfoService.getInfoByThirdObjIds("1", "2", userid);
                            if (!ObjectUtil.isEmpty((Object)synThirdInfoEntity.getId())) {
                                userEntity.setId(synThirdInfoEntityList.get(0).getSystemObjectId());
                            } else {
                                userEntity.setId(RandomUtil.uuId());
                                synThirdInfoEntity = new SynThirdInfoEntity();
                                synThirdInfoEntity.setId(RandomUtil.uuId());
                            }
                        }
                        if (!StringUtils.isNull(map.get("name"))) {
                            userEntity.setRealName(String.valueOf(map.get("name")).replaceAll("[^\u4e00-\u9fa5]", ""));
                        }
                        if (!StringUtils.isNull(map.get("lias"))) {
                            userEntity.setQuickQuery(String.valueOf(map.get("lias")));
                        }
                        if (!StringUtils.isNull(map.get("lias"))) {
                            userEntity.setNickName(String.valueOf(map.get("lias")));
                        }
                        if (!StringUtils.isNull(map.get("userid"))) {
                            userEntity.setAccount(String.valueOf(map.get("userid")));
                        }
                        if (!StringUtils.isNull(map.get("department"))) {
                            String department1 = String.valueOf(map.get("department")).replaceAll("\\[", "").replaceAll("]", "");
                            userEntity.setOrganizeId(corpId + department1);
                        }
                        if (!StringUtils.isNull(map.get("mobile"))) {
                            userEntity.setMobilePhone(String.valueOf(map.get("mobile")));
                        }
                        if (!StringUtils.isNull(map.get("email"))) {
                            userEntity.setEmail(String.valueOf(map.get("email")));
                        }
                        if (!StringUtils.isNull(map.get("address"))) {
                            userEntity.setPostalAddress(String.valueOf(map.get("address")));
                        }
                        if (!StringUtils.isNull(map.get("gender")) && !"0".equals(String.valueOf(map.get("address")))) {
                            userEntity.setGender(Integer.parseInt(String.valueOf(map.get("address"))));
                        } else {
                            userEntity.setGender(3);
                        }
                        if (!StringUtils.isNull(map.get("direct_leader"))) {
                            userEntity.setManagerId(String.valueOf(map.get("direct_leader")).replaceAll("\\[", "").replaceAll("]", ""));
                        }
                        if (!StringUtils.isNull(map.get("position"))) {
                            userEntity.setPositionId(String.valueOf(map.get("position")));
                        }
                        userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
                        userEntity.setEnabledMark(1);
                        userEntity.setRoleId(listByEnCode.get(0).getId());
                        if (ObjectUtil.isNotEmpty((Object)organizeEntity.getSystemObjectId()) && !ObjectUtil.isEmpty((Object)(orgInfo = this.organizeService.getInfo(organizeEntity.getSystemObjectId())))) {
                            OrganizeEntity companyInfo = this.organizeService.getInfo(orgInfo.getOrganizeId());
                            String enCode = companyInfo.getEnCode() + "Staff";
                            String billNumber = this.baseDataUtil.getBillNumber(enCode, false);
                            userEntity.setCode(billNumber);
                        }
                        jsonToListMap.add(userEntity);
                        if (listUser.stream().filter(t -> t.getThirdObjectId().equals(String.valueOf(userid))).count() == 0L) {
                            this.userService.createUser(userEntity);
                        } else {
                            boolean bl = this.userService.updateById(userEntity);
                        }
                        synThirdInfoEntity.setThirdObjectId(String.valueOf(map.get("userid")));
                        synThirdInfoEntity.setSystemObjectId(userEntity.getId());
                        synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
                        synThirdInfoEntity.setDataType(Integer.valueOf("2"));
                        synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                        synThirdInfoEntity.setCropId(corpId);
                        synThirdInfoEntity.setCreatorUserId(userInfo.getUserId());
                        synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
                        this.synThirdInfoService.saveOrUpdate(synThirdInfoEntity);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u7ec4\u7ec7\u53d8\u66f4\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synQyToOrgChange"})
    public ActionResult synQyToOrgChange(@RequestBody File xmlFile) throws Exception {
        JSONObject retMsg = new JSONObject();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(xmlFile);
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        OrganizeEntity organizeEntity = new OrganizeEntity();
        String id = root.getElementsByTagName("Id").item(0).getTextContent();
        String Name = root.getElementsByTagName("Name").item(0).getTextContent();
        organizeEntity.setFullName(Name);
        SynThirdInfoEntity infoByThirdObjId = this.synThirdInfoService.getInfoByThirdObjId("1", "1", id);
        if (ObjectUtil.isEmpty((Object)infoByThirdObjId)) {
            this.organizeService.create(organizeEntity);
        } else {
            organizeEntity.setId(infoByThirdObjId.getSystemObjectId());
            this.organizeService.updateById(organizeEntity);
        }
        return ActionResult.success(null);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u4eba\u5458\u53d8\u66f4\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synQyToUserChange"})
    public ActionResult synQyToUserChange(@RequestBody File xmlFile) throws Exception {
        JSONObject retMsg = new JSONObject();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(xmlFile);
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        UserEntity userEntity = new UserEntity();
        String UserID = root.getElementsByTagName("UserID").item(0).getTextContent();
        String Name = root.getElementsByTagName("Name").item(0).getTextContent();
        String MainDepartment = root.getElementsByTagName("MainDepartment").item(0).getTextContent();
        String Mobile = root.getElementsByTagName("Mobile").item(0).getTextContent();
        String Status = root.getElementsByTagName("Status").item(0).getTextContent();
        userEntity.setRealName(Name);
        userEntity.setOrganizeId(MainDepartment);
        userEntity.setMobilePhone(Mobile);
        userEntity.setRealName(Name);
        userEntity.setEnabledMark("1".equals(Status) ? 1 : 0);
        SynThirdInfoEntity infoByThirdObjId = this.synThirdInfoService.getInfoByThirdObjId("1", "2", UserID);
        if (ObjectUtil.isEmpty((Object)infoByThirdObjId)) {
            this.userService.create(userEntity);
        } else {
            userEntity.setId(infoByThirdObjId.getSystemObjectId());
            this.userService.updateById(userEntity);
        }
        return ActionResult.success(null);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u6240\u6709\u3010\u4f01\u4e1a\u4e92\u8054\u3011\u7ec4\u7ec7\u540c\u6b65\u5230\u672c\u5730")
    @GetMapping(value={"/synQyToAllLinkedCorp"})
    @DSTransactional
    public ActionResult synQyToAllLinkedCorp() {
        BaseSystemInfo config = this.synThirdQyService.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        UserInfo userInfo = this.userProvider.get();
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            JSONObject permListRes = SynQyWebChatUtil.getLinkedcorpAgent(access_token);
            if (!permListRes.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u5931\u8d25");
            }
            String agentPermList = String.valueOf(permListRes.get((Object)"department_ids"));
            JSONArray agentPermArr = JSON.parseArray((String)agentPermList);
            if (agentPermArr != null && agentPermArr.size() != 0) {
                ArrayList organizeList = new ArrayList();
                ArrayList synThirdInfoList = new ArrayList();
                for (Object s : agentPermArr) {
                    JSONObject departmentRes = SynQyWebChatUtil.getLinkedcorpDepartment(access_token, String.valueOf(s));
                    if (!departmentRes.getBoolean("code").booleanValue()) {
                        return ActionResult.fail((String)"\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868\u5931\u8d25");
                    }
                    String departmentList = String.valueOf(departmentRes.get((Object)"departmentList"));
                    List jsonToList = JsonUtil.getJsonToList((String)departmentList, WeChatDepartment.class);
                    jsonToList.stream().forEach(item -> {
                        String id = item.getDepartment_id();
                        String parentid = item.getParentid();
                        OrganizeEntity organizeEntity = new OrganizeEntity();
                        organizeEntity.setId(id);
                        organizeEntity.setFullName(item.getDepartment_name());
                        organizeEntity.setParentId("0".equals(parentid) ? "-1" : parentid);
                        organizeEntity.setCategory("1".equals(parentid) || "0".equals(parentid) ? "company" : "department");
                        organizeEntity.setSortCode(item.getOrder());
                        organizeList.add(organizeEntity);
                        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "1", id);
                        if (null == synThirdInfoEntity) {
                            synThirdInfoEntity = new SynThirdInfoEntity();
                            synThirdInfoEntity.setId(RandomUtil.uuId());
                        }
                        synThirdInfoEntity.setThirdObjectId(id);
                        synThirdInfoEntity.setSystemObjectId(id);
                        synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
                        synThirdInfoEntity.setDataType(Integer.valueOf("1"));
                        synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                        synThirdInfoEntity.setCreatorUserId(userInfo.getUserId());
                        synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
                        synThirdInfoList.add(synThirdInfoEntity);
                    });
                }
                if (organizeList.size() != 0 && synThirdInfoList.size() != 0) {
                    this.organizeService.saveOrUpdateBatch(organizeList);
                    this.synThirdInfoService.saveOrUpdateBatch(synThirdInfoList);
                    this.dIngStream.setOrganizedTree();
                    SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("1", "1");
                    return ActionResult.success((Object)synThirdTotal);
                }
                return ActionResult.fail((String)"\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868\u4e3a\u7a7a");
            }
            return ActionResult.fail((String)"\u83b7\u53d6\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e));
        }
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u3010\u4e92\u8054\u4f01\u4e1a\u3011\u6240\u6709\u7528\u6237\u540c\u6b65\u5230\u672c\u5730")
    @GetMapping(value={"/synQyLinkedToAllUserSys"})
    @DSTransactional
    public ActionResult synQyLinkedToAllUserSys() {
        BaseSystemInfo config = this.synThirdQyService.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        UserInfo userInfo = this.userProvider.get();
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            JSONObject permListRes = SynQyWebChatUtil.getLinkedcorpAgent(access_token);
            if (!permListRes.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u5931\u8d25");
            }
            String agentPermList = String.valueOf(permListRes.get((Object)"department_ids"));
            JSONArray agentPermArr = JSON.parseArray((String)agentPermList);
            if (agentPermArr != null && agentPermArr.size() != 0) {
                UserEntity entity;
                String targetChar = "/";
                String regexChar = ",";
                List<UserEntity> userList = this.userService.getList();
                HashMap<String, UserEntity> accountMap = new HashMap<String, UserEntity>();
                HashMap<String, UserEntity> userIdMap = new HashMap<String, UserEntity>();
                if (StringUtils.isNotEmpty(userList)) {
                    for (UserEntity entity2 : userList) {
                        accountMap.put(entity2.getAccount(), entity2);
                        userIdMap.put(entity2.getId(), entity2);
                    }
                }
                List<OrganizeEntity> organizeList = this.organizeService.getList();
                HashMap<String, OrganizeEntity> organizeMap = new HashMap<String, OrganizeEntity>();
                if (StringUtils.isNotEmpty(organizeList)) {
                    for (OrganizeEntity entity3 : organizeList) {
                        organizeMap.put(entity3.getId(), entity3);
                    }
                }
                List<PositionEntity> positionList = this.positionService.getList();
                HashMap<String, PositionEntity> positionIdMap = new HashMap<String, PositionEntity>();
                if (StringUtils.isNotEmpty(positionList)) {
                    for (PositionEntity entity4 : positionList) {
                        positionIdMap.put(entity4.getFullName() + targetChar + entity4.getOrganizeId(), entity4);
                    }
                }
                HashMap<String, SynThirdInfoEntity> thirdMap = new HashMap<String, SynThirdInfoEntity>();
                List<SynThirdInfoEntity> list1 = this.synThirdInfoService.getList("1", "2");
                if (StringUtils.isNotEmpty(list1)) {
                    for (SynThirdInfoEntity entity5 : list1) {
                        thirdMap.put(entity5.getThirdObjectId(), entity5);
                    }
                }
                List<RoleEntity> roleList = this.roleService.getListByEnCode("SimpleUser");
                String defaultRoleId = "";
                if (StringUtils.isNotEmpty(roleList)) {
                    defaultRoleId = roleList.get(0).getId();
                }
                StringBuilder deptListMsg = new StringBuilder();
                StringBuilder userListMsg = new StringBuilder();
                ArrayList<UserEntity> userBatch = new ArrayList<UserEntity>();
                ArrayList synThirdInfoBatch = new ArrayList();
                HashMap<String, UserEntity> updateUserMap = new HashMap<String, UserEntity>();
                HashMap<String, UserEntity> saveUserMap = new HashMap<String, UserEntity>();
                HashMap<String, SynThirdInfoEntity> updateThirdMap = new HashMap<String, SynThirdInfoEntity>();
                HashMap<String, SynThirdInfoEntity> saveThirdMap = new HashMap<String, SynThirdInfoEntity>();
                ArrayList positionBatch = new ArrayList();
                HashMap updatePositionMap = new HashMap();
                HashMap<Object, PositionEntity> savePositionMap = new HashMap<Object, PositionEntity>();
                for (Object obj : agentPermArr) {
                    String agentPerm = String.valueOf(obj);
                    JSONObject departmentRes = SynQyWebChatUtil.getLinkedcorpDepartment(access_token, agentPerm);
                    if (!departmentRes.getBoolean("code").booleanValue()) {
                        deptListMsg.append(agentPerm);
                        deptListMsg.append(":\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868\u5931\u8d25");
                        continue;
                    }
                    String departmentList = String.valueOf(departmentRes.get((Object)"departmentList"));
                    List jsonToList = JsonUtil.getJsonToList((String)departmentList, WeChatDepartment.class);
                    if (jsonToList.size() != 0) {
                        for (WeChatDepartment o : jsonToList) {
                            String departmentId = o.getDepartment_id();
                            departmentId = agentPerm.replaceFirst("/.*", targetChar + departmentId);
                            JSONObject userListRes = SynQyWebChatUtil.getLinkedcorpUser(access_token, departmentId);
                            if (!userListRes.getBoolean("code").booleanValue()) {
                                userListMsg.append(departmentId);
                                userListMsg.append(":\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u6210\u5458\u8be6\u60c5\u5931\u8d25");
                                continue;
                            }
                            String userlist = String.valueOf(userListRes.get((Object)"userlist"));
                            List qyUserList = JsonUtil.getJsonToList((String)userlist, QyLinkUserEntity.class);
                            if (qyUserList.size() != 0) {
                                for (QyLinkUserEntity qyuser : qyUserList) {
                                    String orgId3;
                                    Object[] distinct;
                                    Object[] arrAll;
                                    String[] arr2;
                                    String orgId2;
                                    String[] arr1;
                                    String orgId1;
                                    UserEntity aUser;
                                    String extattr;
                                    JSONObject jsonObject;
                                    JSONArray attrs;
                                    UserEntity userEntity;
                                    SynThirdInfoEntity synThirdInfoEntity;
                                    String corpid = qyuser.getCorpid();
                                    String userid = qyuser.getUserid();
                                    String mobile = qyuser.getMobile();
                                    String email = qyuser.getEmail();
                                    if (StringUtils.isEmpty((String)corpid) || StringUtils.isEmpty((String)userid)) continue;
                                    boolean userIsNull = false;
                                    String thirdObjid = corpid + targetChar + userid;
                                    if (thirdMap.containsKey(thirdObjid)) {
                                        synThirdInfoEntity = (SynThirdInfoEntity)thirdMap.get(thirdObjid);
                                        String systemObjectId = synThirdInfoEntity.getSystemObjectId();
                                        if (userIdMap.containsKey(systemObjectId)) {
                                            userEntity = (UserEntity)userIdMap.get(systemObjectId);
                                        } else if (StringUtils.isNotEmpty((String)mobile) && accountMap.containsKey(mobile)) {
                                            userEntity = (UserEntity)accountMap.get(mobile);
                                        } else if (StringUtils.isNotEmpty((String)email) && accountMap.containsKey(email)) {
                                            userEntity = (UserEntity)accountMap.get(email);
                                        } else if (StringUtils.isNotEmpty((String)userid) && accountMap.containsKey(userid)) {
                                            userEntity = (UserEntity)accountMap.get(userid);
                                        } else {
                                            userIsNull = true;
                                            userEntity = new UserEntity();
                                            userEntity.setId(RandomUtil.uuId());
                                            String account = StringUtils.isNotEmpty((String)mobile) ? mobile : (StringUtils.isNotEmpty((String)email) ? email : userid);
                                            userEntity.setAccount(account);
                                        }
                                    } else {
                                        synThirdInfoEntity = new SynThirdInfoEntity();
                                        synThirdInfoEntity.setId(RandomUtil.uuId());
                                        synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
                                        synThirdInfoEntity.setDataType(Integer.valueOf("2"));
                                        synThirdInfoEntity.setThirdObjectId(thirdObjid);
                                        if (StringUtils.isNotEmpty((String)mobile) && accountMap.containsKey(mobile)) {
                                            userEntity = (UserEntity)accountMap.get(mobile);
                                        } else if (StringUtils.isNotEmpty((String)email) && accountMap.containsKey(email)) {
                                            userEntity = (UserEntity)accountMap.get(email);
                                        } else if (StringUtils.isNotEmpty((String)userid) && accountMap.containsKey(userid)) {
                                            userEntity = (UserEntity)accountMap.get(userid);
                                        } else {
                                            userIsNull = true;
                                            userEntity = new UserEntity();
                                            userEntity.setId(RandomUtil.uuId());
                                            String account = StringUtils.isNotEmpty((String)mobile) ? mobile : (StringUtils.isNotEmpty((String)email) ? email : userid);
                                            userEntity.setAccount(account);
                                        }
                                    }
                                    synThirdInfoEntity.setCropId(corpid);
                                    synThirdInfoEntity.setSystemObjectId(userEntity.getId());
                                    if (StringUtils.isNotEmpty((String)qyuser.getName())) {
                                        String name = StringUtils.stringFilter((String)EmojiUtil.removeAllEmojis((String)qyuser.getName()));
                                        userEntity.setRealName(name);
                                    }
                                    if (StringUtils.isNotEmpty((String)qyuser.getMobile())) {
                                        userEntity.setMobilePhone(qyuser.getMobile());
                                    }
                                    if (StringUtils.isNotEmpty((String)qyuser.getTelephone())) {
                                        userEntity.setTelePhone(qyuser.getTelephone());
                                    }
                                    if (StringUtils.isNotEmpty((String)qyuser.getEmail())) {
                                        userEntity.setEmail(qyuser.getEmail());
                                    }
                                    String position = qyuser.getPosition();
                                    if (StringUtils.isNotEmpty((Collection)qyuser.getDepartment())) {
                                        List deptList = qyuser.getDepartment();
                                        String deptIds = "";
                                        String poitionIds = "";
                                        for (Object deptObj : deptList) {
                                            String cropDept = String.valueOf(deptObj);
                                            String[] cropDeptArr = cropDept.split(targetChar);
                                            String deptId = cropDeptArr[cropDeptArr.length - 1];
                                            if (!organizeMap.containsKey(deptId)) continue;
                                            deptIds = deptIds + deptId + regexChar;
                                            if (!StringUtils.isNotEmpty((String)position)) continue;
                                            poitionIds = poitionIds + position + targetChar + deptId + regexChar;
                                        }
                                        if (StringUtils.isNotEmpty((String)deptIds)) {
                                            deptIds = deptIds.substring(0, deptIds.length() - 1);
                                        }
                                        if (StringUtils.isNotEmpty((String)poitionIds)) {
                                            poitionIds = poitionIds.substring(0, poitionIds.length() - 1);
                                        }
                                        userEntity.setOrganizeId(deptIds);
                                        userEntity.setPositionId(poitionIds);
                                    }
                                    if (StringUtils.isNotEmpty((String)qyuser.getExtattr()) && (attrs = (jsonObject = JSONObject.parseObject((String)(extattr = qyuser.getExtattr()))).getJSONArray("attrs")).size() != 0) {
                                        for (int i = 0; i < attrs.size(); ++i) {
                                            JSONObject attr = attrs.getJSONObject(i);
                                            String name = attr.getString("name");
                                            if (!StringUtils.isNotEmpty((String)name) || !name.contains("\u5de5\u53f7")) continue;
                                            userEntity.setCode(attr.getString("value"));
                                        }
                                    }
                                    if (userIsNull) {
                                        userEntity.setRoleId(defaultRoleId);
                                        userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
                                        userEntity.setGender(3);
                                        userEntity.setEnabledMark(1);
                                        userEntity.setSecretkey(RandomUtil.uuId());
                                        userEntity.setIsAdministrator(0);
                                        userEntity.setPassword(this.userService.getDefaultPassword(userEntity.getSecretkey()));
                                        if (saveUserMap.containsKey(userEntity.getAccount())) {
                                            aUser = (UserEntity)saveUserMap.get(userEntity.getAccount());
                                            orgId1 = aUser.getOrganizeId();
                                            arr1 = StringUtils.isNotEmpty((String)orgId1) ? orgId1.split(regexChar) : new String[]{};
                                            orgId2 = userEntity.getOrganizeId();
                                            arr2 = StringUtils.isNotEmpty((String)orgId2) ? orgId2.split(regexChar) : new String[]{};
                                            arrAll = (String[])ArrayUtil.addAll((Object[][])new String[][]{arr1, arr2});
                                            distinct = (String[])ArrayUtil.distinct((Object[])arrAll);
                                            orgId3 = ArrayUtil.join((Object[])distinct, (CharSequence)regexChar);
                                            aUser.setOrganizeId(orgId3);
                                            String posId1 = aUser.getPositionId();
                                            String[] posArr1 = StringUtils.isNotEmpty((String)posId1) ? posId1.split(regexChar) : new String[]{};
                                            String posId2 = aUser.getPositionId();
                                            String[] posArr2 = StringUtils.isNotEmpty((String)posId2) ? posId2.split(regexChar) : new String[]{};
                                            Object[] posArrAll = (String[])ArrayUtil.addAll((Object[][])new String[][]{posArr1, posArr2});
                                            Object[] distinctPos = (String[])ArrayUtil.distinct((Object[])posArrAll);
                                            String posId3 = ArrayUtil.join((Object[])distinctPos, (CharSequence)regexChar);
                                            userEntity.setPositionId(posId3);
                                            synThirdInfoEntity.setSystemObjectId(aUser.getId());
                                        } else {
                                            saveUserMap.put(userEntity.getAccount(), userEntity);
                                        }
                                        synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                                        saveThirdMap.put(thirdObjid, synThirdInfoEntity);
                                        continue;
                                    }
                                    if (updateUserMap.containsKey(userEntity.getAccount())) {
                                        aUser = (UserEntity)updateUserMap.get(userEntity.getAccount());
                                        orgId1 = aUser.getOrganizeId();
                                        arr1 = StringUtils.isNotEmpty((String)orgId1) ? orgId1.split(regexChar) : new String[]{};
                                        orgId2 = userEntity.getOrganizeId();
                                        arr2 = StringUtils.isNotEmpty((String)orgId2) ? orgId2.split(regexChar) : new String[]{};
                                        arrAll = (String[])ArrayUtil.addAll((Object[][])new String[][]{arr1, arr2});
                                        distinct = (String[])ArrayUtil.distinct((Object[])arrAll);
                                        orgId3 = ArrayUtil.join((Object[])distinct, (CharSequence)regexChar);
                                        aUser.setOrganizeId(orgId3);
                                        synThirdInfoEntity.setSystemObjectId(aUser.getId());
                                    } else {
                                        updateUserMap.put(userEntity.getAccount(), userEntity);
                                    }
                                    synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                                    updateThirdMap.put(thirdObjid, synThirdInfoEntity);
                                }
                                continue;
                            }
                            userListMsg.append(departmentId);
                            userListMsg.append(":\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u6210\u5458\u8be6\u60c5\u4e3a\u7a7a");
                        }
                        continue;
                    }
                    deptListMsg.append(agentPerm);
                    deptListMsg.append(":\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868\u4e3a\u7a7a");
                }
                log.debug("===========\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u53cd\u9988===========deptListMsg" + deptListMsg);
                log.debug("===========\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u53cd\u9988===========userListMsg" + userListMsg);
                if (!saveUserMap.isEmpty()) {
                    for (String key : saveUserMap.keySet()) {
                        entity = (UserEntity)saveUserMap.get(key);
                        String positionId = entity.getPositionId();
                        String[] posArr = StringUtils.isNotEmpty((String)positionId) ? positionId.split(regexChar) : new String[]{};
                        int posLength = posArr.length;
                        Object[] positionIdArr = new String[posLength];
                        for (int i = 0; i < posLength; ++i) {
                            String poitionKey = posArr[i];
                            if (positionIdMap.containsKey(poitionKey)) {
                                positionIdArr[i] = ((PositionEntity)positionIdMap.get(poitionKey)).getId();
                                continue;
                            }
                            if (savePositionMap.containsKey(poitionKey)) {
                                positionIdArr[i] = ((PositionEntity)savePositionMap.get(poitionKey)).getId();
                                continue;
                            }
                            if (!poitionKey.contains(targetChar)) continue;
                            String position = poitionKey.substring(0, poitionKey.lastIndexOf(targetChar));
                            String deptId = poitionKey.substring(poitionKey.lastIndexOf(targetChar) + 1);
                            if (!StringUtils.isNotEmpty((String)position)) continue;
                            PositionEntity posEntity = new PositionEntity();
                            posEntity.setId(RandomUtil.uuId());
                            posEntity.setFullName(position);
                            posEntity.setOrganizeId(deptId);
                            posEntity.setSortCode(0L);
                            savePositionMap.put(poitionKey, posEntity);
                            positionIdArr[i] = posEntity.getId();
                        }
                        String posId3 = ArrayUtil.join((Object[])positionIdArr, (CharSequence)regexChar);
                        entity.setPositionId(posId3);
                        userBatch.add(entity);
                    }
                }
                if (!updateUserMap.isEmpty()) {
                    for (String key : updateUserMap.keySet()) {
                        entity = (UserEntity)updateUserMap.get(key);
                        String organizeIds = "";
                        String positionIds = "";
                        String roleIds = "";
                        String groupIds = "";
                        List<UserRelationEntity> relationList = this.userRelationService.getListByUserId(entity.getId());
                        if (StringUtils.isNotEmpty(relationList)) {
                            for (UserRelationEntity item : relationList) {
                                switch (item.getObjectType()) {
                                    case "Role": {
                                        roleIds = roleIds + item.getObjectId() + regexChar;
                                        break;
                                    }
                                    case "Group": {
                                        groupIds = groupIds + item.getObjectId() + regexChar;
                                        break;
                                    }
                                }
                            }
                        }
                        entity.setRoleId(roleIds);
                        entity.setGroupId(groupIds);
                        String positionId = entity.getPositionId();
                        String[] posArr = StringUtils.isNotEmpty((String)positionId) ? positionId.split(regexChar) : new String[]{};
                        int posLength = posArr.length;
                        Object[] positionIdArr = new String[posLength];
                        for (int i = 0; i < posLength; ++i) {
                            String poitionKey = posArr[i];
                            if (positionIdMap.containsKey(poitionKey)) {
                                positionIdArr[i] = ((PositionEntity)positionIdMap.get(poitionKey)).getId();
                                continue;
                            }
                            if (savePositionMap.containsKey(poitionKey)) {
                                positionIdArr[i] = ((PositionEntity)savePositionMap.get(poitionKey)).getId();
                                continue;
                            }
                            if (!poitionKey.contains(targetChar)) continue;
                            String position = poitionKey.substring(0, poitionKey.lastIndexOf(targetChar));
                            String deptId = poitionKey.substring(poitionKey.lastIndexOf(targetChar) + 1);
                            if (!StringUtils.isNotEmpty((String)position)) continue;
                            PositionEntity posEntity = new PositionEntity();
                            posEntity.setId(RandomUtil.uuId());
                            posEntity.setFullName(position);
                            posEntity.setOrganizeId(deptId);
                            posEntity.setSortCode(0L);
                            savePositionMap.put(poitionKey, posEntity);
                            positionIdArr[i] = posEntity.getId();
                        }
                        String posId3 = ArrayUtil.join((Object[])positionIdArr, (CharSequence)regexChar);
                        entity.setPositionId(posId3);
                        userBatch.add(entity);
                    }
                }
                if (!saveThirdMap.isEmpty()) {
                    for (String key : saveThirdMap.keySet()) {
                        synThirdInfoBatch.add(saveThirdMap.get(key));
                    }
                }
                if (!updateThirdMap.isEmpty()) {
                    for (String key : updateThirdMap.keySet()) {
                        synThirdInfoBatch.add(updateThirdMap.get(key));
                    }
                }
                if (!savePositionMap.isEmpty()) {
                    for (String key : savePositionMap.keySet()) {
                        positionBatch.add(savePositionMap.get(key));
                    }
                }
                if (StringUtils.isNotEmpty(userBatch) && StringUtils.isNotEmpty(synThirdInfoBatch)) {
                    for (UserEntity entity6 : userBatch) {
                        this.userService.saveOrUpdateCommon(entity6.getId(), entity6);
                    }
                    this.positionService.saveOrUpdateBatch(positionBatch);
                    this.userService.saveOrUpdateBatch(userBatch);
                    this.synThirdInfoService.saveOrUpdateBatch(synThirdInfoBatch);
                    SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("1", "2");
                    return ActionResult.success((Object)synThirdTotal);
                }
                return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u6570\u636e\u4e3a\u7a7a");
            }
            return ActionResult.fail((String)"\u83b7\u53d6\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e));
        }
    }
}

