/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.JdbcPageMod;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PageUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.jscript.JScriptUtil;
import com.bringspring.common.util.jwt.JwtUtil;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.system.base.entity.DataInterfaceEntity;
import com.bringspring.system.base.mapper.DataInterfaceMapper;
import com.bringspring.system.base.model.dataInterface.DataInterfaceActionVo;
import com.bringspring.system.base.model.dataInterface.DataInterfacePage;
import com.bringspring.system.base.model.dataInterface.PaginationDataInterface;
import com.bringspring.system.base.service.DataInterfaceLogService;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DblinkService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataInterfaceServiceImpl
extends ServiceImpl<DataInterfaceMapper, DataInterfaceEntity>
implements DataInterfaceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private DataSourceModel dataSourceUtils;
    @Autowired
    private DataInterfaceLogService dataInterfaceLogService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<DataInterfaceEntity> getList(PaginationDataInterface pagination, String dataType) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(DataInterfaceEntity::getFullName, (Object)pagination.getKeyword())).or()).like(DataInterfaceEntity::getEnCode, (Object)pagination.getKeyword());
            });
        }
        queryWrapper.lambda().eq(DataInterfaceEntity::getCategoryId, (Object)pagination.getCategoryId());
        if (StringUtils.isNotEmpty((String)dataType)) {
            queryWrapper.lambda().eq(DataInterfaceEntity::getDataType, (Object)dataType);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DataInterfaceEntity::getSortCode)).orderByDesc(DataInterfaceEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(DataInterfaceEntity::getLastModifyTime);
        }
        queryWrapper.lambda().select(new SFunction[]{DataInterfaceEntity::getId, DataInterfaceEntity::getCheckType, DataInterfaceEntity::getCreatorTime, DataInterfaceEntity::getDataType, DataInterfaceEntity::getEnCode, DataInterfaceEntity::getEnabledMark, DataInterfaceEntity::getFullName, DataInterfaceEntity::getSortCode, DataInterfaceEntity::getRequestMethod, DataInterfaceEntity::getRequestParameters});
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), iPage.getTotal());
    }

    @Override
    public List<DataInterfaceEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DataInterfaceEntity::getEnabledMark, (Object)1)).orderByAsc(DataInterfaceEntity::getSortCode)).orderByDesc(DataInterfaceEntity::getCreatorTime);
        return ((DataInterfaceMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public DataInterfaceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DataInterfaceEntity::getId, (Object)id);
        return (DataInterfaceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public DataInterfaceEntity getInfoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DataInterfaceEntity::getEnCode, (Object)code);
        return (DataInterfaceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(DataInterfaceEntity entity) {
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
            entity.setCreatorUserId(this.userProvider.get().getUserId());
            entity.setCreatorTime(DateUtil.getNowDate());
            entity.setLastModifyTime(DateUtil.getNowDate());
        }
        this.save(entity);
    }

    @Override
    public boolean update(DataInterfaceEntity entity, String id) throws DataException {
        entity.setId(id);
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(DataInterfaceEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DataInterfaceEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DataInterfaceEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DataInterfaceEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DataInterfaceEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public ActionResult infoToId(String id) {
        return this.infoToId(id, null, null);
    }

    @Override
    public ActionResult infoToIdPageList(String id, DataInterfacePage page) {
        DataInterfaceEntity entity = this.getInfo(id);
        String dataProcessing = null;
        if (Objects.nonNull(entity) && StringUtils.isNotEmpty((String)entity.getDataProcessing())) {
            dataProcessing = entity.getDataProcessing();
        }
        HashMap<String, Integer> mapPage = new HashMap<String, Integer>();
        mapPage.put("currentPage", (int)page.getCurrentPage());
        mapPage.put("pageSize", (int)page.getPageSize());
        List<Object> dataList = new ArrayList();
        int total = 0;
        if ("1".equals(entity.getDataType())) {
            Object object = this.executeSql(entity, null, new HashMap<String, String>(16), mapPage);
            if (object instanceof JdbcPageMod) {
                JdbcPageMod jdbcPageMod = (JdbcPageMod)object;
                dataList = jdbcPageMod.getDataList();
                total = jdbcPageMod.getTotalRecord();
            }
        } else {
            ActionResult result = this.infoToId(id, null, null);
            DataInterfaceActionVo actionVo = (DataInterfaceActionVo)result.getData();
            if (actionVo.getData() instanceof List) {
                dataList = (List)actionVo.getData();
                total = dataList.size();
            }
            dataList = PageUtil.getListPage((int)((int)page.getCurrentPage()), (int)((int)page.getPageSize()), dataList);
        }
        if (StringUtils.isNotEmpty((String)page.getKeyword())) {
            dataList = dataList.stream().filter(t -> page.getKeyword().equals(String.valueOf(t.get(page.getRelationField())))).collect(Collectors.toList());
        }
        PaginationVO pagination = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)page), PaginationVO.class);
        pagination.setTotal(Integer.valueOf(total));
        return ActionResult.page(dataList, (PaginationVO)pagination, (String)dataProcessing);
    }

    @Override
    public Map<String, Object> infoToInfo(String id, DataInterfacePage page) {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        ActionResult result = this.infoToId(id, null, null);
        DataInterfaceActionVo actionVo = (DataInterfaceActionVo)result.getData();
        List dataList = new ArrayList();
        if (actionVo.getData() instanceof List) {
            dataList = (List)actionVo.getData();
        }
        if (StringUtils.isNotEmpty((String)page.getId())) {
            dataMap = dataList.stream().filter(t -> page.getId().equals(String.valueOf(t.get(page.getPropsValue())))).findFirst().orElse(new HashMap());
        }
        return dataMap;
    }

    @Override
    public ActionResult infoToId(String id, String tenantId, Map<String, String> map) {
        Object data;
        block22: {
            int checkType;
            DataInterfaceEntity entity = this.getInfo(id);
            if (entity == null) {
                entity = new DataInterfaceEntity();
            }
            int n = checkType = entity.getCheckType() != null ? entity.getCheckType() : 0;
            if (checkType == 1) {
                String token = ServletUtils.getRequest().getHeader("Authorization");
                if (StringUtils.isNotEmpty((String)token)) {
                    String realToken = JwtUtil.getRealToken((String)token);
                    if (!this.redisUtil.exists(realToken)) {
                        return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                    }
                } else {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
            }
            if (checkType == 2) {
                String ipAddress = StringUtils.isNotEmpty((String)entity.getIpAddress()) ? entity.getIpAddress() : "";
                String ipAddr = IpUtil.getIpAddr();
                String[] ips = ipAddress.split(",");
                boolean isCross = false;
                for (String ip : ips) {
                    if (!ip.equals(ipAddr)) continue;
                    isCross = true;
                }
                if (!isCross) {
                    return ActionResult.fail((String)"\u8de8\u57df\u9a8c\u8bc1\u5931\u8d25");
                }
            }
            LocalDateTime dateTime = LocalDateTime.now();
            int invokWasteTime = 0;
            data = null;
            try {
                if (entity.getDataType() == 2) {
                    try {
                        Map maps = JsonUtil.stringToMap((String)entity.getQuery());
                        invokWasteTime = this.invokTime(dateTime);
                        this.dataInterfaceLogService.create(id, invokWasteTime);
                        data = maps;
                    }
                    catch (Exception e) {
                        try {
                            List list = JsonUtil.getJsonToListMap((String)entity.getQuery());
                            invokWasteTime = this.invokTime(dateTime);
                            this.dataInterfaceLogService.create(id, invokWasteTime);
                            data = list;
                            break block22;
                        }
                        catch (Exception exception) {
                            String obj = entity.getQuery() != null ? entity.getQuery() : null;
                            invokWasteTime = this.invokTime(dateTime);
                            this.dataInterfaceLogService.create(id, invokWasteTime);
                            data = obj;
                        }
                    }
                    break block22;
                }
                if (entity.getDataType() == 3) {
                    JSONObject jsonObject = this.callHTTP(entity, map);
                    invokWasteTime = this.invokTime(dateTime);
                    this.dataInterfaceLogService.create(id, invokWasteTime);
                    if (Objects.nonNull(jsonObject) && "1".equals(jsonObject.get((Object)"errorCode"))) {
                        return ActionResult.fail((String)"\u5916\u90e8\u63a5\u53e3\u6682\u65f6\u53ea\u652f\u6301HTTP\u548cHTTPS\u65b9\u5f0f");
                    }
                    ActionResult actionResult = this.returnAction(jsonObject);
                    data = JScriptUtil.callJs((String)entity.getDataProcessing(), (Object)(Objects.nonNull(actionResult) ? actionResult.getData() : (jsonObject == null ? new ArrayList() : jsonObject)));
                } else if (entity.getDataType() == 1) {
                    if (Objects.isNull(map)) {
                        map = new HashMap<String, String>(16);
                        List jsonToListMap = JsonUtil.getJsonToListMap((String)entity.getRequestParameters());
                        for (Map maps : jsonToListMap) {
                            if (!Objects.nonNull(maps)) continue;
                            String field = String.valueOf(maps.get("field"));
                            String value = String.valueOf(maps.get("defaultValue"));
                            map.put(field, value);
                        }
                    }
                    for (String key : map.keySet()) {
                        map.put(key, "'" + map.get(key) + "'");
                    }
                    ArrayList SQLMapList = this.executeSql(entity, tenantId, map);
                    invokWasteTime = this.invokTime(dateTime);
                    this.dataInterfaceLogService.create(id, invokWasteTime);
                    data = JScriptUtil.callJs((String)entity.getDataProcessing(), (Object)(SQLMapList == null ? new ArrayList() : SQLMapList));
                }
            }
            catch (Exception e) {
                this.log.error("\u9519\u8bef\u63d0\u793a:" + e.getMessage());
                e.printStackTrace();
                return ActionResult.fail((String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
            }
        }
        return ActionResult.success(data);
    }

    @Override
    public ActionResult getApiByCode(String code, String tenantId, Map<String, String> map) {
        Object data;
        block22: {
            int checkType;
            DataInterfaceEntity entity = this.getInfoByCode(code);
            if (entity == null) {
                entity = new DataInterfaceEntity();
            }
            int n = checkType = entity.getCheckType() != null ? entity.getCheckType() : 0;
            if (checkType == 1) {
                String token = ServletUtils.getRequest().getHeader("Authorization");
                if (StringUtils.isNotEmpty((String)token)) {
                    String realToken = JwtUtil.getRealToken((String)token);
                    if (!this.redisUtil.exists(realToken)) {
                        return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                    }
                } else {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
            }
            if (checkType == 2) {
                String ipAddress = StringUtils.isNotEmpty((String)entity.getIpAddress()) ? entity.getIpAddress() : "";
                String ipAddr = IpUtil.getIpAddr();
                String[] ips = ipAddress.split(",");
                boolean isCross = false;
                for (String ip : ips) {
                    if (!ip.equals(ipAddr)) continue;
                    isCross = true;
                }
                if (!isCross) {
                    return ActionResult.fail((String)"\u8de8\u57df\u9a8c\u8bc1\u5931\u8d25");
                }
            }
            LocalDateTime dateTime = LocalDateTime.now();
            int invokWasteTime = 0;
            data = null;
            try {
                String id = entity.getId();
                if (entity.getDataType() == 2) {
                    try {
                        Map maps = JsonUtil.stringToMap((String)entity.getQuery());
                        invokWasteTime = this.invokTime(dateTime);
                        this.dataInterfaceLogService.create(id, invokWasteTime);
                        data = maps;
                    }
                    catch (Exception e) {
                        try {
                            List list = JsonUtil.getJsonToListMap((String)entity.getQuery());
                            invokWasteTime = this.invokTime(dateTime);
                            this.dataInterfaceLogService.create(id, invokWasteTime);
                            data = list;
                            break block22;
                        }
                        catch (Exception exception) {
                            String obj = entity.getQuery() != null ? entity.getQuery() : null;
                            invokWasteTime = this.invokTime(dateTime);
                            this.dataInterfaceLogService.create(id, invokWasteTime);
                            data = obj;
                        }
                    }
                    break block22;
                }
                if (entity.getDataType() == 3) {
                    JSONObject jsonObject = this.callHTTP(entity, map);
                    invokWasteTime = this.invokTime(dateTime);
                    this.dataInterfaceLogService.create(id, invokWasteTime);
                    if (Objects.nonNull(jsonObject) && "1".equals(jsonObject.get((Object)"errorCode"))) {
                        return ActionResult.fail((String)"\u5916\u90e8\u63a5\u53e3\u6682\u65f6\u53ea\u652f\u6301HTTP\u548cHTTPS\u65b9\u5f0f");
                    }
                    ActionResult actionResult = this.returnAction(jsonObject);
                    data = JScriptUtil.callJs((String)entity.getDataProcessing(), (Object)(Objects.nonNull(actionResult) ? actionResult.getData() : (jsonObject == null ? new ArrayList() : jsonObject)));
                } else if (entity.getDataType() == 1) {
                    if (Objects.isNull(map)) {
                        map = new HashMap<String, String>(16);
                        List jsonToListMap = JsonUtil.getJsonToListMap((String)entity.getRequestParameters());
                        Iterator actionResult = jsonToListMap.iterator();
                        while (actionResult.hasNext()) {
                            Map maps = (Map)actionResult.next();
                            if (!Objects.nonNull(maps)) continue;
                            String field = String.valueOf(maps.get("field"));
                            String value = String.valueOf(maps.get("defaultValue"));
                            map.put(field, value);
                        }
                    }
                    for (String key : map.keySet()) {
                        map.put(key, "'" + map.get(key) + "'");
                    }
                    ArrayList SQLMapList = this.executeSql(entity, tenantId, map);
                    invokWasteTime = this.invokTime(dateTime);
                    this.dataInterfaceLogService.create(id, invokWasteTime);
                    data = JScriptUtil.callJs((String)entity.getDataProcessing(), (Object)(SQLMapList == null ? new ArrayList() : SQLMapList));
                }
            }
            catch (Exception e) {
                this.log.error("\u9519\u8bef\u63d0\u793a:" + e.getMessage());
                e.printStackTrace();
                return ActionResult.fail((String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
            }
        }
        return ActionResult.success(data);
    }

    @Override
    public Object preview(String id) {
        DataInterfaceActionVo actionVo = new DataInterfaceActionVo();
        try {
            DataInterfaceEntity entity = this.getInfo(id);
            if (entity != null) {
                JSONObject jsonObject = new JSONObject();
                String query = entity.getQuery();
                if (entity.getDataType() == 3) {
                    jsonObject = this.callHTTP(entity, null);
                    if (Objects.nonNull(jsonObject) && "1".equals(jsonObject.get((Object)"errorCode"))) {
                        jsonObject.put("errorCode", (Object)"1");
                        jsonObject.put("errorMsg", (Object)"\u5916\u90e8\u63a5\u53e3\u6682\u65f6\u53ea\u652f\u6301HTTP\u548cHTTPS\u65b9\u5f0f");
                        return jsonObject;
                    }
                    ActionResult actionResult = this.returnAction(jsonObject);
                    if (Objects.nonNull(actionResult)) {
                        actionVo.setData(actionResult.getData());
                        return actionVo;
                    }
                    actionVo.setData(jsonObject);
                } else if (entity.getDataType() == 1) {
                    String[] split;
                    String sensitive = "CREATE,UNIQUE,CHECK,DEFAULT,DROP,INDEX,ALTER,TABLE,VIEW";
                    for (String str : split = sensitive.split(",")) {
                        boolean contains = query.toUpperCase().contains(str.trim());
                        if (!contains) continue;
                        jsonObject.put("errorCode", (Object)"1");
                        jsonObject.put("errorMsg", (Object)("\u8be5SQL\u542b\u6709\u654f\u611f\u5b57\uff1a" + str.trim()));
                        return jsonObject;
                    }
                    HashMap<String, String> map = null;
                    String requestParameters = entity.getRequestParameters();
                    if (StringUtils.isNotEmpty((String)requestParameters)) {
                        map = new HashMap<String, String>(16);
                        List jsonToListMap = JsonUtil.getJsonToListMap((String)requestParameters);
                        for (Map maps : jsonToListMap) {
                            if (!Objects.nonNull(maps)) continue;
                            String field = String.valueOf(maps.get("field"));
                            String value = String.valueOf(maps.get("defaultValue"));
                            map.put(field, "'" + value + "'");
                        }
                    }
                    List<Map<String, Object>> mapList = this.executeSql(entity, null, map);
                    actionVo.setData(mapList);
                } else {
                    actionVo.setData(entity.getQuery());
                }
                actionVo.setData(JScriptUtil.callJs((String)entity.getDataProcessing(), (Object)actionVo.getData()));
                return actionVo;
            }
        }
        catch (Exception e) {
            actionVo.setData(new ArrayList());
            this.log.error("\u9884\u89c8\u53d1\u9001\u9519\u8bef\uff1a" + e.getMessage());
        }
        return actionVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> executeSql(DataInterfaceEntity entity, String tenantId, Map<String, String> map) throws Exception {
        DbLinkEntity linkEntity = this.dblinkService.getInfo(entity.getDbLinkId());
        String sql = entity.getQuery();
        Connection conn = null;
        try {
            UserInfo userInfo = this.userProvider.get();
            if (linkEntity != null) {
                conn = ConnUtil.getConn((DataSourceMod)linkEntity);
            } else if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
                if (StringUtils.isNotEmpty((String)userInfo.getTenantId())) {
                    String dbName = userInfo.getTenantDbConnectionString();
                    DataSourceModel dataSourceUtils1 = this.dataSourceUtils;
                    dataSourceUtils1.setDbName(dbName);
                    conn = ConnUtil.getConn((DataSourceMod)dataSourceUtils1);
                } else {
                    DataSourceModel dataSourceUtils1 = this.dataSourceUtils;
                    dataSourceUtils1.setDbName(tenantId);
                    conn = ConnUtil.getConn((DataSourceMod)dataSourceUtils1);
                }
            } else {
                conn = ConnUtil.getConn((DataSourceMod)this.dataSourceUtils);
            }
            StringBuffer stringBuffer = new StringBuffer();
            sql = this.systemParameter(sql, userInfo);
            if (StringUtils.isNotEmpty((String)sql)) {
                StringSubstitutor strSubstitutor = new StringSubstitutor(map, "{", "}");
                sql = strSubstitutor.replace(sql);
            }
            stringBuffer.append(sql);
            if ("1".equals(entity.getRequestMethod()) || "2".equals(entity.getRequestMethod()) || "4".equals(entity.getRequestMethod())) {
                boolean flag = JdbcUtil.creUpDe((PreparedStatementDTO)new PreparedStatementDTO(conn, stringBuffer.toString()));
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                return arrayList;
            }
            List list = JdbcUtil.queryListAlias((PreparedStatementDTO)new PreparedStatementDTO(conn, stringBuffer.toString()));
            return list;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object executeSql(DataInterfaceEntity entity, String tenantId, Map<String, String> map, Map<String, Integer> mapPage) {
        DbLinkEntity linkEntity = this.dblinkService.getInfo(entity.getDbLinkId());
        try {
            String sql = entity.getQuery();
            Connection conn = null;
            try {
                UserInfo userInfo = this.userProvider.get();
                if (linkEntity != null) {
                    conn = ConnUtil.getConn((DataSourceMod)linkEntity);
                } else if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
                    if (StringUtils.isNotEmpty((String)userInfo.getTenantId())) {
                        String dbName = userInfo.getTenantDbConnectionString();
                        DataSourceModel dataSourceUtils1 = this.dataSourceUtils;
                        dataSourceUtils1.setDbName(dbName);
                        conn = ConnUtil.getConn((DataSourceMod)dataSourceUtils1);
                    } else {
                        DataSourceModel dataSourceUtils1 = this.dataSourceUtils;
                        dataSourceUtils1.setDbName(tenantId);
                        conn = ConnUtil.getConn((DataSourceMod)dataSourceUtils1);
                    }
                } else {
                    conn = ConnUtil.getConn((DataSourceMod)this.dataSourceUtils);
                }
                StringBuffer stringBuffer = new StringBuffer();
                sql = this.systemParameter(sql, userInfo);
                if (StringUtils.isNotEmpty((String)sql)) {
                    StringSubstitutor strSubstitutor = new StringSubstitutor(map, "{", "}");
                    sql = strSubstitutor.replace(sql);
                }
                stringBuffer.append(sql);
                if (Objects.nonNull(mapPage)) {
                    JdbcPageMod jdbcPageMod;
                    JdbcPageMod jdbcPageMod2 = jdbcPageMod = JdbcUtil.queryPage((PreparedStatementDTO)new PreparedStatementDTO(conn, stringBuffer.toString()), (String)"asc", (Integer)mapPage.get("currentPage"), (Integer)mapPage.get("pageSize"));
                    return jdbcPageMod2;
                }
                if ("1".equals(entity.getRequestMethod()) || "2".equals(entity.getRequestMethod()) || "4".equals(entity.getRequestMethod())) {
                    boolean flag = JdbcUtil.creUpDe((PreparedStatementDTO)new PreparedStatementDTO(conn, stringBuffer.toString()));
                    Object var11_14 = null;
                    return var11_14;
                }
                List list = JdbcUtil.queryList((PreparedStatementDTO)new PreparedStatementDTO(conn, stringBuffer.toString()));
                return list;
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject callHTTP(DataInterfaceEntity entity, Map<String, String> map) {
        JSONObject get = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        String path = entity.getPath();
        String requestMethod = entity.getRequestMethod();
        if ("https".equalsIgnoreCase(path.substring(0, 5)) || "http".equalsIgnoreCase(path.substring(0, 4))) {
            List jsonToListMap = JsonUtil.getJsonToListMap((String)entity.getRequestParameters());
            if (jsonToListMap != null) {
                String value;
                if ("6".equals(requestMethod)) {
                    String string = path = !path.contains("?") ? (path = path + "?") : path + "&";
                    if (Objects.nonNull(map)) {
                        for (String field : map.keySet()) {
                            value = String.valueOf(map.get(field));
                            path = path + field + "=" + value.replaceAll("'", "") + "&";
                        }
                    } else {
                        path = this.parameterHandler(path, jsonToListMap);
                    }
                    requestMethod = "GET";
                } else {
                    if (Objects.nonNull(map)) {
                        for (String field : map.keySet()) {
                            value = String.valueOf(map.get(field));
                            jsonObject.put(field, (Object)value);
                        }
                    } else {
                        for (Map maps : jsonToListMap) {
                            if (!Objects.nonNull(maps)) continue;
                            String field = String.valueOf(maps.get("field"));
                            String value2 = String.valueOf(maps.get("defaultValue"));
                            jsonObject.put(field, (Object)value2);
                        }
                    }
                    requestMethod = "POST";
                }
            }
            String token = UserProvider.getToken();
            String jsonObjects = jsonObject.size() > 0 ? jsonObject.toJSONString() : null;
            String requestHeaders = entity.getRequestHeaders();
            if (StringUtils.isNotEmpty((String)requestHeaders)) {
                List requestHeader = JsonUtil.getJsonToListMap((String)requestHeaders);
                for (Map maps : requestHeader) {
                    if (!Objects.nonNull(maps)) continue;
                    String field = String.valueOf(maps.get("field"));
                    String value = String.valueOf(maps.get("defaultValue"));
                    jsonObject.put(field, (Object)value);
                }
            }
            get = HttpUtil.httpRequest((String)path, (String)requestMethod, (String)jsonObjects, (String[])new String[]{token, jsonObject != null ? JsonUtil.getObjectToString((Object)jsonObject) : null});
            return get;
        }
        get.put("errorCode", (Object)"1");
        return get;
    }

    private String parameterHandler(String path, List<Map<String, Object>> jsonToListMap) {
        for (Map<String, Object> map : jsonToListMap) {
            if (map == null) continue;
            String field = String.valueOf(map.get("field"));
            String defaultValue = String.valueOf(map.get("defaultValue"));
            try {
                defaultValue = URLEncoder.encode(defaultValue, "UTF-8");
                path = path + field + "=" + defaultValue + "&";
            }
            catch (UnsupportedEncodingException e) {
                this.log.error(e.getMessage());
            }
        }
        return path;
    }

    private String systemParameter(String sql, UserInfo userInfo) {
        if (sql.contains("@user") && StringUtils.isNotEmpty((String)userInfo.getUserId())) {
            String userId = userInfo.getUserId();
            sql = sql.replaceAll("@user", "'" + userId + "'");
        }
        if (sql.contains("@department") && StringUtils.isNotEmpty((String)userInfo.getDepartmentId())) {
            String departmentId = userInfo.getDepartmentId();
            sql = sql.replaceAll("@department", "'" + departmentId + "'");
        }
        if (sql.contains("@organize") && StringUtils.isNotEmpty((String)userInfo.getOrganizeId())) {
            String organizeId = userInfo.getOrganizeId();
            sql = sql.replaceAll("@organize", "'" + organizeId + "'");
        }
        if (sql.contains("@postion") && StringUtils.isNotEmpty((Object[])userInfo.getPositionIds())) {
            String positionId = userInfo.getPositionIds() != null ? userInfo.getPositionIds()[0] : null;
            sql = sql.replaceAll("@postion", "'" + positionId + "'");
        }
        return sql;
    }

    private ActionResult returnAction(JSONObject jsonObject) {
        ActionResult result;
        if (jsonObject.size() == 3 && jsonObject.get((Object)"code") != null && jsonObject.get((Object)"msg") != null && jsonObject.get((Object)"data") != null && Objects.nonNull(result = (ActionResult)JsonUtil.getJsonToBean((Object)jsonObject, ActionResult.class)) && result.getCode() != null && StringUtils.isNotEmpty((String)result.getMsg())) {
            return result;
        }
        return null;
    }

    public int invokTime(LocalDateTime dateTime) {
        int invokWasteTime = (int)(System.currentTimeMillis() - dateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli());
        return invokWasteTime;
    }
}

