/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PinYinUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.mapper.DictionaryDataMapper;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataExportModel;
import com.bringspring.system.base.model.dictionarytype.DictionaryExportModel;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class DictionaryDataServiceImpl
extends ServiceImpl<DictionaryDataMapper, DictionaryDataEntity>
implements DictionaryDataService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OrganizeRelationService organizeRelationService;

    @Override
    public List<DictionaryDataEntity> getList(String dictionaryTypeId, Boolean enable) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DictionaryDataEntity::getDictionaryTypeId, (Object)dictionaryTypeId);
        if (enable.booleanValue()) {
            queryWrapper.lambda().eq(DictionaryDataEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        }
        String organizeId = this.userProvider.get().getOrganizeId();
        queryWrapper.and(wrapper -> {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().isNull(DictionaryDataEntity::getCompanyId)).or()).eq(DictionaryDataEntity::getCompanyId, (Object)"");
            wrapper.or(orWrapper -> orWrapper.lambda().eq(DictionaryDataEntity::getCompanyId, (Object)organizeId));
        });
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DictionaryDataEntity::getSortCode)).orderByDesc(DictionaryDataEntity::getCreatorTime)).orderByDesc(DictionaryDataEntity::getLastModifyTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DictionaryDataEntity> getList(String dictionaryTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(DictionaryDataEntity::getDictionaryTypeId, (Object)dictionaryTypeId)).or()).eq(DictionaryDataEntity::getEnCode, (Object)dictionaryTypeId);
        });
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DictionaryDataEntity::getSortCode)).orderByDesc(DictionaryDataEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DictionaryDataEntity> getDicList(String dictionaryTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(DictionaryDataEntity::getDictionaryTypeId, (Object)dictionaryTypeId)).or()).eq(DictionaryDataEntity::getEnCode, (Object)dictionaryTypeId);
        });
        queryWrapper.lambda().select(new SFunction[]{DictionaryDataEntity::getId, DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean isExistSubset(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DictionaryDataEntity::getParentId, (Object)parentId);
        return this.list((Wrapper)queryWrapper).size() > 0;
    }

    @Override
    public DictionaryDataEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DictionaryDataEntity::getId, (Object)id);
        return (DictionaryDataEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public DictionaryDataEntity getSwapInfo(String value, String dictionaryTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(DictionaryDataEntity::getDictionaryTypeId, (Object)dictionaryTypeId)).and(t -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(DictionaryDataEntity::getId, (Object)value)).or()).eq(DictionaryDataEntity::getEnCode, (Object)value);
        });
        return (DictionaryDataEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String dictionaryTypeId, String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(DictionaryDataEntity::getFullName, (Object)fullName)).eq(DictionaryDataEntity::getDictionaryTypeId, (Object)dictionaryTypeId);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DictionaryDataEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String dictionaryTypeId, String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(DictionaryDataEntity::getEnCode, (Object)enCode)).eq(DictionaryDataEntity::getDictionaryTypeId, (Object)dictionaryTypeId);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DictionaryDataEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void delete(DictionaryDataEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
        this.organizeRelationService.deleteAllByObjectId(entity.getId(), "Dictionary");
    }

    @Override
    public void create(DictionaryDataEntity entity) {
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
            entity.setSimpleSpelling(PinYinUtil.getFirstSpell((String)entity.getFullName()).toUpperCase());
            entity.setCreatorUserId(this.userProvider.get().getUserId());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, DictionaryDataEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public boolean first(String id) {
        boolean isOk = false;
        DictionaryDataEntity upEntity = (DictionaryDataEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DictionaryDataEntity::getDictionaryTypeId, (Object)upEntity.getDictionaryTypeId())).eq(DictionaryDataEntity::getParentId, (Object)upEntity.getParentId())).lt(DictionaryDataEntity::getSortCode, (Object)upSortCode)).orderByDesc(DictionaryDataEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((DictionaryDataEntity)downEntity.get(0)).getSortCode());
            ((DictionaryDataEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public boolean next(String id) {
        boolean isOk = false;
        DictionaryDataEntity downEntity = (DictionaryDataEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DictionaryDataEntity::getDictionaryTypeId, (Object)downEntity.getDictionaryTypeId())).eq(DictionaryDataEntity::getParentId, (Object)downEntity.getParentId())).gt(DictionaryDataEntity::getSortCode, (Object)upSortCode)).orderByAsc(DictionaryDataEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((DictionaryDataEntity)upEntity.get(0)).getSortCode());
            ((DictionaryDataEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public List<DictionaryDataEntity> getDictionName(List<String> id, String dictTypeId) {
        List<DictionaryDataEntity> dictionList = new ArrayList<DictionaryDataEntity>();
        if (id != null && id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(DictionaryDataEntity::getId, id);
            if (StringUtils.isNotEmpty((String)dictTypeId)) {
                queryWrapper.lambda().or(t -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)t.in(DictionaryDataEntity::getEnCode, (Collection)id)).eq(DictionaryDataEntity::getDictionaryTypeId, (Object)dictTypeId);
                });
            }
            queryWrapper.lambda().orderByAsc(DictionaryDataEntity::getParentId);
            dictionList = this.list((Wrapper)queryWrapper);
        }
        return dictionList;
    }

    @Override
    public DownloadVO exportData(String id) {
        DictionaryTypeEntity typeEntity = this.dictionaryTypeService.getInfo(id);
        DictionaryExportModel exportModel = new DictionaryExportModel();
        HashSet<DictionaryTypeEntity> set = new HashSet<DictionaryTypeEntity>();
        List<DictionaryTypeEntity> typeEntityList = this.dictionaryTypeService.getList();
        this.getDictionaryTypeEntitySet(typeEntity, set, typeEntityList);
        ArrayList<DictionaryTypeEntity> collect = new ArrayList<DictionaryTypeEntity>(set);
        if (collect.size() > 0) {
            exportModel.setList(collect);
        }
        if (exportModel.getList() == null) {
            ArrayList<DictionaryTypeEntity> list = new ArrayList<DictionaryTypeEntity>();
            list.add(typeEntity);
            exportModel.setList(list);
        } else {
            exportModel.getList().add(typeEntity);
        }
        ArrayList<DictionaryDataExportModel> modelList = new ArrayList<DictionaryDataExportModel>();
        for (DictionaryTypeEntity dictionaryTypeEntity : exportModel.getList()) {
            List<DictionaryDataEntity> entityList = this.getList(dictionaryTypeEntity.getId());
            for (DictionaryDataEntity dictionaryDataEntity : entityList) {
                DictionaryDataExportModel dataExportModel = (DictionaryDataExportModel)JsonUtil.getJsonToBean((Object)dictionaryDataEntity, DictionaryDataExportModel.class);
                modelList.add(dataExportModel);
            }
        }
        exportModel.setModelList(modelList);
        DownloadVO downloadVO = this.fileExport.exportFile((Object)exportModel, this.configValueUtil.getTemporaryFilePath(), typeEntity.getFullName(), ModuleTypeEnum.SYSTEM_DICTIONARYDATA.getTableName());
        return downloadVO;
    }

    private void getDictionaryTypeEntitySet(DictionaryTypeEntity dictionaryTypeEntity, Set<DictionaryTypeEntity> set, List<DictionaryTypeEntity> typeEntityList) {
        List collect = typeEntityList.stream().filter(t -> dictionaryTypeEntity.getId().equals(t.getParentId())).collect(Collectors.toList());
        if (collect.size() > 0) {
            for (DictionaryTypeEntity typeEntity : collect) {
                set.add(typeEntity);
                this.getDictionaryTypeEntitySet(typeEntity, set, typeEntityList);
            }
        }
    }

    @Override
    @DSTransactional
    public boolean importData(DictionaryExportModel exportModel) throws DataException {
        try {
            boolean isExists = true;
            List list = JsonUtil.getJsonToList(exportModel.getList(), DictionaryTypeEntity.class);
            List entityList = JsonUtil.getJsonToList(exportModel.getModelList(), DictionaryDataEntity.class);
            for (DictionaryTypeEntity entity : list) {
                if (this.dictionaryTypeService.getInfo(entity.getId()) != null || this.dictionaryTypeService.isExistByEnCode(entity.getEnCode(), entity.getId()) || this.dictionaryTypeService.isExistByFullName(entity.getFullName(), entity.getId())) continue;
                isExists = false;
                this.dictionaryTypeService.create(entity);
            }
            for (DictionaryDataEntity entity1 : entityList) {
                DictionaryDataEntity dataEntity = this.getInfo(entity1.getId());
                if (dataEntity != null || this.dictionaryTypeService.getInfo(entity1.getDictionaryTypeId()) == null || this.isExistByFullName(entity1.getDictionaryTypeId(), entity1.getFullName(), entity1.getId()) || this.isExistByEnCode(entity1.getDictionaryTypeId(), entity1.getEnCode(), entity1.getId())) continue;
                isExists = false;
                this.create(entity1);
            }
            return isExists;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new DataException(e.getMessage());
        }
    }
}

