/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.UserLogForm;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.enums.LogSortEnum;
import com.bringspring.system.base.mapper.LogMapper;
import com.bringspring.system.base.model.logs.PaginationLogModel;
import com.bringspring.system.base.service.LogService;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl
extends ServiceImpl<LogMapper, LogEntity>
implements LogService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<LogEntity> getList(int category, PaginationLogModel paginationTime) {
        String userAccount;
        String keyWord;
        String endTime;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)category);
        String startTime = paginationTime.getStartTime() != null ? paginationTime.getStartTime() : null;
        String string = endTime = paginationTime.getEndTime() != null ? paginationTime.getEndTime() : null;
        if (!StringUtils.isEmpty((String)startTime) && !StringUtils.isEmpty((String)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
        }
        String string2 = keyWord = paginationTime.getKeyword() != null ? paginationTime.getKeyword() : null;
        if (!StringUtils.isEmpty((String)keyWord)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getModuleName, (Object)keyWord);
            });
        }
        String userId = userInfo.getUserId() != null ? userInfo.getUserId() : null;
        String string3 = userAccount = userInfo.getUserAccount() != null ? userInfo.getUserAccount() : null;
        if (!(StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)userAccount) || userInfo.getIsAdministrator().booleanValue())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(LogEntity::getUserId, (Object)userId)).or()).eq(LogEntity::getUserId, (Object)userAccount);
            });
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getIpaddress())) {
            queryWrapper.lambda().like(LogEntity::getIpAddress, (Object)paginationTime.getIpaddress());
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getModuleName())) {
            queryWrapper.lambda().like(LogEntity::getModuleName, (Object)paginationTime.getModuleName());
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getRequestMethod())) {
            queryWrapper.lambda().eq(LogEntity::getRequestMethod, (Object)paginationTime.getRequestMethod());
        }
        queryWrapper.lambda().orderByDesc(LogEntity::getCreatorTime);
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<LogEntity> getList(UserLogForm userLogForm) {
        String userAccount;
        String keyWord;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)userLogForm.getCategory());
        if (!StringUtils.isEmpty((String)userLogForm.getStartTime()) && !StringUtils.isEmpty((String)userLogForm.getEndTime())) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(userLogForm.getStartTime())) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(userLogForm.getEndTime())) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
        }
        if (!StringUtils.isEmpty((String)(keyWord = userLogForm.getKeyword()))) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getModuleName, (Object)keyWord);
            });
        }
        String userId = userInfo.getUserId() != null ? userInfo.getUserId() : null;
        String string = userAccount = userInfo.getUserAccount() != null ? userInfo.getUserAccount() : null;
        if (!StringUtils.isEmpty((String)userId) && !StringUtils.isEmpty((String)userAccount)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(LogEntity::getUserId, (Object)userId)).or()).eq(LogEntity::getUserId, (Object)userAccount);
            });
        }
        if (StringUtils.isEmpty((String)userLogForm.getSidx())) {
            queryWrapper.lambda().orderByDesc(LogEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(userLogForm.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)userLogForm.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)userLogForm.getSidx());
        }
        Page page = new Page(userLogForm.getCurrentPage(), userLogForm.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return userLogForm.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public LogEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getId, (Object)id);
        return (LogEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public boolean delete(String[] ids) {
        if (ids.length > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(LogEntity::getId, (Object[])ids);
            return this.remove((Wrapper)queryWrapper);
        }
        return false;
    }

    @Override
    public void writeLogAsync(String userId, String userName, String abstracts) {
        LogEntity entity = new LogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setUserId(userId);
        entity.setUserName(userName);
        entity.setAbstracts(abstracts);
        entity.setRequestUrl(ServletUtils.getServletPath());
        entity.setRequestMethod(ServletUtils.getRequest().getMethod());
        entity.setIpAddress(IpUtil.getIpAddr());
        entity.setPlatForm(ServletUtils.getUserAgent());
        entity.setCategory(LogSortEnum.Login.getCode());
        this.save(entity);
    }

    @Override
    public void writeLogAsync(LogEntity entity) {
        entity.setId(RandomUtil.uuId());
        this.save(entity);
    }

    @Override
    public void deleteHandleLog(String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)type);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public Set<String> queryList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)3);
        return this.list((Wrapper)queryWrapper).size() > 0 ? this.list((Wrapper)queryWrapper).stream().map(t -> t.getModuleName()).collect(Collectors.toSet()) : new HashSet<String>(16);
    }
}

