/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.mapper.ModuleDataAuthorizeSchemeMapper;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleDataAuthorizeSchemeServiceImpl
extends ServiceImpl<ModuleDataAuthorizeSchemeMapper, ModuleDataAuthorizeSchemeEntity>
implements ModuleDataAuthorizeSchemeService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ModuleDataAuthorizeSchemeEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleDataAuthorizeSchemeEntity::getSortCode)).orderByDesc(ModuleDataAuthorizeSchemeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleDataAuthorizeSchemeEntity> getEnabledMarkList(String enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeSchemeEntity::getEnabledMark, (Object)enabledMark);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleDataAuthorizeSchemeEntity::getSortCode)).orderByDesc(ModuleDataAuthorizeSchemeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleDataAuthorizeSchemeEntity> getList(String moduleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeSchemeEntity::getModuleId, (Object)moduleId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleDataAuthorizeSchemeEntity::getSortCode)).orderByDesc(ModuleDataAuthorizeSchemeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ModuleDataAuthorizeSchemeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeSchemeEntity::getId, (Object)id);
        return (ModuleDataAuthorizeSchemeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(ModuleDataAuthorizeSchemeEntity entity) {
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
            entity.setEnabledMark(1);
            entity.setSortCode(RandomUtil.parses());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, ModuleDataAuthorizeSchemeEntity entity) {
        entity.setId(id);
        entity.setEnabledMark(1);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(ModuleDataAuthorizeSchemeEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public Boolean isExistByEnCode(String id, String enCode, String moduleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeSchemeEntity::getModuleId, (Object)moduleId);
        queryWrapper.lambda().eq(ModuleDataAuthorizeSchemeEntity::getEnCode, (Object)enCode);
        if (StringUtils.isNotEmpty((String)id)) {
            queryWrapper.lambda().ne(ModuleDataAuthorizeSchemeEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }
}

