/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.system.base.entity.ModuleButtonEntity;
import com.bringspring.system.base.entity.ModuleColumnEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.mapper.ModuleMapper;
import com.bringspring.system.base.model.module.ModuleExportModel;
import com.bringspring.system.base.service.ModuleButtonService;
import com.bringspring.system.base.service.ModuleColumnService;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import com.bringspring.system.base.service.ModuleDataAuthorizeService;
import com.bringspring.system.base.service.ModuleFormService;
import com.bringspring.system.base.service.ModuleService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ModuleServiceImpl
extends ServiceImpl<ModuleMapper, ModuleEntity>
implements ModuleService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ModuleButtonService moduleButtonService;
    @Autowired
    private ModuleColumnService moduleColumnService;
    @Autowired
    private ModuleDataAuthorizeService moduleDataAuthorizeService;
    @Autowired
    private ModuleButtonService buttonService;
    @Autowired
    private ModuleColumnService columnService;
    @Autowired
    private ModuleFormService formService;
    @Autowired
    private ModuleDataAuthorizeSchemeService schemeService;
    @Autowired
    private ModuleDataAuthorizeService authorizeService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<ModuleEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleEntity::getSortCode)).orderByDesc(ModuleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleEntity> getList(String category, String keyword, String type, String enabledMark, String parentId) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)category)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getCategory, (Object)category);
        }
        if (!StringUtils.isEmpty((String)keyword)) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.like(ModuleEntity::getFullName, (Object)keyword);
            });
        }
        if (StringUtils.isNotEmpty((String)type)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getType, (Object)Integer.valueOf(type));
        }
        if (StringUtils.isNotEmpty((String)enabledMark)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getEnabledMark, (Object)Integer.valueOf(enabledMark));
        }
        if (StringUtils.isNotEmpty((String)parentId)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getParentId, (Object)parentId);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleEntity::getSortCode)).orderByDesc(ModuleEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(ModuleEntity::getLastModifyTime);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleEntity> getList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleEntity::getParentId, (Object)id);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleEntity::getSortCode)).orderByDesc(ModuleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ModuleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleEntity::getId, (Object)id);
        return (ModuleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(ModuleEntity entity, String category) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleEntity::getFullName, (Object)entity.getFullName())).eq(ModuleEntity::getCategory, (Object)category);
        if (!StringUtils.isEmpty((String)entity.getId())) {
            queryWrapper.lambda().ne(ModuleEntity::getId, (Object)entity.getId());
        }
        if ((entityList = this.list((Wrapper)queryWrapper)).size() > 0) {
            for (ModuleEntity moduleEntity : entityList) {
                if (!moduleEntity.getParentId().equals(entity.getParentId())) continue;
                return true;
            }
            return false;
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(ModuleEntity entity, String category) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleEntity::getEnCode, (Object)entity.getEnCode())).eq(ModuleEntity::getCategory, (Object)category);
        if (!StringUtils.isEmpty((String)entity.getId())) {
            queryWrapper.lambda().ne(ModuleEntity::getId, (Object)entity.getId());
            List entityList = this.list((Wrapper)queryWrapper);
            if (entityList.size() > 0) {
                for (ModuleEntity moduleEntity : entityList) {
                    if (!moduleEntity.getParentId().equals(entity.getParentId())) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    @DSTransactional
    public void delete(ModuleEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
        QueryWrapper buttonWrapper = new QueryWrapper();
        buttonWrapper.lambda().eq(ModuleButtonEntity::getModuleId, (Object)entity.getId());
        this.moduleButtonService.remove((Wrapper)buttonWrapper);
        QueryWrapper columnWrapper = new QueryWrapper();
        columnWrapper.lambda().eq(ModuleColumnEntity::getModuleId, (Object)entity.getId());
        this.moduleColumnService.remove((Wrapper)columnWrapper);
        QueryWrapper dataWrapper = new QueryWrapper();
        dataWrapper.lambda().eq(ModuleDataAuthorizeEntity::getModuleId, (Object)entity.getId());
        this.moduleDataAuthorizeService.remove((Wrapper)dataWrapper);
        Object service = SpringContext.getBean((String)"appDataServiceImpl");
        Class[] types = new Class[]{String.class};
        Object[] datas = new Object[]{entity.getId()};
        ReflectionUtil.invokeMethod((Object)service, (String)"delete", (Class[])types, (Object[])datas);
    }

    @Override
    @DSTransactional
    public void deleteModule(ModuleEntity entity) {
        QueryWrapper buttonWrapper = new QueryWrapper();
        buttonWrapper.lambda().eq(ModuleButtonEntity::getModuleId, (Object)entity.getId());
        this.moduleButtonService.remove((Wrapper)buttonWrapper);
        QueryWrapper columnWrapper = new QueryWrapper();
        columnWrapper.lambda().eq(ModuleColumnEntity::getModuleId, (Object)entity.getId());
        this.moduleColumnService.remove((Wrapper)columnWrapper);
        QueryWrapper formWrapper = new QueryWrapper();
        formWrapper.lambda().eq(ModuleFormEntity::getModuleId, (Object)entity.getId());
        this.formService.remove((Wrapper)formWrapper);
    }

    @Override
    @DSTransactional
    public void create(ModuleEntity entity) {
        boolean flag = false;
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
            flag = true;
        }
        this.save(entity);
        if ((!"3".equals(String.valueOf(entity.getType())) || !flag) && "4".equals(String.valueOf(entity.getType())) && flag) {
            for (int i = 0; i < 3; ++i) {
                String fullName = "\u65b0\u589e";
                String value = "add";
                String icon = "el-icon-plus";
                if (i == 1) {
                    fullName = "\u7f16\u8f91";
                    value = "edit";
                    icon = "el-icon-edit";
                }
                if (i == 2) {
                    fullName = "\u5220\u9664";
                    value = "remove";
                    icon = "el-icon-delete";
                }
                ModuleButtonEntity moduleButtonEntity = new ModuleButtonEntity();
                moduleButtonEntity.setId(RandomUtil.uuId());
                moduleButtonEntity.setParentId("-1");
                moduleButtonEntity.setFullName(fullName);
                moduleButtonEntity.setEnCode("btn_" + value);
                moduleButtonEntity.setSortCode(0L);
                moduleButtonEntity.setModuleId(entity.getId());
                moduleButtonEntity.setEnabledMark(1);
                moduleButtonEntity.setIcon(icon);
                this.moduleButtonService.save(moduleButtonEntity);
            }
        }
    }

    @Override
    public boolean update(String id, ModuleEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public DownloadVO exportData(String id) {
        ModuleEntity moduleEntity = this.getInfo(id);
        List<ModuleButtonEntity> buttonServiceList = this.buttonService.getList(id);
        List<ModuleColumnEntity> columnServiceList = this.columnService.getList(id);
        List<ModuleDataAuthorizeSchemeEntity> schemeServiceList = this.schemeService.getList(id);
        List<ModuleDataAuthorizeEntity> authorizeServiceList = this.authorizeService.getList(id);
        List<ModuleFormEntity> formList = this.formService.getList(id);
        ModuleExportModel exportModel = new ModuleExportModel();
        exportModel.setModuleEntity(moduleEntity);
        exportModel.setButtonEntityList(buttonServiceList);
        exportModel.setColumnEntityList(columnServiceList);
        exportModel.setFormEntityList(formList);
        exportModel.setSchemeEntityList(schemeServiceList);
        exportModel.setAuthorizeEntityList(authorizeServiceList);
        DownloadVO downloadVO = this.fileExport.exportFile((Object)exportModel, this.configValueUtil.getTemporaryFilePath(), moduleEntity.getFullName(), ModuleTypeEnum.SYSTEM_MODULE.getTableName());
        return downloadVO;
    }

    @Override
    @DSTransactional
    public boolean importData(ModuleExportModel exportModel) throws DataException {
        try {
            boolean isExists = true;
            ModuleEntity moduleEntity = exportModel.getModuleEntity();
            if (this.getInfo(moduleEntity.getId()) == null) {
                isExists = false;
                this.create(moduleEntity);
            }
            List buttonEntityList = JsonUtil.getJsonToList(exportModel.getButtonEntityList(), ModuleButtonEntity.class);
            for (Object buttonEntity : buttonEntityList) {
                if (this.buttonService.getInfo(((ModuleButtonEntity)buttonEntity).getId()) != null || this.buttonService.isExistByFullName(((ModuleButtonEntity)buttonEntity).getModuleId(), ((ModuleButtonEntity)buttonEntity).getFullName(), ((ModuleButtonEntity)buttonEntity).getId()) || this.buttonService.isExistByEnCode(((ModuleButtonEntity)buttonEntity).getModuleId(), ((ModuleButtonEntity)buttonEntity).getEnCode(), ((ModuleButtonEntity)buttonEntity).getId())) continue;
                isExists = false;
                this.buttonService.create((ModuleButtonEntity)buttonEntity);
            }
            List columnEntityList = JsonUtil.getJsonToList(exportModel.getColumnEntityList(), ModuleColumnEntity.class);
            for (Object columnEntity : columnEntityList) {
                if (this.columnService.getInfo(((ModuleColumnEntity)columnEntity).getId()) != null || this.columnService.isExistByFullName(((ModuleColumnEntity)columnEntity).getModuleId(), ((ModuleColumnEntity)columnEntity).getFullName(), ((ModuleColumnEntity)columnEntity).getId()) || this.columnService.isExistByEnCode(((ModuleColumnEntity)columnEntity).getModuleId(), ((ModuleColumnEntity)columnEntity).getEnCode(), ((ModuleColumnEntity)columnEntity).getId())) continue;
                isExists = false;
                this.columnService.create((ModuleColumnEntity)columnEntity);
            }
            List formEntityList = JsonUtil.getJsonToList(exportModel.getFormEntityList(), ModuleFormEntity.class);
            for (Object formEntity : formEntityList) {
                if (this.formService.getInfo(((ModuleFormEntity)formEntity).getId()) != null || this.formService.isExistByFullName(((ModuleFormEntity)formEntity).getModuleId(), ((ModuleFormEntity)formEntity).getFullName(), ((ModuleFormEntity)formEntity).getId()) || this.formService.isExistByEnCode(((ModuleFormEntity)formEntity).getModuleId(), ((ModuleFormEntity)formEntity).getEnCode(), ((ModuleFormEntity)formEntity).getId())) continue;
                isExists = false;
                this.formService.create((ModuleFormEntity)formEntity);
            }
            List schemeEntityList = JsonUtil.getJsonToList(exportModel.getSchemeEntityList(), ModuleDataAuthorizeSchemeEntity.class);
            for (ModuleDataAuthorizeSchemeEntity schemeEntity : schemeEntityList) {
                if (this.schemeService.getInfo(schemeEntity.getId()) != null) continue;
                isExists = false;
                this.schemeService.create(schemeEntity);
            }
            List authorizeEntityList = JsonUtil.getJsonToList(exportModel.getAuthorizeEntityList(), ModuleDataAuthorizeEntity.class);
            for (ModuleDataAuthorizeEntity authorizeEntity : authorizeEntityList) {
                if (this.authorizeService.getInfo(authorizeEntity.getId()) != null) continue;
                isExists = false;
                this.authorizeService.create(authorizeEntity);
            }
            return isExists;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new DataException(e.getMessage());
        }
    }

    @Override
    @DSTransactional
    public List<ModuleEntity> getModuleList(String visualId) {
        QueryWrapper moduleWrapper = new QueryWrapper();
        moduleWrapper.lambda().eq(ModuleEntity::getModuleId, (Object)visualId);
        return this.list((Wrapper)moduleWrapper);
    }
}

