/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util.jobutil;

import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.util.jobutil.JobManager;
import com.bringspring.system.base.util.jobutil.TimeJob;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.model.ContentModel;
import org.quartz.JobDataMap;
import org.springframework.stereotype.Component;

@Component
public class TimeUtil {
    public static void startJobNow(ContentModel model, UserInfo userInfo, TimeTaskEntity entity, String token) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("content", (Object)model);
        jobDataMap.put("tenantId", userInfo.getTenantId());
        jobDataMap.put("tenantDbConnectionString", userInfo.getTenantDbConnectionString());
        jobDataMap.put("id", entity.getId());
        jobDataMap.put("type", entity.getExecuteType());
        jobDataMap.put("token", token);
        String jobName = entity.getId();
        String jobGroupName = entity.getGroupName();
        if (StringUtils.isNotEmpty((String)userInfo.getId())) {
            JobManager jobManager = new JobManager();
            jobManager.startJobNow(jobName, jobGroupName, jobDataMap, TimeJob.class);
        }
    }

    public static void removeJob(TimeTaskEntity entity, UserInfo userInfo) {
        JobManager jobManager = new JobManager();
        String jobName = entity.getId();
        String jobGroupName = entity.getGroupName();
        if (StringUtils.isNotEmpty((String)userInfo.getId())) {
            jobManager.removeJob(jobName, jobGroupName);
        }
    }

    @JsbosTask(fullName="\u793a\u4f8b", description="example", cron="0 0 0 2 * ?")
    public static void testLocalTask() {
        System.out.println("\u5b9a\u65f6\u4efb\u52a1\u793a\u4f8b");
    }
}

