/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.emoji.EmojiUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.controller.DIngStream;
import com.bringspring.system.external.bean.WxCpDepartTreeNode;
import com.bringspring.system.external.constant.WxCpSysConfigConsts;
import com.bringspring.system.external.service.WxCpCorpService;
import com.bringspring.system.external.util.WxCpCorpValidateUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxCpCorpServiceImpl
implements WxCpCorpService {
    private static final Logger log = LoggerFactory.getLogger(WxCpCorpServiceImpl.class);
    @Autowired
    private WxCpCorpValidateUtil wxCpCorpValidateUtil;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private DIngStream dIngStream;

    @Override
    public List<SynThirdInfoEntity> saveOrUpdateOrganizeList(List<WxCpDepartTreeNode> treeList, String corpId, SynThirdInfoEntity parentThird) {
        ArrayList<OrganizeEntity> organizeList = new ArrayList<OrganizeEntity>();
        ArrayList<SynThirdInfoEntity> synThirdInfoList = new ArrayList<SynThirdInfoEntity>();
        if (ObjectUtil.isNotEmpty((Object)parentThird)) {
            synThirdInfoList.add(parentThird);
        }
        if (CollectionUtil.isNotEmpty(treeList)) {
            this.wxCpCorpValidateUtil.initData(corpId);
            this.wxCpDepartToOrganizeList(treeList, corpId, organizeList, synThirdInfoList);
            if (organizeList.size() != 0 && synThirdInfoList.size() != 0) {
                this.organizeService.saveOrUpdateBatch(organizeList);
                this.synThirdInfoService.saveOrUpdateBatch(synThirdInfoList);
                this.dIngStream.setOrganizedTree(corpId);
            }
        }
        return synThirdInfoList;
    }

    @Override
    public void wxCpDepartToOrganizeList(List<WxCpDepartTreeNode> treeList, String corpId, List<OrganizeEntity> organizeList, List<SynThirdInfoEntity> synThirdInfoList) {
        treeList.stream().forEach(item -> {
            String thirdObjid = item.getId().toString();
            String pid = item.getParentId().toString();
            boolean isTopPid = String.valueOf(WxCpSysConfigConsts.TOP_PID).equals(pid);
            SynThirdInfoEntity pThirdInfo = this.wxCpCorpValidateUtil.getThirdCorpOrgByThirdId(pid);
            String parentId = "-1";
            if (ObjectUtil.isEmpty((Object)pThirdInfo)) {
                if (CollectionUtil.isNotEmpty((Collection)synThirdInfoList) && !isTopPid) {
                    pThirdInfo = (SynThirdInfoEntity)synThirdInfoList.stream().filter(p -> p.getThirdObjectId().equals(pid)).collect(Collectors.toList()).get(0);
                    parentId = ObjectUtil.isNotEmpty((Object)pThirdInfo) ? pThirdInfo.getSystemObjectId() : parentId;
                }
            } else {
                parentId = pThirdInfo.getSystemObjectId();
            }
            OrganizeEntity organizeEntity = new OrganizeEntity();
            organizeEntity.setCategory(isTopPid ? "company" : "department");
            organizeEntity.setParentId(isTopPid ? "-1" : parentId);
            organizeEntity.setFullName(item.getName());
            organizeEntity.setSortCode((long)item.getOrder());
            SynThirdInfoEntity synThirdInfoEntity = this.wxCpCorpValidateUtil.getThirdCorpOrgByThirdId(thirdObjid);
            if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
                String systemObjectId = synThirdInfoEntity.getSystemObjectId();
                organizeEntity.setId(systemObjectId);
            } else {
                synThirdInfoEntity = this.wxCpCorpValidateUtil.newSynThirdInfoForWxDept(corpId, thirdObjid);
                organizeEntity.setId(RandomUtil.uuId());
            }
            organizeList.add(organizeEntity);
            synThirdInfoEntity.setSystemObjectId(organizeEntity.getId());
            synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
            synThirdInfoList.add(synThirdInfoEntity);
            if (CollectionUtil.isNotEmpty(item.getChildren())) {
                this.wxCpDepartToOrganizeList(item.getChildren(), corpId, organizeList, synThirdInfoList);
            }
        });
    }

    @Override
    public List<WxCpDepartTreeNode> deptListToTree(List<WxCpDepartTreeNode> departList, Long parentId) {
        List<WxCpDepartTreeNode> list = departList.stream().filter(parent -> parent.getParentId().equals(parentId)).map(child -> {
            child.setChildren(this.deptListToTree(departList, child.getId()));
            return child;
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    public void deleteOrganize(String corpId, String deptId) {
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "1", deptId, corpId);
        if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
            String systemObjectId = synThirdInfoEntity.getSystemObjectId();
            ActionResult<String> actionResult = this.organizeService.delete(systemObjectId, "wxcp_delete");
            if (MsgCode.SU003.get().equals(actionResult.getCode())) {
                this.synThirdInfoService.delete(synThirdInfoEntity);
            } else {
                String msg = actionResult.getMsg();
                synThirdInfoEntity.setDescription(msg);
            }
        }
    }

    @Override
    public List<UserEntity> saveOrUpdateUserList(List<WxCpUser> users, WxCpService wxCpService) throws WxErrorException {
        ArrayList<UserEntity> userBatch = new ArrayList<UserEntity>();
        ArrayList<SynThirdInfoEntity> synThirdInfoBatch = new ArrayList<SynThirdInfoEntity>();
        ArrayList<PositionEntity> positionBatch = new ArrayList<PositionEntity>();
        if (CollectionUtil.isNotEmpty(users)) {
            String corpId = wxCpService.getWxCpConfigStorage().getCorpId();
            this.wxCpCorpValidateUtil.initDataByUser(corpId);
            this.wxCpUserToUserList(users, wxCpService, userBatch, synThirdInfoBatch, positionBatch);
            if (StringUtils.isNotEmpty(userBatch) && StringUtils.isNotEmpty(synThirdInfoBatch)) {
                for (UserEntity entity : userBatch) {
                    this.userService.saveOrUpdateCommon(entity.getId(), entity);
                }
                this.positionService.saveOrUpdateBatch(positionBatch);
                this.userService.saveOrUpdateBatch(userBatch);
                this.synThirdInfoService.saveOrUpdateBatch(synThirdInfoBatch);
            }
        }
        return userBatch;
    }

    private void wxCpUserToUserList(List<WxCpUser> users, WxCpService wxCpService, List<UserEntity> userBatch, List<SynThirdInfoEntity> synThirdInfoBatch, List<PositionEntity> positionBatch) throws WxErrorException {
        UserEntity userEntity;
        String corpId = wxCpService.getWxCpConfigStorage().getCorpId();
        HashMap<String, UserEntity> updateUserMap = new HashMap<String, UserEntity>();
        HashMap<String, UserEntity> saveUserMap = new HashMap<String, UserEntity>();
        HashMap<String, SynThirdInfoEntity> updateThirdMap = new HashMap<String, SynThirdInfoEntity>();
        HashMap<String, SynThirdInfoEntity> saveThirdMap = new HashMap<String, SynThirdInfoEntity>();
        HashMap<String, PositionEntity> savePositionMap = new HashMap<String, PositionEntity>();
        for (WxCpUser wxCpUser : users) {
            Long[] departIds;
            List<SynThirdInfoEntity> deptThirdInfoList;
            UserEntity userEntity2;
            String userid = wxCpUser.getUserId();
            if (StringUtils.isEmpty((String)userid)) continue;
            String mobile = wxCpUser.getMobile();
            String email = wxCpUser.getEmail();
            boolean userIsNew = false;
            String thirdObjid = userid;
            SynThirdInfoEntity synThirdInfoEntity = this.wxCpCorpValidateUtil.getThirdCorpUserByThirdId(thirdObjid);
            if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
                synThirdInfoEntity.setThirdObjectId(thirdObjid);
                String systemObjectId = synThirdInfoEntity.getSystemObjectId();
                userEntity2 = this.wxCpCorpValidateUtil.getUserEntityByUserid(systemObjectId);
                if (ObjectUtil.isEmpty((Object)userEntity2) && ObjectUtil.isEmpty((Object)(userEntity2 = this.wxCpCorpValidateUtil.getUserEntity(userid, mobile, email)))) {
                    userIsNew = true;
                    userEntity2 = new UserEntity();
                    userEntity2.setId(RandomUtil.uuId());
                    userEntity2.setAccount(userid);
                }
            } else {
                synThirdInfoEntity = this.wxCpCorpValidateUtil.newSynThirdInfoForWxUser(thirdObjid);
                userEntity2 = this.wxCpCorpValidateUtil.getUserEntity(userid, mobile, email);
                if (ObjectUtil.isEmpty((Object)userEntity2)) {
                    userIsNew = true;
                    userEntity2 = new UserEntity();
                    userEntity2.setId(RandomUtil.uuId());
                    userEntity2.setAccount(userid);
                }
            }
            synThirdInfoEntity.setCropId(corpId);
            synThirdInfoEntity.setSystemObjectId(userEntity2.getId());
            if (StringUtils.isNotEmpty((String)wxCpUser.getName())) {
                String name = StringUtils.stringFilter((String)EmojiUtil.removeAllEmojis((String)wxCpUser.getName()));
                userEntity2.setRealName(name);
            }
            if (StringUtils.isNotEmpty((String)mobile)) {
                userEntity2.setMobilePhone(mobile);
            }
            if (StringUtils.isNotEmpty((String)wxCpUser.getTelephone())) {
                userEntity2.setTelePhone(wxCpUser.getTelephone());
            }
            if (StringUtils.isNotEmpty((String)email)) {
                userEntity2.setEmail(email);
            }
            boolean positionNotEmpty = false;
            if (StringUtils.isNotEmpty((String)wxCpUser.getPosition())) {
                positionNotEmpty = true;
            }
            if (CollectionUtil.isNotEmpty(deptThirdInfoList = this.departIdsConvertSynThirdInfo(corpId, wxCpService, departIds = wxCpUser.getDepartIds()))) {
                int deptNum = deptThirdInfoList.size();
                Object[] organizeId = new String[deptNum];
                Object[] positionId = new String[deptNum];
                for (int i = 0; i < deptNum; ++i) {
                    String sysDeptId = deptThirdInfoList.get(i).getSystemObjectId();
                    organizeId[i] = sysDeptId;
                    if (!positionNotEmpty) continue;
                    positionId[i] = wxCpUser.getPosition() + "/" + sysDeptId;
                }
                userEntity2.setOrganizeId(ArrayUtil.join((Object[])organizeId, (CharSequence)","));
                userEntity2.setPositionId(positionNotEmpty ? ArrayUtil.join((Object[])positionId, (CharSequence)",") : null);
            }
            userEntity2.setCode(this.wxCpCorpValidateUtil.getCode(wxCpUser));
            if (userIsNew) {
                userEntity2.setRoleId(this.wxCpCorpValidateUtil.getDefaultRoleId());
                userEntity2.setHeadIcon("/api/file/Image/userAvatar/001.png");
                userEntity2.setGender(3);
                userEntity2.setEnabledMark(1);
                userEntity2.setSecretkey(RandomUtil.uuId());
                userEntity2.setIsAdministrator(0);
                userEntity2.setPassword(this.userService.getDefaultPassword(userEntity2.getSecretkey()));
            }
            if (userIsNew) {
                if (saveUserMap.containsKey(userEntity2.getAccount())) {
                    UserEntity aUser = (UserEntity)saveUserMap.get(userEntity2.getAccount());
                    this.wxCpCorpValidateUtil.mergeDistinctOrganize(aUser, userEntity2);
                    this.wxCpCorpValidateUtil.mergeDistinctPosition(aUser, userEntity2);
                    synThirdInfoEntity.setSystemObjectId(aUser.getId());
                } else {
                    saveUserMap.put(userEntity2.getAccount(), userEntity2);
                }
                synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                saveThirdMap.put(thirdObjid, synThirdInfoEntity);
                continue;
            }
            if (updateUserMap.containsKey(userEntity2.getAccount())) {
                UserEntity aUser = (UserEntity)updateUserMap.get(userEntity2.getAccount());
                this.wxCpCorpValidateUtil.mergeDistinctOrganize(aUser, userEntity2);
                this.wxCpCorpValidateUtil.mergeDistinctPosition(aUser, userEntity2);
                synThirdInfoEntity.setSystemObjectId(aUser.getId());
            } else {
                updateUserMap.put(userEntity2.getAccount(), userEntity2);
            }
            synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
            updateThirdMap.put(thirdObjid, synThirdInfoEntity);
        }
        log.debug("===========\u62c9\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u6210\u5458\u53cd\u9988===========");
        if (!saveUserMap.isEmpty()) {
            for (String key : saveUserMap.keySet()) {
                userEntity = (UserEntity)saveUserMap.get(key);
                this.wxCpCorpValidateUtil.convertPosition(savePositionMap, userEntity);
                userBatch.add(userEntity);
            }
        }
        if (!updateUserMap.isEmpty()) {
            for (String key : updateUserMap.keySet()) {
                userEntity = (UserEntity)updateUserMap.get(key);
                this.wxCpCorpValidateUtil.setUserRelation(userEntity);
                this.wxCpCorpValidateUtil.convertPosition(savePositionMap, userEntity);
                userBatch.add(userEntity);
            }
        }
        if (!saveThirdMap.isEmpty()) {
            for (String key : saveThirdMap.keySet()) {
                synThirdInfoBatch.add((SynThirdInfoEntity)saveThirdMap.get(key));
            }
        }
        if (!updateThirdMap.isEmpty()) {
            for (String key : updateThirdMap.keySet()) {
                synThirdInfoBatch.add((SynThirdInfoEntity)updateThirdMap.get(key));
            }
        }
        if (!savePositionMap.isEmpty()) {
            for (String key : savePositionMap.keySet()) {
                positionBatch.add((PositionEntity)savePositionMap.get(key));
            }
        }
    }

    public List<SynThirdInfoEntity> departIdsConvertSynThirdInfo(String corpId, WxCpService wxCpService, Long[] departIds) throws WxErrorException {
        ArrayList<SynThirdInfoEntity> deptSynThirdInfoList = new ArrayList<SynThirdInfoEntity>();
        for (int i = 0; i < departIds.length; ++i) {
            String deptId = String.valueOf(departIds[i]);
            SynThirdInfoEntity synThirdInfo = this.recursionExistSynThirdInfo(wxCpService, deptId);
            boolean notEmpty = ObjectUtil.isNotEmpty((Object)synThirdInfo);
            if (notEmpty && deptId.equals(synThirdInfo.getThirdObjectId())) {
                deptSynThirdInfoList.add(synThirdInfo);
                continue;
            }
            Long pid = notEmpty ? Long.valueOf(synThirdInfo.getThirdObjectId()) : WxCpSysConfigConsts.TOP_PID;
            List departList = wxCpService.getDepartmentService().list(pid);
            List treeList = JsonUtil.getJsonToList((Object)departList, WxCpDepartTreeNode.class);
            List<WxCpDepartTreeNode> wxCpDepartTreeNodes = this.deptListToTree(treeList, pid);
            List<SynThirdInfoEntity> synThirdInfos = this.saveOrUpdateOrganizeList(wxCpDepartTreeNodes, corpId, null);
            if (!CollectionUtil.isNotEmpty(synThirdInfos)) continue;
            List collect = synThirdInfos.stream().filter(d -> d.getThirdObjectId().equals(deptId)).collect(Collectors.toList());
            deptSynThirdInfoList.addAll(collect);
            this.wxCpCorpValidateUtil.initData(corpId);
        }
        return deptSynThirdInfoList;
    }

    private SynThirdInfoEntity recursionExistSynThirdInfo(WxCpService wxCpService, String departId) throws WxErrorException {
        if (StringUtils.isNotEmpty((String)departId) && !String.valueOf(WxCpSysConfigConsts.TOP_PID).equals(departId)) {
            SynThirdInfoEntity synThirdInfoEntity = this.wxCpCorpValidateUtil.getThirdCorpOrgByThirdId(departId);
            if (ObjectUtil.isEmpty((Object)synThirdInfoEntity)) {
                List departList = wxCpService.getDepartmentService().list(Long.valueOf(Long.parseLong(departId)));
                if (CollectionUtil.isNotEmpty((Collection)departList)) {
                    WxCpDepart wxCpDepart = (WxCpDepart)departList.stream().filter(v -> departId.equals(String.valueOf(v.getId()))).collect(Collectors.toList()).get(0);
                    return this.recursionExistSynThirdInfo(wxCpService, String.valueOf(wxCpDepart.getParentId()));
                }
            } else {
                return synThirdInfoEntity;
            }
        }
        return null;
    }

    @Override
    public void deleteUser(String corpId, String userId) {
        String systemObjectId;
        UserEntity entity;
        String thirdObjid = userId;
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "2", thirdObjid, corpId);
        if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity) && (entity = this.userService.getInfo(systemObjectId = synThirdInfoEntity.getSystemObjectId())) != null) {
            try {
                this.userService.delete(entity);
                this.synThirdInfoService.delete(synThirdInfoEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

