/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.controller;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.message.entity.MessageEntity;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.MessageInfoVO;
import com.bringspring.system.message.model.message.MessageNoticeVO;
import com.bringspring.system.message.model.message.MessageRecordForm;
import com.bringspring.system.message.model.message.NoticeCrForm;
import com.bringspring.system.message.model.message.NoticeInfoVO;
import com.bringspring.system.message.model.message.NoticeUpForm;
import com.bringspring.system.message.model.message.PaginationMessage;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.JsbosMessageUtil;
import com.bringspring.system.message.util.QyWebChatUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u516c\u544a"}, value="Message")
@RestController
@RequestMapping(value={"/api/message"})
public class MessageController {
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u516c\u544a\u5217\u8868\uff08\u5e26\u5206\u9875\uff09")
    @GetMapping(value={"/Notice"})
    public ActionResult<PageListVO<MessageNoticeVO>> noticeList(Pagination pagination) {
        List<MessageEntity> list = this.messageService.getNoticeList(pagination);
        List<UserEntity> userList = this.userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        List voList = JsonUtil.getJsonToList(list, MessageNoticeVO.class);
        return ActionResult.page((List)voList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6dfb\u52a0\u7cfb\u7edf\u516c\u544a")
    @PostMapping
    public ActionResult create(@RequestBody @Valid NoticeCrForm noticeCrForm) {
        MessageEntity entity = (MessageEntity)JsonUtil.getJsonToBean((Object)noticeCrForm, MessageEntity.class);
        switch (entity.getSendType()) {
            case "department": {
                List<String> departmentList = Arrays.asList(entity.getSendId().split(","));
                List userIds = this.userRelationService.getListByOrgId(departmentList).stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                entity.setToUserIds(String.join((CharSequence)",", userIds));
            }
        }
        this.messageService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u7cfb\u7edf\u516c\u544a")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid NoticeUpForm messageUpForm) {
        MessageEntity entity = (MessageEntity)JsonUtil.getJsonToBean((Object)messageUpForm, MessageEntity.class);
        switch (entity.getSendType()) {
            case "department": {
                List<String> departmentList = Arrays.asList(entity.getSendId().split(","));
                List userIds = this.userRelationService.getListByOrgId(departmentList).stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                entity.setToUserIds(String.join((CharSequence)",", userIds));
            }
        }
        boolean flag = this.messageService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u83b7\u53d6/\u67e5\u770b\u7cfb\u7edf\u516c\u544a\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<NoticeInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        MessageEntity entity;
        UserEntity info = this.userService.getInfo((entity = this.messageService.getinfo(id)).getCreatorUserId());
        entity.setCreatorUserId(info != null ? info.getRealName() : "");
        NoticeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, NoticeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5220\u9664\u7cfb\u7edf\u516c\u544a")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        MessageEntity entity = this.messageService.getinfo(id);
        if (entity != null) {
            this.messageService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u53d1\u5e03\u7cfb\u7edf\u516c\u544a")
    @Transactional
    @PutMapping(value={"/{id}/Actions/Release"})
    public ActionResult release(@PathVariable(value="id") String id) {
        MessageEntity entity = this.messageService.getinfo(id);
        if (entity != null) {
            List<String> userIds = null;
            switch (entity.getSendType()) {
                case "user": {
                    if (StringUtil.isNotEmpty((String)entity.getToUserIds())) {
                        userIds = Arrays.asList(entity.getToUserIds().split(","));
                        break;
                    }
                    userIds = this.userService.getListId();
                    break;
                }
                case "department": {
                    userIds = Arrays.asList(entity.getToUserIds().replaceAll(" ", "").split(","));
                }
            }
            this.messageService.sentNotice(userIds, entity);
            MessageTemplateEntity messageTemplateEntity = new MessageTemplateEntity();
            messageTemplateEntity.setTitle("\u53d1\u6587\uff1a\u6709\u65b0\u6536\u5230\u7684\u516c\u544a\u7b49\u5f85\u60a8\u7684\u9605\u8bfb\u3002");
            messageTemplateEntity.setContent("\u6807\u9898\uff1a" + entity.getTitle());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("AppUrl", "https://gl.bringspring.com/jsbos-app/#/pages/notice/index?id=" + entity.getId());
            this.SendQyWebChat(userIds, this.userProvider.get(), "1", messageTemplateEntity, map);
            return ActionResult.success((String)"\u53d1\u5e03\u6210\u529f");
        }
        return ActionResult.fail((String)"\u53d1\u5e03\u5931\u8d25");
    }

    @ApiOperation(value="\u5217\u8868\uff08\u901a\u77e5\u516c\u544a/\u7cfb\u7edf\u6d88\u606f/\u79c1\u4fe1\u6d88\u606f\uff09")
    @GetMapping
    public ActionResult<PageListVO<MessageInfoVO>> messageList(PaginationMessage pagination) {
        List<MessageEntity> list = this.messageService.getMessageList(pagination, pagination.getType(), pagination.getAppid(), pagination.getIsShowRead());
        List<UserEntity> userList = this.userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        List listVO = JsonUtil.getJsonToList(list, MessageInfoVO.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u5217\u8868\uff08\u901a\u77e5\u516c\u544a/\u7cfb\u7edf\u6d88\u606f/\u79c1\u4fe1\u6d88\u606f\uff09")
    @PostMapping(value={"/getUnreadCount"})
    public ActionResult<Integer> getUnreadCount(String userId) {
        int unreadCount = this.messageService.getUnreadCount(userId);
        return ActionResult.success((Object)unreadCount);
    }

    @ApiOperation(value="\u8bfb\u53d6\u6d88\u606f")
    @GetMapping(value={"/ReadInfo/{id}"})
    public ActionResult readInfo(@PathVariable(value="id") String id) throws DataException {
        MessageEntity entity = this.messageService.getinfo(id);
        if (entity != null) {
            MessageReceiveEntity receive = this.messageService.messageRead(id);
            UserEntity user = this.userService.getInfo(entity.getCreatorUserId());
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
            entity.setBodyText(receive != null ? receive.getBodyText() : null);
        }
        NoticeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, NoticeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5168\u90e8\u5df2\u8bfb")
    @PostMapping(value={"/Actions/ReadAll"})
    public ActionResult allRead() {
        this.messageService.messageRead();
        return ActionResult.success((String)"\u5df2\u8bfb\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664\u6d88\u606f")
    @DeleteMapping(value={"/Record"})
    public ActionResult deleteRecord(@RequestBody MessageRecordForm recordForm) {
        String[] id = recordForm.getIds().split(",");
        List<String> list = Arrays.asList(id);
        this.messageService.deleteRecord(list);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    private JSONObject SendQyWebChat(List<String> toUserIdsList, UserInfo userInfo, String sendType, MessageTemplateEntity entity, Map<String, String> parameterMap) {
        String title;
        String content = entity.getContent();
        if (StringUtil.isNotEmpty((String)content) && null != parameterMap) {
            StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
            content = strSubstitutor.replace(content);
        }
        if (StringUtil.isNotEmpty((String)(title = entity.getTitle())) && null != parameterMap) {
            StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
            title = strSubstitutor.replace(title);
        }
        Map<String, String> objModel = this.getSystemConfig();
        BaseSystemInfo config = (BaseSystemInfo)JsonUtil.getJsonToBean(objModel, BaseSystemInfo.class);
        String corpId = config.getQyhCorpId();
        String agentId = config.getQyhAgentId();
        String corpSecret = config.getQyhAgentSecret();
        String wxUserId = "";
        StringBuilder toWxUserId = new StringBuilder();
        String toUserIdAll = "";
        StringBuilder nullUserInfo = new StringBuilder();
        ArrayList<MessageReceiveEntity> messageReceiveList = new ArrayList<MessageReceiveEntity>();
        JSONObject retJson = new JSONObject();
        if (StringUtil.isEmpty((String)corpId)) {
            log.error("\u4f01\u4e1aID\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)corpSecret)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"Secret\u4e3a\u7a7a");
            return retJson;
        }
        if (StringUtil.isEmpty((String)agentId)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"AgentId\u4e3a\u7a7a");
            return retJson;
        }
        if (StringUtil.isEmpty((String)content)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u5185\u5bb9\u4e3a\u7a7a");
            return retJson;
        }
        if (toUserIdsList == null || toUserIdsList.size() < 1) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
            return retJson;
        }
        MessageEntity messageEntity = JsbosMessageUtil.setMessageEntity(userInfo.getUserId(), title, null, Integer.parseInt(sendType));
        for (String userId : toUserIdsList) {
            wxUserId = "";
            SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "2", userId);
            if (synThirdInfoEntity != null) {
                wxUserId = synThirdInfoEntity.getThirdObjectId();
            }
            if (StringUtil.isEmpty((String)wxUserId)) {
                nullUserInfo = nullUserInfo.append(",").append(userId);
            } else {
                toWxUserId = toWxUserId.append(",").append(wxUserId);
            }
            messageReceiveList.add(JsbosMessageUtil.setMessageReceiveEntity(messageEntity.getId(), userId));
        }
        toUserIdAll = toWxUserId.toString();
        if (StringUtil.isNotEmpty((String)toUserIdAll)) {
            toUserIdAll = toUserIdAll.substring(1);
        }
        if (StringUtil.isEmpty((String)toUserIdAll)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u63a5\u6536\u4eba\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1\u53f7\u5168\u90e8\u4e3a\u7a7a");
            return retJson;
        }
        String appUrl = parameterMap.get("AppUrl");
        retJson = QyWebChatUtil.sendWxMessage(corpId, corpSecret, agentId, toUserIdAll, title, content, appUrl);
        if (!retJson.getBoolean("code").booleanValue()) {
            return retJson;
        }
        if (StringUtil.isNotEmpty((String)nullUserInfo.toString())) {
            messageEntity.setDescription(nullUserInfo.substring(1) + "\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1\u53f7\u4e3a\u7a7a");
        }
        retJson.put("code", (Object)true);
        retJson.put("error", (Object)MsgCode.SU012.get());
        return retJson;
    }

    private Map<String, String> getSystemConfig() {
        List<SysConfigEntity> configList = this.sysConfigService.getList();
        HashMap<String, String> objModel = new HashMap<String, String>(16);
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        return objModel;
    }
}

