/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.WxErrorException;
import com.bringspring.system.base.model.systemconfig.SysConfigCropModel;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.RegexUtils;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.QyWebChatUserModel;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.service.SynThirdQyService;
import com.bringspring.system.message.util.SynDingTalkUtil;
import com.bringspring.system.message.util.SynQyWebChatUtil;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.mapper.OrganizeMapper;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SynThirdQyServiceImpl
extends ServiceImpl<OrganizeMapper, OrganizeEntity>
implements SynThirdQyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RoleService roleService;

    @Override
    public BaseSystemInfo getQyhConfig() {
        HashMap<String, String> objModel = new HashMap<String, String>();
        List<SysConfigEntity> configList = this.sysConfigService.getList();
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        BaseSystemInfo baseSystemInfo = (BaseSystemInfo)JsonUtil.getJsonToBean(objModel, BaseSystemInfo.class);
        return baseSystemInfo;
    }

    public JSONObject checkDepartmentSysToQy(SynThirdInfoEntity synThirdInfoEntity) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            if ("".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) || "null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u90e8\u95e8\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u90e8\u95e8\u672a\u540c\u6b65\u5230\u4f01\u4e1a\u5fae\u4fe1!");
        }
        return retMsg;
    }

    public JSONObject checkCnEnName(String cnName, String EnName, String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, String deptFlag) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        if (cnName.equals(EnName)) {
            Integer synState = SynThirdConsts.SYN_STATE_FAIL;
            String description = deptFlag + "\u90e8\u95e8\u4e2d\u6587\u540d\u79f0\u4e0e\u82f1\u6587\u540d\u79f0\u4e0d\u80fd\u76f8\u540c";
            this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, thirdType, dataType, sysObjId, thirdObjId, synState, description);
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)description);
        }
        return retMsg;
    }

    @Override
    public void saveSynThirdInfoEntity(String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, Integer synState, String description) {
        UserInfo userInfo = this.userProvider.get();
        SynThirdInfoEntity entity = new SynThirdInfoEntity();
        String compValue = "add";
        if (compValue.equals(opType)) {
            entity.setId(RandomUtil.uuId());
            entity.setThirdType(thirdType);
            entity.setDataType(dataType);
            entity.setSystemObjectId(sysObjId);
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(DateUtil.getNowDate());
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setLastModifyTime(DateUtil.getNowDate());
            this.synThirdInfoService.create(entity);
        } else {
            entity = synThirdInfoEntity;
            entity.setThirdType(thirdType);
            entity.setDataType(dataType);
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setLastModifyTime(DateUtil.getNowDate());
            this.synThirdInfoService.update(entity.getId(), entity);
        }
    }

    @Override
    public JSONObject createDepartmentSysToQy(boolean isBatch, OrganizeEntity deptEntity, String accessToken) throws WxErrorException {
        BaseSystemInfo config = this.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        String compValue = "company";
        int qyhIsSyn = isBatch ? 1 : config.getQyhIsSynOrg();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        JSONObject object = new JSONObject();
        String thirdObjId = "";
        Integer synState = 0;
        String description = "";
        boolean isDeptDiff = true;
        String deptFlag = "\u521b\u5efa\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u521b\u5efa\uff1a\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (qyhIsSyn == 1) {
            if (isBatch) {
                access_token = accessToken;
            } else {
                tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
                access_token = tokenObject.getString("access_token");
            }
            if (access_token != null && !"".equals(access_token)) {
                object.put("id", null);
                object.put("name", (Object)deptEntity.getFullName());
                object.put("name_en", (Object)deptEntity.getEnCode());
                if (compValue.equals(deptEntity.getCategory()) && "-1".equals(deptEntity.getParentId())) {
                    object.put("parentid", (Object)1);
                } else {
                    SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptEntity.getParentId());
                    retMsg = this.checkDepartmentSysToQy(synThirdInfoEntity);
                    isDeptDiff = retMsg.getBoolean("code");
                    if (isDeptDiff) {
                        object.put("parentid", (Object)synThirdInfoEntity.getThirdObjectId());
                    }
                }
                object.put("order", (Object)deptEntity.getSortCode());
                retMsg = this.checkCnEnName(object.getString("name"), object.getString("name_en"), "add", null, Integer.parseInt("1"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                if (!retMsg.getBoolean("code").booleanValue()) {
                    return retMsg;
                }
                if (qyhIsSyn == 1) {
                    retMsg = SynQyWebChatUtil.createDepartment(object.toJSONString(), access_token);
                    if (retMsg.getBoolean("code").booleanValue()) {
                        thirdObjId = retMsg.getString("retDeptId");
                        synState = SynThirdConsts.SYN_STATE_OK;
                    } else {
                        synState = SynThirdConsts.SYN_STATE_FAIL;
                        description = deptFlag + retMsg.getString("error");
                    }
                } else {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                    retMsg.put("code", (Object)true);
                    retMsg.put("error", (Object)description);
                    retMsg.put("retDeptId", (Object)"0");
                }
            } else {
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = deptFlag + "\u90e8\u95e8\u6240\u5c5e\u7684\u4e0a\u7ea7\u90e8\u95e8\u672a\u540c\u6b65\u5230\u4f01\u4e1a\u5fae\u4fe1";
                retMsg.put("code", (Object)false);
                retMsg.put("error", (Object)description);
                retMsg.put("retDeptId", (Object)"0");
            }
        } else {
            synState = SynThirdConsts.SYN_STATE_FAIL;
            description = deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)description);
            retMsg.put("retDeptId", (Object)"0");
        }
        this.saveSynThirdInfoEntity("add", null, Integer.parseInt("1"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    @Override
    public JSONObject updateDepartmentSysToQy(boolean isBatch, OrganizeEntity deptEntity, String accessToken, BaseSystemInfo config) throws Exception {
        String corpId = "";
        String corpSecret = "";
        if (!ObjectUtil.isEmpty((Object)config)) {
            corpId = config.getQyhCorpId();
            corpSecret = config.getQyhCorpSecret();
            config = this.getQyhConfig();
        }
        String compValue = "company";
        int qyhIsSyn = isBatch ? 1 : config.getQyhIsSynOrg();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        JSONObject object = new JSONObject();
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        String opType = "";
        Integer synState = 0;
        String description = "";
        String thirdObjId = "";
        SynThirdInfoEntity synThirdInfoPara = new SynThirdInfoEntity();
        boolean isDeptDiff = true;
        String deptFlag = "\u66f4\u65b0\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (ObjectUtil.isEmpty((Object)accessToken)) {
            SynThirdInfoEntity synThirdInfoEntity1 = (SynThirdInfoEntity)this.synThirdInfoService.getInfoBySysObjIds("2", "1", deptEntity.getId()).stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
            config.getDingCom();
            SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
            List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
            List collectCrop = jsonToList.stream().filter(v -> synThirdInfoEntity1.getCropId().equals(v.getClientId())).collect(Collectors.toList());
            corpId = ((SysConfigCropModel)collectCrop.get(0)).getClientId();
            corpSecret = ((SysConfigCropModel)collectCrop.get(0)).getClientSecrent();
            accessToken = SynDingTalkUtil.getAccessToken(corpId, corpSecret).getString("access_token");
        }
        if (qyhIsSyn == 1) {
            if (isBatch) {
                access_token = accessToken;
            } else {
                tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
                access_token = tokenObject.getString("access_token");
            }
            List<SynThirdInfoEntity> thirdInfoEntities = this.synThirdInfoService.getInfoBySysObjIds("1", "1", deptEntity.getId());
            synThirdInfoEntity = (SynThirdInfoEntity)thirdInfoEntities.stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
            if (access_token != null && !"".equals(access_token)) {
                object.put("id", null);
                object.put("name", (Object)deptEntity.getFullName());
                object.put("name_en", (Object)deptEntity.getEnCode());
                if (compValue.equals(deptEntity.getCategory())) {
                    object.put("parentid", (Object)1);
                } else {
                    synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptEntity.getParentId());
                    retMsg = this.checkDepartmentSysToQy(synThirdInfoEntity);
                    isDeptDiff = retMsg.getBoolean("code");
                    if (isDeptDiff) {
                        object.put("parentid", (Object)synThirdInfoEntity.getThirdObjectId());
                    }
                }
                object.put("order", (Object)deptEntity.getSortCode());
                if (isDeptDiff) {
                    synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptEntity.getId());
                    retMsg = this.checkDepartmentSysToQy(synThirdInfoEntity);
                    if (!retMsg.getBoolean("code").booleanValue()) {
                        if ("3".equals(retMsg.getString("flag")) || "1".equals(retMsg.getString("flag"))) {
                            if ("1".equals(retMsg.getString("flag"))) {
                                this.synThirdInfoService.delete(synThirdInfoEntity);
                            }
                            opType = "add";
                            synThirdInfoPara = null;
                            thirdObjId = "";
                            retMsg = this.checkCnEnName(object.getString("name"), object.getString("name_en"), opType, synThirdInfoPara, Integer.parseInt("1"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                            if (!retMsg.getBoolean("code").booleanValue()) {
                                return retMsg;
                            }
                            retMsg = SynQyWebChatUtil.createDepartment(object.toJSONString(), access_token);
                            if (retMsg.getBoolean("code").booleanValue()) {
                                thirdObjId = retMsg.getString("retDeptId");
                                synState = SynThirdConsts.SYN_STATE_OK;
                                description = "";
                            } else {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = deptFlag + retMsg.getString("error");
                            }
                        }
                        if ("2".equals(retMsg.getString("flag"))) {
                            opType = "upd";
                            synThirdInfoPara = synThirdInfoEntity;
                            thirdObjId = "";
                            retMsg = this.checkCnEnName(object.getString("name"), object.getString("name_en"), opType, synThirdInfoPara, Integer.parseInt("1"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                            if (!retMsg.getBoolean("code").booleanValue()) {
                                return retMsg;
                            }
                            retMsg = SynQyWebChatUtil.createDepartment(object.toJSONString(), access_token);
                            if (retMsg.getBoolean("code").booleanValue()) {
                                thirdObjId = retMsg.getString("retDeptId");
                                synState = SynThirdConsts.SYN_STATE_OK;
                                description = "";
                            } else {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = deptFlag + retMsg.getString("error");
                            }
                        }
                    } else {
                        opType = "upd";
                        synThirdInfoPara = synThirdInfoEntity;
                        thirdObjId = synThirdInfoEntity.getThirdObjectId();
                        retMsg = this.checkCnEnName(object.getString("name"), object.getString("name_en"), opType, synThirdInfoPara, Integer.parseInt("1"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                        if (!retMsg.getBoolean("code").booleanValue()) {
                            return retMsg;
                        }
                        object.put("id", (Object)synThirdInfoEntity.getThirdObjectId());
                        retMsg = SynQyWebChatUtil.updateDepartment(object.toJSONString(), access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            synState = SynThirdConsts.SYN_STATE_OK;
                            description = "";
                        } else {
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = deptFlag + retMsg.getString("error");
                        }
                    }
                } else {
                    if (synThirdInfoEntity != null) {
                        opType = "upd";
                        synThirdInfoPara = synThirdInfoEntity;
                        thirdObjId = synThirdInfoEntity.getThirdObjectId();
                    } else {
                        opType = "add";
                        synThirdInfoPara = null;
                        thirdObjId = "";
                    }
                    synState = SynThirdConsts.SYN_STATE_FAIL;
                    description = deptFlag + "\u4e0a\u7ea7\u90e8\u95e8\u65e0\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID";
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)description);
                }
            } else {
                if (synThirdInfoEntity != null) {
                    opType = "upd";
                    synThirdInfoPara = synThirdInfoEntity;
                    thirdObjId = synThirdInfoEntity.getThirdObjectId();
                } else {
                    opType = "add";
                    synThirdInfoPara = null;
                    thirdObjId = "";
                }
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
                retMsg.put("code", (Object)true);
                retMsg.put("error", (Object)description);
            }
        } else {
            synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptEntity.getId());
            if (synThirdInfoEntity != null) {
                opType = "upd";
                synThirdInfoPara = synThirdInfoEntity;
                thirdObjId = synThirdInfoEntity.getThirdObjectId();
            } else {
                opType = "add";
                synThirdInfoPara = null;
                thirdObjId = "";
            }
            synState = SynThirdConsts.SYN_STATE_NO;
            description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
            retMsg.put("code", (Object)true);
            retMsg.put("error", (Object)description);
        }
        this.saveSynThirdInfoEntity(opType, synThirdInfoPara, Integer.parseInt("1"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    @Override
    public JSONObject deleteDepartmentSysToQy(boolean isBatch, String id, String accessToken) throws WxErrorException {
        BaseSystemInfo config = this.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        int qyhIsSyn = isBatch ? 1 : config.getQyhIsSynOrg();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", id);
        String deptFlag = "\u5220\u9664\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (synThirdInfoEntity != null) {
            if (qyhIsSyn == 1) {
                if (isBatch) {
                    access_token = accessToken;
                } else {
                    tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
                    access_token = tokenObject.getString("access_token");
                }
                if (access_token != null && !"".equals(access_token)) {
                    if (!"".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) && !"null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                        retMsg = SynQyWebChatUtil.deleteDepartment(synThirdInfoEntity.getThirdObjectId(), access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            this.synThirdInfoService.delete(synThirdInfoEntity);
                        } else {
                            this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("1"), Integer.parseInt("1"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, deptFlag + retMsg.getString("error"));
                        }
                    } else {
                        this.synThirdInfoService.delete(synThirdInfoEntity);
                    }
                } else {
                    this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("1"), Integer.parseInt("1"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f");
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)(deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f\uff01"));
                }
            } else {
                this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("1"), Integer.parseInt("1"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_NO, deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
                retMsg.put("code", (Object)true);
                retMsg.put("error", (Object)(deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65"));
            }
        }
        return retMsg;
    }

    @Override
    public QyWebChatUserModel getQyUserById(String id, String accessToken) throws WxErrorException {
        QyWebChatUserModel userModel = new QyWebChatUserModel();
        JSONObject userObject = SynQyWebChatUtil.getUserById(id, accessToken);
        System.out.println("userObject=====>" + userObject);
        if (userObject.getBoolean("code").booleanValue()) {
            userModel = (QyWebChatUserModel)JsonUtil.getJsonToBean((String)userObject.getString("userinfo"), QyWebChatUserModel.class);
        }
        return userModel;
    }

    @Override
    public void synQyToOrganizeSys(String id, String companyId) throws Exception {
        JSONObject retMsg = new JSONObject();
        SysConfigEntity weComInfo = this.sysConfigService.getConfigByKeyName("weCom");
        List jsonToListMap = JsonUtil.getJsonToListMap((String)weComInfo.getKeyValue());
        List qyhCorpId = jsonToListMap.stream().filter(v -> companyId.equals(v.get("qyhCorpId"))).collect(Collectors.toList());
        String corpId = String.valueOf(((Map)qyhCorpId.get(0)).get("qyhCorpId"));
        String corpSecret = String.valueOf(((Map)qyhCorpId.get(0)).get("qyhAgentSecret"));
        String access_token = "";
        UserInfo userInfo = this.userProvider.get();
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                throw new Exception("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
            }
            access_token = tokenObject.getString("access_token");
            JSONObject departmentList = SynQyWebChatUtil.getDepartmentDetail(id, access_token);
            System.out.println("departmentList=====>" + departmentList);
            ArrayList<OrganizeEntity> departmentQy = new ArrayList<OrganizeEntity>();
            JSONObject jo = JSONObject.parseObject((String)String.valueOf(departmentList));
            String department = String.valueOf(jo.get((Object)"department"));
            JSONObject organizeEntity = JSON.parseObject((String)department);
            System.out.println("organizeEntity======>" + organizeEntity);
            OrganizeEntity organizeEntityQy = new OrganizeEntity();
            organizeEntityQy.setId(String.valueOf(organizeEntity.get("id")));
            organizeEntityQy.setFullName(String.valueOf(organizeEntity.get("name")));
            organizeEntityQy.setParentId(String.valueOf(organizeEntity.get("parentid")));
            organizeEntityQy.setSortCode((long)Long.valueOf(String.valueOf(organizeEntity.get("order"))));
            organizeEntityQy.setManagerId(String.valueOf(organizeEntity.get("department_leader")).replaceAll("\\[", "").replaceAll("]", "").replaceAll("\"", ""));
            organizeEntityQy.setCategory("department");
            if ("1".equals(String.valueOf(organizeEntity.get("id")))) {
                organizeEntityQy.setCategory("company");
                organizeEntityQy.setEnCode("R");
            } else {
                organizeEntityQy.setCategory("department");
            }
            departmentQy.add(organizeEntityQy);
            List<SynThirdInfoEntity> infoByThirdObjId = this.synThirdInfoService.getInfoByThirdObjIds("1", "1", id);
            if (!ObjectUtil.isEmpty(infoByThirdObjId)) {
                this.createOrgan(organizeEntityQy);
                SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
                synThirdInfoEntity.setThirdObjectId(organizeEntityQy.getId());
                synThirdInfoEntity.setSystemObjectId(organizeEntityQy.getId());
                synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
                synThirdInfoEntity.setDataType(Integer.valueOf("1"));
                synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                synThirdInfoEntity.setCreatorUserId(userInfo.getUserId());
                synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
                synThirdInfoEntity.setCropId(companyId);
                synThirdInfoEntity.setId(RandomUtil.uuId());
                this.synThirdInfoService.saveOrUpdate(synThirdInfoEntity);
            } else {
                departmentQy.add(organizeEntityQy);
                boolean bl = this.organizeService.update(String.valueOf(organizeEntity.get("id")), organizeEntityQy);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        this.setOrganizeCode();
        this.setOrganizedTree();
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
    }

    @Override
    public void synQyToUserSys(String id, String companyId) throws Exception {
        SysConfigEntity weComInfo = this.sysConfigService.getConfigByKeyName("weCom");
        List jsonToListMap = JsonUtil.getJsonToListMap((String)weComInfo.getKeyValue());
        List qyhCorpId = jsonToListMap.stream().filter(v -> companyId.equals(v.get("qyhCorpId"))).collect(Collectors.toList());
        String corpId = String.valueOf(((Map)qyhCorpId.get(0)).get("qyhCorpId"));
        String corpSecret = String.valueOf(((Map)qyhCorpId.get(0)).get("qyhAgentSecret"));
        String access_token = "";
        UserInfo userInfo = this.userProvider.get();
        JSONObject tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
        if (!tokenObject.getBoolean("code").booleanValue()) {
            throw new Exception("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25");
        }
        access_token = tokenObject.getString("access_token");
        QyWebChatUserModel qyWebChatUserModel = this.getQyUserById(id, access_token);
        System.out.println("qyWebChatUserModel=====>" + qyWebChatUserModel);
        List<RoleEntity> listByEnCode = this.roleService.getListByEnCode("SimpleUser");
        if (ObjectUtil.isNotEmpty((Object)qyWebChatUserModel)) {
            List<SynThirdInfoEntity> infoByThirdObjId;
            OrganizeEntity companyInfo;
            UserEntity userEntity = new UserEntity();
            String userid = String.valueOf(qyWebChatUserModel.getUserid());
            SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getUserid())) {
                synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "2", userid);
                if (null != synThirdInfoEntity) {
                    userEntity.setId(synThirdInfoEntity.getSystemObjectId());
                } else {
                    userEntity.setId(RandomUtil.uuId());
                    synThirdInfoEntity = new SynThirdInfoEntity();
                    synThirdInfoEntity.setId(RandomUtil.uuId());
                }
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getName())) {
                userEntity.setRealName(String.valueOf(qyWebChatUserModel.getName()).replaceAll("[^\u4e00-\u9fa5]", ""));
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getAlias())) {
                userEntity.setQuickQuery(qyWebChatUserModel.getAlias());
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getAlias())) {
                userEntity.setNickName(qyWebChatUserModel.getAlias());
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getUserid())) {
                userEntity.setAccount(qyWebChatUserModel.getUserid());
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getDepartment())) {
                userEntity.setOrganizeId(qyWebChatUserModel.getDepartment().replaceAll("\\[", "").replaceAll("]", ""));
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getMobile())) {
                userEntity.setMobilePhone(qyWebChatUserModel.getMobile());
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getEmail())) {
                userEntity.setEmail(qyWebChatUserModel.getEmail());
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getAddress())) {
                userEntity.setPostalAddress(qyWebChatUserModel.getAddress());
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getGender()) && !"0".equals(qyWebChatUserModel.getGender())) {
                userEntity.setGender(Integer.parseInt(String.valueOf(qyWebChatUserModel.getGender())));
            } else {
                userEntity.setGender(3);
            }
            if (!StringUtils.isNull((Object)qyWebChatUserModel.getPosition())) {
                userEntity.setPositionId(qyWebChatUserModel.getPosition());
            }
            userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
            userEntity.setEnabledMark(1);
            userEntity.setRoleId(listByEnCode.get(0).getId());
            OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
            if (!ObjectUtil.isEmpty((Object)organizeEntity) && ObjectUtil.isNotEmpty((Object)organizeEntity.getOrganizeId()) && !ObjectUtil.isEmpty((Object)(companyInfo = this.organizeService.getInfo(organizeEntity.getOrganizeId())))) {
                String enCode = companyInfo.getEnCode() + "Staff";
                String billNumber = "";
                billNumber = this.baseDataUtil.getBillNumber(enCode, false);
                if (ObjectUtil.isEmpty((Object)billNumber)) {
                    billNumber = "A";
                }
                userEntity.setCode(billNumber);
            }
            if (ObjectUtil.isEmpty(infoByThirdObjId = this.synThirdInfoService.getInfoByThirdObjIds("1", "2", id))) {
                this.userService.createUser(userEntity);
            } else {
                boolean bl = this.userService.updateById(userEntity);
            }
            synThirdInfoEntity.setThirdObjectId(String.valueOf(qyWebChatUserModel.getUserid()));
            synThirdInfoEntity.setSystemObjectId(userEntity.getId());
            synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
            synThirdInfoEntity.setDataType(Integer.valueOf("2"));
            synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
            synThirdInfoEntity.setCropId(corpId);
            synThirdInfoEntity.setCreatorUserId(userInfo.getUserId());
            synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
            this.synThirdInfoService.saveOrUpdate(synThirdInfoEntity);
        }
    }

    public JSONObject setQyUserObject(UserEntity userEntity, QyWebChatUserModel qyWebChatUserModel) {
        List<UserEntity> userList = this.userService.getList();
        JSONObject object = new JSONObject();
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        if (StringUtils.isNotEmpty((String)userEntity.getEmail()) && !RegexUtils.checkEmail(userEntity.getEmail())) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
            retMsg.put("qyUserObject", (Object)"");
            return retMsg;
        }
        object.put("userid", (Object)userEntity.getId());
        object.put("name", (Object)userEntity.getRealName());
        object.put("mobile", (Object)userEntity.getMobilePhone());
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", userEntity.getOrganizeId());
        retMsg = this.checkDepartmentSysToQy(synThirdInfoEntity);
        if (!retMsg.getBoolean("code").booleanValue()) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u90e8\u95e8\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID\uff01");
            retMsg.put("qyUserObject", (Object)"");
            return retMsg;
        }
        String formatString = "[%s]";
        object.put("department", (Object)String.format(formatString, synThirdInfoEntity.getThirdObjectId()));
        object.put("main_department", (Object)synThirdInfoEntity.getThirdObjectId());
        String isLeader = userList.stream().filter(t -> userEntity.getOrganizeId().equals(t.getOrganizeId()) && userEntity.getId().equals(t.getManagerId())).count() == 0L ? "0" : "1";
        object.put("is_leader_in_dept", (Object)String.format(formatString, isLeader));
        object.put("email", (Object)userEntity.getEmail());
        PositionEntity positionEntity = this.positionService.getInfo(userEntity.getPositionId());
        if (positionEntity != null) {
            object.put("position", (Object)positionEntity.getFullName());
        } else {
            object.put("position", (Object)"");
        }
        object.put("gender", (Object)userEntity.getGender().toString());
        object.put("telephone", (Object)userEntity.getTelePhone());
        object.put("enable", (Object)userEntity.getEnabledMark());
        JSONObject extattr = new JSONObject();
        extattr.put("attrs", (Object)"[]");
        object.put("extattr", (Object)extattr.toJSONString());
        object.put("address", (Object)userEntity.getPostalAddress());
        object.put("alias", (Object)"");
        object.put("avatar_mediaid", (Object)"");
        JSONObject external_profile = new JSONObject();
        external_profile.put("external_corp_name", (Object)"");
        external_profile.put("external_attr", (Object)"[]");
        object.put("external_profile", (Object)external_profile.toJSONString());
        object.put("external_position", (Object)"");
        if (qyWebChatUserModel != null) {
            object.put("alias", (Object)qyWebChatUserModel.getAlias());
            object.put("avatar_mediaid", (Object)qyWebChatUserModel.getAvatar_mediaid());
            object.put("external_profile", (Object)qyWebChatUserModel.getExternal_profile());
            object.put("external_position", (Object)qyWebChatUserModel.getExternal_position());
        }
        String jsonString = object.toJSONString();
        jsonString = jsonString.replaceAll("\\\\", "");
        jsonString = jsonString.replaceAll("\"\\{", "{");
        jsonString = jsonString.replaceAll("}\"", "}");
        jsonString = jsonString.replaceAll("\"\\[", "[");
        jsonString = jsonString.replaceAll("\\]\"", "]");
        retMsg.put("qyUserObject", (Object)jsonString);
        return retMsg;
    }

    public JSONObject checkUserMobileEmailRepeat(String mobile, String email, String userId, List<QyWebChatUserModel> qyUserList, String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, String deptFlag) {
        boolean isDiff = true;
        String description = "";
        JSONObject retMsg = new JSONObject();
        if (StringUtils.isNotEmpty((String)mobile)) {
            if (StringUtils.isNotEmpty((String)userId)) {
                if (qyUserList.stream().filter(t -> String.valueOf(t.getMobile()).equals(mobile) && !t.getUserid().equals(userId)).count() > 0L) {
                    isDiff = false;
                    description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u624b\u673a\u53f7:" + mobile;
                }
            } else if (qyUserList.stream().filter(t -> String.valueOf(t.getMobile()).equals(mobile)).count() > 0L) {
                isDiff = false;
                description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u624b\u673a\u53f7:" + mobile;
            }
        }
        if (StringUtils.isNotEmpty((String)email)) {
            if (StringUtils.isNotEmpty((String)userId)) {
                if (qyUserList.stream().filter(t -> String.valueOf(t.getEmail()).equals(email) && !t.getUserid().equals(userId)).count() > 0L) {
                    isDiff = false;
                    description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u6b64\u90ae\u7bb1:" + email;
                }
            } else if (qyUserList.stream().filter(t -> String.valueOf(t.getEmail()).equals(email)).count() > 0L) {
                isDiff = false;
                description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u6b64\u90ae\u7bb1:" + email;
            }
        }
        retMsg.put("code", (Object)isDiff);
        retMsg.put("error", (Object)description);
        if (!isDiff) {
            Integer synState = SynThirdConsts.SYN_STATE_FAIL;
            this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, thirdType, dataType, sysObjId, thirdObjId, synState, description);
        }
        return retMsg;
    }

    public JSONObject checkUserSysToQy(SynThirdInfoEntity synThirdInfoEntity) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            if ("".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) || "null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u7528\u6237\u5bf9\u5e94\u7684\u7b2c\u4e09\u65b9ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u7528\u6237\u672a\u540c\u6b65!");
        }
        return retMsg;
    }

    @Override
    public JSONObject createUserSysToQy(boolean isBatch, UserEntity userEntity, String accessToken) throws WxErrorException {
        BaseSystemInfo config = this.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        int qyhIsSyn = isBatch ? 1 : config.getQyhIsSynUser();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        String userObjectModel = "";
        String thirdObjId = "";
        Integer synState = 0;
        String description = "";
        String userFlag = "\u521b\u5efa\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)(userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65"));
        if (StringUtils.isEmpty((String)userEntity.getMobilePhone()) && StringUtils.isEmpty((String)userEntity.getEmail()) && "1".equals(qyhIsSyn)) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)(userFlag + "\u4f01\u4e1a\u5fae\u4fe1\u4e0d\u5141\u8bb8\u624b\u673a\u53f7\u3001\u90ae\u7bb1\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01"));
        }
        if (qyhIsSyn == 1) {
            if (retMsg.getBoolean("code").booleanValue()) {
                if (isBatch) {
                    access_token = accessToken;
                } else {
                    tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
                    access_token = tokenObject.getString("access_token");
                }
                if (access_token != null && !"".equals(access_token)) {
                    retMsg = this.setQyUserObject(userEntity, null);
                    if (retMsg.getBoolean("code").booleanValue()) {
                        userObjectModel = retMsg.getString("qyUserObject");
                        if ((retMsg = SynQyWebChatUtil.createUser(userObjectModel, access_token)).getBoolean("code").booleanValue()) {
                            thirdObjId = userEntity.getId();
                            synState = SynThirdConsts.SYN_STATE_OK;
                        } else {
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = userFlag + retMsg.getString("error");
                        }
                    } else {
                        synState = SynThirdConsts.SYN_STATE_FAIL;
                        description = userFlag + retMsg.getString("error");
                    }
                } else {
                    synState = SynThirdConsts.SYN_STATE_FAIL;
                    description = userFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)description);
                }
            } else {
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = userFlag + retMsg.getString("error");
            }
        } else {
            synState = SynThirdConsts.SYN_STATE_NO;
            description = userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
            retMsg.put("code", (Object)true);
            retMsg.put("error", (Object)description);
        }
        this.saveSynThirdInfoEntity("add", null, Integer.parseInt("1"), Integer.parseInt("2"), userEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    @Override
    public JSONObject updateUserSysToQy(boolean isBatch, UserEntity userEntity, String accessToken) throws WxErrorException {
        BaseSystemInfo config = this.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        int qyhIsSyn = isBatch ? 1 : config.getQyhIsSynUser();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        String userObjectModel = "";
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        SynThirdInfoEntity entity = new SynThirdInfoEntity();
        String opType = "";
        SynThirdInfoEntity synThirdInfoPara = new SynThirdInfoEntity();
        String thirdObjId = "";
        Integer synState = 0;
        String description = "";
        String userFlag = "\u66f4\u65b0\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)(userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65"));
        if (StringUtils.isEmpty((String)userEntity.getMobilePhone()) && StringUtils.isEmpty((String)userEntity.getEmail()) && "1".equals(qyhIsSyn)) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)(userFlag + "\u4f01\u4e1a\u5fae\u4fe1\u4e0d\u5141\u8bb8\u624b\u673a\u53f7\u3001\u90ae\u7bb1\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01"));
        }
        if (qyhIsSyn == 1) {
            if (retMsg.getBoolean("code").booleanValue()) {
                if (isBatch) {
                    access_token = accessToken;
                } else {
                    tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
                    access_token = tokenObject.getString("access_token");
                }
                synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "2", userEntity.getId());
                if (access_token != null && !"".equals(access_token)) {
                    retMsg = this.setQyUserObject(userEntity, null);
                    if (retMsg.getBoolean("code").booleanValue()) {
                        userObjectModel = retMsg.getString("qyUserObject");
                        retMsg = this.checkUserSysToQy(synThirdInfoEntity);
                        if (!retMsg.getBoolean("code").booleanValue()) {
                            if ("3".equals(retMsg.getString("flag")) || "1".equals(retMsg.getString("flag"))) {
                                if ("1".equals(retMsg.getString("flag"))) {
                                    this.synThirdInfoService.delete(synThirdInfoEntity);
                                }
                                opType = "add";
                                synThirdInfoPara = null;
                                thirdObjId = "";
                                retMsg = SynQyWebChatUtil.createUser(userObjectModel, access_token);
                                if (retMsg.getBoolean("code").booleanValue()) {
                                    thirdObjId = userEntity.getId();
                                    synState = SynThirdConsts.SYN_STATE_OK;
                                    description = "";
                                } else {
                                    synState = SynThirdConsts.SYN_STATE_FAIL;
                                    description = userFlag + retMsg.getString("error");
                                }
                            }
                            if ("2".equals(retMsg.getString("flag"))) {
                                opType = "upd";
                                synThirdInfoPara = synThirdInfoEntity;
                                thirdObjId = "";
                                retMsg = SynQyWebChatUtil.createUser(userObjectModel, access_token);
                                if (retMsg.getBoolean("code").booleanValue()) {
                                    thirdObjId = userEntity.getId();
                                    synState = SynThirdConsts.SYN_STATE_OK;
                                    description = "";
                                } else {
                                    synState = SynThirdConsts.SYN_STATE_FAIL;
                                    description = userFlag + retMsg.getString("error");
                                }
                            }
                        } else {
                            opType = "upd";
                            synThirdInfoPara = synThirdInfoEntity;
                            thirdObjId = synThirdInfoEntity.getThirdObjectId();
                            QyWebChatUserModel qyWebChatUserModel = this.getQyUserById(synThirdInfoEntity.getThirdObjectId(), access_token);
                            if ("0".equals(qyWebChatUserModel.getErrcode())) {
                                retMsg = this.setQyUserObject(userEntity, qyWebChatUserModel);
                                userObjectModel = retMsg.getString("qyUserObject");
                                if ((retMsg = SynQyWebChatUtil.updateUser(userObjectModel, access_token)).getBoolean("code").booleanValue()) {
                                    synState = SynThirdConsts.SYN_STATE_OK;
                                    description = "";
                                } else {
                                    synState = SynThirdConsts.SYN_STATE_FAIL;
                                    description = userFlag + retMsg.getString("error");
                                }
                            } else {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = userFlag + "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25";
                            }
                        }
                    } else {
                        if (synThirdInfoEntity != null) {
                            opType = "upd";
                            synThirdInfoPara = synThirdInfoEntity;
                            thirdObjId = synThirdInfoEntity.getThirdObjectId();
                        } else {
                            opType = "add";
                            synThirdInfoPara = null;
                            thirdObjId = "";
                        }
                        synState = SynThirdConsts.SYN_STATE_FAIL;
                        description = userFlag + retMsg.getString("error");
                        retMsg.put("code", (Object)false);
                        retMsg.put("error", (Object)description);
                    }
                } else {
                    if (synThirdInfoEntity != null) {
                        opType = "upd";
                        synThirdInfoPara = synThirdInfoEntity;
                        thirdObjId = synThirdInfoEntity.getThirdObjectId();
                    } else {
                        opType = "add";
                        synThirdInfoPara = null;
                        thirdObjId = "";
                    }
                    synState = SynThirdConsts.SYN_STATE_FAIL;
                    description = userFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
                    retMsg.put("code", (Object)true);
                    retMsg.put("error", (Object)description);
                }
            } else {
                synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "2", userEntity.getId());
                if (synThirdInfoEntity != null) {
                    opType = "upd";
                    synThirdInfoPara = synThirdInfoEntity;
                    thirdObjId = synThirdInfoEntity.getThirdObjectId();
                } else {
                    opType = "add";
                    synThirdInfoPara = null;
                    thirdObjId = "";
                }
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = userFlag + retMsg.getString("error");
                retMsg.put("code", (Object)false);
                retMsg.put("error", (Object)description);
            }
        } else {
            synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "2", userEntity.getId());
            if (synThirdInfoEntity != null) {
                opType = "upd";
                synThirdInfoPara = synThirdInfoEntity;
                thirdObjId = synThirdInfoEntity.getThirdObjectId();
            } else {
                opType = "add";
                synThirdInfoPara = null;
                thirdObjId = "";
            }
            synState = SynThirdConsts.SYN_STATE_NO;
            description = userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
            retMsg.put("code", (Object)true);
            retMsg.put("error", (Object)description);
        }
        this.saveSynThirdInfoEntity(opType, synThirdInfoPara, Integer.parseInt("1"), Integer.parseInt("2"), userEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    @Override
    public JSONObject deleteUserSysToQy(boolean isBatch, String id, String accessToken) throws WxErrorException {
        BaseSystemInfo config = this.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        int qyhIsSyn = isBatch ? 1 : config.getQyhIsSynUser();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "2", id);
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (synThirdInfoEntity != null) {
            if (qyhIsSyn == 1) {
                if (isBatch) {
                    access_token = accessToken;
                } else {
                    tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
                    access_token = tokenObject.getString("access_token");
                }
                if (access_token != null && !"".equals(access_token)) {
                    if (!"".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) && !"null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                        retMsg = SynQyWebChatUtil.deleteUser(synThirdInfoEntity.getThirdObjectId(), access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            this.synThirdInfoService.delete(synThirdInfoEntity);
                        } else {
                            this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("1"), Integer.parseInt("2"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, retMsg.getString("error"));
                        }
                    } else {
                        this.synThirdInfoService.delete(synThirdInfoEntity);
                    }
                } else {
                    this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("1"), Integer.parseInt("2"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f");
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)"access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f\uff01");
                }
            } else {
                this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("1"), Integer.parseInt("2"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_NO, "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u540c\u6b65");
                retMsg.put("code", (Object)true);
                retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
            }
        }
        return retMsg;
    }

    @Override
    public void createOrgan(OrganizeEntity entity) {
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        String organizeIdTree = StringUtils.isNotEmpty((String)entity.getOrganizeIdTree()) ? entity.getOrganizeIdTree() + "," : "";
        entity.setOrganizeIdTree(organizeIdTree + entity.getId());
        this.save(entity);
    }

    public void setOrganizedTree() {
        List<OrganizeEntity> listOrgan = this.organizeService.getList();
        List collectCompany = listOrgan.stream().filter(i -> "company".equals(i.getCategory())).map(v -> v.getId()).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(listOrgan)) {
            for (OrganizeEntity item : listOrgan) {
                String organizeIdTree = this.organizeService.getOrganizeIdTreeALL(item);
                List<String> listTree = Arrays.asList(organizeIdTree.split(","));
                List collectOrg = listTree.stream().filter(collectCompany::contains).collect(Collectors.toList());
                String organizeId = "0";
                if (!ObjectUtil.isEmpty(collectOrg)) {
                    organizeId = (String)collectOrg.get(collectOrg.size() - 1);
                }
                item.setOrganizeIdTree(organizeIdTree);
                item.setOrganizeId(organizeId);
            }
            this.organizeService.updateBatchById(listOrgan);
        }
    }

    public void setOrganizeCode() {
        List<OrganizeEntity> orgListCodeNull = this.organizeService.getOrgListCodeNull();
        if (ObjectUtil.isNotEmpty(orgListCodeNull)) {
            orgListCodeNull.stream().forEach(item -> this.setCode((OrganizeEntity)item));
        }
    }

    public void setCode(OrganizeEntity entity) {
        OrganizeEntity parentEntity = this.organizeService.getInfo(entity.getParentId());
        if (ObjectUtil.isNotEmpty((Object)parentEntity.getEnCode())) {
            List<OrganizeEntity> parentIdList = this.organizeService.getParentIdListAsc(entity.getParentId());
            if (ObjectUtil.isNotEmpty(parentIdList) && ObjectUtil.isNotEmpty((Object)parentIdList.get(0).getEnCode())) {
                String enCode1 = parentIdList.get(0).getEnCode();
                String ul = enCode1.replaceAll("[a-zA-Z]", "");
                int utellength = ul.length();
                String u = "";
                for (int i = 0; i < utellength; ++i) {
                    u = u + "0";
                }
                BigInteger utel = new BigInteger(ul);
                BigInteger untel = new BigInteger(String.valueOf("1"));
                utel = utel.add(untel);
                DecimalFormat nf = new DecimalFormat(u);
                String str = nf.format(utel);
                String enCode = parentEntity.getEnCode();
                entity.setEnCode(enCode.charAt(0) + str);
            } else {
                entity.setEnCode(parentEntity.getEnCode() + "01");
            }
        } else {
            this.setCode(parentEntity);
        }
        this.organizeService.updateById(entity);
    }
}

