/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.system.base.exception.WxErrorException;
import com.bringspring.system.message.model.message.OraganizeListVO;
import com.bringspring.system.permission.entity.OrganizeEntity;
import java.util.HashMap;
import java.util.List;

public class SynQyWebChatUtil {
    public static final String TOKEN = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s";
    public static final String CREATE_DEPARTMENT = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=%s";
    public static final String UPDATE_DEPARTMENT = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=%s";
    public static final String DELETE_DEPARTMENT = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=%s&id=%s";
    public static final String GET_DEPARTMENT_LIST = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=%s&id=%s";
    public static final String GET_DEPARTMENT_GET = "https://qyapi.weixin.qq.com/cgi-bin/department/get?access_token=%s&id=%s";
    public static final String CREATE_USER = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=%s";
    public static final String UPDATE_USER = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=%s";
    public static final String DELETE_USER = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=%s&userid=%s";
    public static final String GET_USER_LIST = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=%s&department_id=%s&fetch_child=%s";
    public static final String GET_USER_DETAIL_LIST = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=%s&department_id=%s&fetch_child=%s";
    public static final String GET_SINGLE_USER = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=%s&userid=%s";
    public static final String MEDIA_UPLOAD = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?access_token=%s&type=%s";
    public static final String SEND_MESSAGE = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=%s";
    public static final String GET_LINKEDCORP_AGENT = "https://qyapi.weixin.qq.com/cgi-bin/linkedcorp/agent/get_perm_list?access_token=%s";
    public static final String GET_LINKEDCORPDEPARTMENT_LIST = "https://qyapi.weixin.qq.com/cgi-bin/linkedcorp/department/list?access_token=%s";
    public static final String GET_LINKEDCORPDEPUSER_LIST = "https://qyapi.weixin.qq.com/cgi-bin/linkedcorp/user/list?access_token=%s";
    public static final String GET_LINKEDCORP_USER_INFO = "https://qyapi.weixin.qq.com/cgi-bin/linkedcorp/user/get?access_token=%s";
    public static final String GET_CODE_ID = "https://open.work.weixin.qq.com/wwopen/sso/qrConnect?appid=%s&agentid=%s&redirect_uri=%s&state=STATE";
    public static final String GET_USER_ID = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=%s&code=%s";

    public static JSONObject getAccessToken(String corpId, String corpSecret) {
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(TOKEN, corpId, corpSecret), (String)"GET", null);
        rstObj.put("code", (Object)true);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            rstObj.put("code", (Object)false);
            rstObj.put("access_token", (Object)"");
        }
        return rstObj;
    }

    public static JSONObject sendMessage(String message, String accessToken) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(SEND_MESSAGE, accessToken), (String)"POST", (String)message);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject sendWxMessage(String corpId, String corpSecret, String agentId, String toUserId, String contents) {
        JSONObject retMsg = null;
        JSONObject message = null;
        JSONObject tokenObject = null;
        JSONObject content = null;
        message = new JSONObject();
        message.put("touser", (Object)toUserId);
        message.put("agentid", (Object)agentId);
        content = new JSONObject();
        content.put("content", (Object)contents);
        message.put("text", (Object)content);
        message.put("msgtype", (Object)"text");
        tokenObject = SynQyWebChatUtil.getAccessToken(corpId, corpSecret);
        if (tokenObject.getString("access_token") != null && !"".equals(tokenObject.getString("access_token"))) {
            retMsg = SynQyWebChatUtil.sendMessage(message.toJSONString(), tokenObject.getString("access_token"));
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u53d1\u9001\u4fe1\u606f\uff01");
        }
        return retMsg;
    }

    public static JSONObject createDepartment(String department, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String qyDeptId = "0";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(CREATE_DEPARTMENT, accessToken), (String)"POST", (String)department);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            codeFlag = true;
            qyDeptId = rstObj.getInteger("id").toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("retDeptId", (Object)qyDeptId);
        return retMsg;
    }

    public static JSONObject updateDepartment(String department, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(UPDATE_DEPARTMENT, accessToken), (String)"POST", (String)department);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject deleteDepartment(String id, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(DELETE_DEPARTMENT, accessToken, id), (String)"GET", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject getDepartmentList(String id, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String departmentStr = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_DEPARTMENT_LIST, accessToken, id), (String)"GET", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            departmentStr = rstObj.getString("department");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("department", (Object)departmentStr);
        return retMsg;
    }

    public static JSONObject getDepartmentDetail(String id, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String departmentStr = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_DEPARTMENT_GET, accessToken, id), (String)"GET", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            departmentStr = rstObj.getString("department");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("department", (Object)departmentStr);
        return retMsg;
    }

    public static JSONObject createUser(String user, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(CREATE_USER, accessToken), (String)"POST", (String)user);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject updateUser(String user, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(UPDATE_USER, accessToken), (String)"POST", (String)user);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject deleteUser(String id, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(DELETE_USER, accessToken, id), (String)"GET", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject getUserById(String id, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String userInfo = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_SINGLE_USER, accessToken, id), (String)"GET", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            userInfo = rstObj.toJSONString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("userinfo", (Object)userInfo);
        return retMsg;
    }

    public static JSONObject getUserList(String id, String isGetChild, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String userList = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_USER_LIST, accessToken, id, isGetChild), (String)"GET", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            userList = rstObj.getString("userlist");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("userlist", (Object)userList);
        return retMsg;
    }

    public static JSONObject getUserDetailList(String id, String isGetChild, String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String userList = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_USER_DETAIL_LIST, accessToken, id, isGetChild), (String)"GET", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            userList = rstObj.getString("userlist");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("userlist", (Object)userList);
        return retMsg;
    }

    public static JSONObject getLinkedcorpAgent(String accessToken) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String department = "";
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_LINKEDCORP_AGENT, accessToken), (String)"POST", null);
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            department = rstObj.getString("department_ids");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("department_ids", (Object)department);
        return retMsg;
    }

    public static JSONObject getLinkedcorpDepartment(String accessToken, String departmentId) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String departmentList = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("department_id", departmentId);
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_LINKEDCORPDEPARTMENT_LIST, accessToken), (String)"POST", (String)JsonUtil.getObjectToString(map));
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            departmentList = rstObj.getString("department_list");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("departmentList", (Object)departmentList);
        return retMsg;
    }

    public static JSONObject getLinkedcorpUser(String accessToken, String departmentId) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String userlist = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("department_id", departmentId);
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_LINKEDCORPDEPUSER_LIST, accessToken), (String)"POST", (String)JsonUtil.getObjectToString(map));
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            userlist = rstObj.getString("userlist");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("userlist", (Object)userlist);
        return retMsg;
    }

    public static JSONObject getUserId(String accessToken, String code) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String userid = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_USER_ID, accessToken, code), (String)"POST", (String)JsonUtil.getObjectToString(map));
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            userid = rstObj.getString("userid");
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("userid", (Object)userid);
        return retMsg;
    }

    public static JSONObject getLinkedcorpUserInfoById(String accessToken, String linkedcorpUserId) throws WxErrorException {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String userid = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userid", linkedcorpUserId);
        JSONObject rstObj = HttpUtil.httpRequest((String)String.format(GET_LINKEDCORP_USER_INFO, accessToken), (String)"POST", (String)JsonUtil.getObjectToString(map));
        if (HttpUtil.isWxError((JSONObject)rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        } else {
            JSONObject userInfo = rstObj.getJSONObject("user_info");
            retMsg.put("userinfo", (Object)userInfo);
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static void getOrganizeTreeToList(OraganizeListVO selectorVO, List<OrganizeEntity> organizeList, List<OrganizeEntity> listByOrder) {
        if (selectorVO.isHasChildren()) {
            List<OraganizeListVO> voChildren = selectorVO.getChildren();
            for (OraganizeListVO organizeSelectorVO : voChildren) {
                OrganizeEntity entity = organizeList.stream().filter(t -> t.getId().equals(organizeSelectorVO.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                if (!organizeSelectorVO.isHasChildren()) continue;
                SynQyWebChatUtil.getOrganizeTreeToList(organizeSelectorVO, organizeList, listByOrder);
            }
        }
    }
}

