/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.msgCenter.entity.McMessageEntity;
import com.bringspring.system.msgCenter.entity.McMessageTemplateEntity;
import com.bringspring.system.msgCenter.model.mcMessage.McMessageCrForm;
import com.bringspring.system.msgCenter.model.mcMessage.McMessageInfoVO;
import com.bringspring.system.msgCenter.model.mcMessage.McMessageListVO;
import com.bringspring.system.msgCenter.model.mcMessage.McMessagePagination;
import com.bringspring.system.msgCenter.model.mcMessage.McMessagePaginationExportModel;
import com.bringspring.system.msgCenter.model.mcMessage.McMessageUpForm;
import com.bringspring.system.msgCenter.service.McMessageService;
import com.bringspring.system.msgCenter.service.McMessageTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d88\u606f\u5185\u5bb9\u8868"}, value="McMessageController")
@RequestMapping(value={"/api/msgCenter/mcMessage"})
public class McMessageController {
    private static final Logger log = LoggerFactory.getLogger(McMessageController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMessageService mcMessageService;
    @Autowired
    private McMessageTemplateService mcMessageTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McMessagePagination mcMessagePagination) throws IOException {
        List<McMessageEntity> list = this.mcMessageService.getList(mcMessagePagination);
        for (McMessageEntity object2 : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, McMessageListVO.class);
        Iterator iterator = listVO.iterator();
        while (iterator.hasNext()) {
            McMessageListVO mcMessageVO;
            mcMessageVO.setCreatorTimeFormat(ObjectUtil.isNull((Object)(mcMessageVO = (McMessageListVO)iterator.next()).getCreatorTime()) ? null : DateUtil.dateFormat((Date)mcMessageVO.getCreatorTime()));
            mcMessageVO.setLastModifyTimeFormat(ObjectUtil.isNull((Object)mcMessageVO.getLastModifyTime()) ? null : DateUtil.dateFormat((Date)mcMessageVO.getLastModifyTime()));
            mcMessageVO.setCreatorUser(this.baseDataUtil.userSelectValueNoAccount(mcMessageVO.getCreatorUserId()));
            mcMessageVO.setLastModifyUser(this.baseDataUtil.userSelectValueNoAccount(mcMessageVO.getLastModifyUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcMessagePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid McMessageCrForm mcMessageCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        McMessageEntity entity = (McMessageEntity)JsonUtil.getJsonToBean((Object)mcMessageCrForm, McMessageEntity.class);
        entity.setId(mainId);
        this.mcMessageService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(McMessagePaginationExportModel mcMessagePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)mcMessagePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        McMessagePagination mcMessagePagination = (McMessagePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)mcMessagePaginationExportModel), McMessagePagination.class));
        List<McMessageEntity> list = this.mcMessageService.getTypeList(mcMessagePagination, mcMessagePaginationExportModel.getDataType());
        for (McMessageEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, McMessageListVO.class);
        for (McMessageListVO mcMessageListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)mcMessagePaginationExportModel.getSelectKey()) ? mcMessagePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block46: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "taskCode": {
                        entitys.add(new ExcelExportEntity("\u4e1a\u52a1\u7cfb\u7edf", (Object)"taskCode"));
                        continue block46;
                    }
                    case "msgType": {
                        entitys.add(new ExcelExportEntity("\u6d88\u606f\u7c7b\u578b", (Object)"msgType"));
                        continue block46;
                    }
                    case "templateCode": {
                        entitys.add(new ExcelExportEntity("\u6d88\u606f\u6a21\u677f", (Object)"templateCode"));
                        continue block46;
                    }
                    case "parameterMap": {
                        entitys.add(new ExcelExportEntity("\u6a21\u677f\u53c2\u6570", (Object)"parameterMap"));
                        continue block46;
                    }
                    case "customMap": {
                        entitys.add(new ExcelExportEntity("\u5b9a\u5236\u53c2\u6570", (Object)"customMap"));
                        continue block46;
                    }
                    case "toUserIds": {
                        entitys.add(new ExcelExportEntity("\u63a5\u6536\u8005", (Object)"toUserIds"));
                        continue block46;
                    }
                    case "toDeptIds": {
                        entitys.add(new ExcelExportEntity("\u63a5\u6536\u8005\u7684\u90e8\u95e8", (Object)"toDeptIds"));
                        continue block46;
                    }
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u6807\u9898", (Object)"title"));
                        continue block46;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u6458\u8981\u63cf\u8ff0", (Object)"description"));
                        continue block46;
                    }
                    case "content": {
                        entitys.add(new ExcelExportEntity("\u6b63\u6587", (Object)"content"));
                        continue block46;
                    }
                    case "detailUrl": {
                        entitys.add(new ExcelExportEntity("\u8be6\u60c5\u94fe\u63a5", (Object)"detailUrl"));
                        continue block46;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6d88\u606f\u72b6\u6001", (Object)"enabledMark"));
                        continue block46;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u4eba", (Object)"creatorUserId"));
                        continue block46;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block46;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u4eba", (Object)"lastModifyUserId"));
                        continue block46;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block46;
                    }
                    case "remark": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8\u63cf\u8ff0", (Object)"remark"));
                        continue block46;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McMessageInfoVO> info(@PathVariable(value="id") String id) {
        McMessageInfoVO vo;
        McMessageEntity entity = this.mcMessageService.getInfo(id);
        McMessageTemplateEntity info = this.mcMessageTemplateService.getInfoByEnCode((vo = (McMessageInfoVO)JsonUtil.getJsonToBean((Object)entity, McMessageInfoVO.class)).getTemplateCode());
        vo.setTemplateName(info != null ? info.getFullName() : null);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McMessageInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McMessageInfoVO vo;
        McMessageEntity entity = this.mcMessageService.getInfo(id);
        vo.setCreatorTimeFormat(ObjectUtil.isNull((Object)(vo = (McMessageInfoVO)JsonUtil.getJsonToBean((Object)entity, McMessageInfoVO.class)).getCreatorTime()) ? null : DateUtil.dateFormat((Date)vo.getCreatorTime()));
        vo.setLastModifyTimeFormat(ObjectUtil.isNull((Object)vo.getLastModifyTime()) ? null : DateUtil.dateFormat((Date)vo.getLastModifyTime()));
        vo.setCreatorUser(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setLastModifyUser(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McMessageUpForm mcMessageUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        McMessageEntity entity = this.mcMessageService.getInfo(id);
        if (entity != null) {
            McMessageEntity subentity = (McMessageEntity)JsonUtil.getJsonToBean((Object)mcMessageUpForm, McMessageEntity.class);
            this.mcMessageService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        McMessageEntity entity = this.mcMessageService.getInfo(id);
        if (entity != null) {
            this.mcMessageService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/send/{id}"})
    public ActionResult send(@PathVariable(value="id") String id) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        McMessageEntity entity = this.mcMessageService.getInfo(id);
        if (entity != null) {
            try {
                boolean sendRes = this.mcMessageService.sendMessage(entity);
                return ActionResult.success((String)"\u53d1\u9001\u6210\u529f");
            }
            catch (WxErrorException e) {
                e.printStackTrace();
                String message = "\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage();
                log.error(message);
                return ActionResult.fail((String)message);
            }
        }
        return ActionResult.fail((String)"\u53d1\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

