/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMessageReceiveEntity;
import com.bringspring.system.msgCenter.model.mcMessageReceive.McMessageReceiveCrForm;
import com.bringspring.system.msgCenter.model.mcMessageReceive.McMessageReceiveInfoVO;
import com.bringspring.system.msgCenter.model.mcMessageReceive.McMessageReceiveListVO;
import com.bringspring.system.msgCenter.model.mcMessageReceive.McMessageReceivePagination;
import com.bringspring.system.msgCenter.model.mcMessageReceive.McMessageReceiveUpForm;
import com.bringspring.system.msgCenter.service.McMessageReceiveService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d88\u606f\u63a5\u6536\u8bb0\u5f55\u8868"}, value="McMessageReceiveController")
@RequestMapping(value={"/api/msgCenter/mcMessageReceive"})
public class McMessageReceiveController {
    private static final Logger log = LoggerFactory.getLogger(McMessageReceiveController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMessageReceiveService mcMessageReceiveService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McMessageReceivePagination mcMessageReceivePagination) throws IOException {
        List<McMessageReceiveEntity> list = this.mcMessageReceiveService.getList(mcMessageReceivePagination);
        for (McMessageReceiveEntity mcMessageReceiveEntity : list) {
            mcMessageReceiveEntity.setSendUserId(this.baseDataUtil.userSelectValue(mcMessageReceiveEntity.getSendUserId()));
            mcMessageReceiveEntity.setAgainUserId(this.baseDataUtil.userSelectValue(mcMessageReceiveEntity.getAgainUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, McMessageReceiveListVO.class);
        for (McMessageReceiveListVO mcMessageReceiveListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcMessageReceivePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid McMessageReceiveCrForm mcMessageReceiveCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        mcMessageReceiveCrForm.setSendTime(DateUtil.getNow());
        mcMessageReceiveCrForm.setSendUserId(userInfo.getUserId());
        mcMessageReceiveCrForm.setReadTime(DateUtil.getNow());
        McMessageReceiveEntity entity = (McMessageReceiveEntity)JsonUtil.getJsonToBean((Object)mcMessageReceiveCrForm, McMessageReceiveEntity.class);
        entity.setId(mainId);
        this.mcMessageReceiveService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McMessageReceiveInfoVO> info(@PathVariable(value="id") String id) {
        McMessageReceiveEntity entity = this.mcMessageReceiveService.getInfo(id);
        McMessageReceiveInfoVO vo = (McMessageReceiveInfoVO)JsonUtil.getJsonToBean((Object)entity, McMessageReceiveInfoVO.class);
        if (vo.getSendTime() != null) {
            vo.setSendTime(vo.getSendTime());
        }
        vo.setSendUserId(this.baseDataUtil.userSelectValue(vo.getSendUserId()));
        if (vo.getAgainTime() != null) {
            vo.setAgainTime(vo.getAgainTime());
        }
        vo.setAgainUserId(this.baseDataUtil.userSelectValue(vo.getAgainUserId()));
        if (vo.getReadTime() != null) {
            vo.setReadTime(vo.getReadTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McMessageReceiveInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McMessageReceiveEntity entity = this.mcMessageReceiveService.getInfo(id);
        McMessageReceiveInfoVO vo = (McMessageReceiveInfoVO)JsonUtil.getJsonToBean((Object)entity, McMessageReceiveInfoVO.class);
        vo.setSendUserId(this.baseDataUtil.userSelectValue(vo.getSendUserId()));
        vo.setAgainUserId(this.baseDataUtil.userSelectValue(vo.getAgainUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McMessageReceiveUpForm mcMessageReceiveUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        McMessageReceiveEntity entity = this.mcMessageReceiveService.getInfo(id);
        if (entity != null) {
            mcMessageReceiveUpForm.setAgainTime(DateUtil.getNow());
            mcMessageReceiveUpForm.setAgainUserId(userInfo.getUserId());
            McMessageReceiveEntity subentity = (McMessageReceiveEntity)JsonUtil.getJsonToBean((Object)mcMessageReceiveUpForm, McMessageReceiveEntity.class);
            subentity.setSendTime(entity.getSendTime());
            subentity.setSendUserId(entity.getSendUserId());
            subentity.setReadTime(entity.getReadTime());
            this.mcMessageReceiveService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        McMessageReceiveEntity entity = this.mcMessageReceiveService.getInfo(id);
        if (entity != null) {
            this.mcMessageReceiveService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

