/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.msgCenter.entity.McMessageTemplateEntity;
import com.bringspring.system.msgCenter.entity.McSmsTemplateEntity;
import com.bringspring.system.msgCenter.model.SmsModel2;
import com.bringspring.system.msgCenter.model.mcMessageTemplate.McMessageTemplateCrForm;
import com.bringspring.system.msgCenter.model.mcMessageTemplate.McMessageTemplateListVO;
import com.bringspring.system.msgCenter.model.mcMessageTemplate.McMessageTemplatePagination;
import com.bringspring.system.msgCenter.model.mcMessageTemplate.McMessageTemplateSelector;
import com.bringspring.system.msgCenter.model.mcMessageTemplate.McMessageTemplateUpForm;
import com.bringspring.system.msgCenter.model.mcMessageTemplate.McMessageTemplateVO;
import com.bringspring.system.msgCenter.model.message.SentMessageForm;
import com.bringspring.system.msgCenter.service.McMessageTemplateService;
import com.bringspring.system.msgCenter.service.McSmsTemplateService;
import com.bringspring.system.msgCenter.util.SmsUtil2;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="McMessageTemplateController", tags={"\u6d88\u606f\u4e2d\u5fc3-\u6d88\u606f\u6a21\u677f\u63a7\u5236\u7c7b"})
@RestController
@RequestMapping(value={"/api/msgCenter/mcMessageTemplate"})
public class McMessageTemplateController {
    @Autowired
    private UserService userService;
    @Autowired
    private McMessageTemplateService mcMessageTemplateService;
    @Autowired
    private McSmsTemplateService mcSmsTemplateService;

    @ApiOperation(value="\u6d88\u606f\u6a21\u677f\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<McMessageTemplateListVO>> list(McMessageTemplatePagination pagination) {
        List<McMessageTemplateEntity> list = this.mcMessageTemplateService.getList(pagination);
        List listVO = JsonUtil.getJsonToList(list, McMessageTemplateListVO.class);
        for (McMessageTemplateListVO mesTempListVO : listVO) {
            StringBuffer noticeMethod = new StringBuffer();
            if (mesTempListVO.getIsDingTalk() == 1) {
                noticeMethod.append("\u3001\u963f\u91cc\u9489\u9489");
            }
            if (mesTempListVO.getIsEmail() == 1) {
                noticeMethod.append("\u3001\u7535\u5b50\u90ae\u7bb1");
            }
            if (mesTempListVO.getIsSms() == 1) {
                noticeMethod.append("\u3001\u77ed\u4fe1");
            }
            if (mesTempListVO.getIsStationLetter() == 1) {
                noticeMethod.append("\u3001\u7ad9\u5185\u4fe1");
            }
            if (mesTempListVO.getIsWecom() == 1) {
                noticeMethod.append("\u3001\u4f01\u4e1a\u5fae\u4fe1");
            }
            if (noticeMethod.length() > 0) {
                mesTempListVO.setNoticeMethod(noticeMethod.toString().replaceFirst("\u3001", ""));
            }
            if ("1".equals(mesTempListVO.getCategory())) {
                mesTempListVO.setCategory("\u666e\u901a");
            } else if ("2".equals(mesTempListVO.getCategory())) {
                mesTempListVO.setCategory("\u91cd\u8981");
            } else if ("3".equals(mesTempListVO.getCategory())) {
                mesTempListVO.setCategory("\u7d27\u6025");
            }
            UserEntity entity = this.userService.getInfo(mesTempListVO.getCreatorUserId());
            mesTempListVO.setCreatorUserId(entity != null ? entity.getRealName() : null);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6d88\u606f\u6a21\u677f\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<PageListVO<McMessageTemplateSelector>> selector(McMessageTemplatePagination pagination) {
        List<McMessageTemplateEntity> list = this.mcMessageTemplateService.getList(pagination);
        List listSelector = JsonUtil.getJsonToList(list, McMessageTemplateSelector.class);
        for (McMessageTemplateSelector selector : listSelector) {
            if ("1".equals(selector.getCategory())) {
                selector.setCategory("\u666e\u901a");
                continue;
            }
            if ("2".equals(selector.getCategory())) {
                selector.setCategory("\u91cd\u8981");
                continue;
            }
            if (!"3".equals(selector.getCategory())) continue;
            selector.setCategory("\u7d27\u6025");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listSelector, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d88\u606f\u6a21\u677f")
    @GetMapping(value={"/{id}"})
    public ActionResult<McMessageTemplateVO> info(@PathVariable(value="id") String id) {
        McMessageTemplateVO vo;
        McMessageTemplateEntity entity = this.mcMessageTemplateService.getInfo(id);
        McSmsTemplateEntity info = this.mcSmsTemplateService.getInfo((vo = (McMessageTemplateVO)JsonUtil.getJsonToBean((Object)entity, McMessageTemplateVO.class)).getSmsId());
        vo.setSmsTemplateName(info != null ? info.getFullName() : null);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d88\u606f\u6a21\u677f\u53c2\u6570")
    @GetMapping(value={"/getTemplate/{id}"})
    public ActionResult<?> getParameter(@PathVariable(value="id") String id) {
        McMessageTemplateEntity entity = this.mcMessageTemplateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)"\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        String templateJson = entity.getTemplateJson();
        Map map = JsonUtil.stringToMap((String)templateJson);
        if (entity.getIsSms() == 1) {
            SmsModel2 smsModel = this.mcSmsTemplateService.getSmsConfig();
            String smsId = entity.getSmsId();
            McSmsTemplateEntity info = this.mcSmsTemplateService.getInfo(smsId);
            List<String> list = SmsUtil2.querySmsTemplateRequest(info.getCompany(), smsModel, info.getEndpoint(), info.getRegion(), info.getTemplateId());
            for (String key : list) {
                map.put(key, null);
            }
        }
        return ActionResult.success((Object)map);
    }

    @ApiOperation(value="\u65b0\u5efa")
    @PostMapping
    public ActionResult<String> create(@RequestBody @Valid McMessageTemplateCrForm mcMessageTemplateCrForm) {
        McMessageTemplateEntity entity = (McMessageTemplateEntity)JsonUtil.getJsonToBean((Object)mcMessageTemplateCrForm, McMessageTemplateEntity.class);
        if (this.mcMessageTemplateService.isExistByFullName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.mcMessageTemplateService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.mcMessageTemplateService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/{id}"})
    public ActionResult<String> update(@PathVariable(value="id") String id, @RequestBody @Valid McMessageTemplateUpForm mcMessageTemplateUpForm) {
        McMessageTemplateEntity entity = (McMessageTemplateEntity)JsonUtil.getJsonToBean((Object)mcMessageTemplateUpForm, McMessageTemplateEntity.class);
        if (entity != null) {
            if (this.mcMessageTemplateService.isExistByFullName(entity.getFullName(), id)) {
                return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
            if (this.mcMessageTemplateService.isExistByEnCode(entity.getEnCode(), id)) {
                return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
            boolean flag = this.mcMessageTemplateService.update(id, entity);
            if (!flag) {
                return ActionResult.fail((String)MsgCode.FA002.get());
            }
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult<String> delete(@PathVariable(value="id") String id) {
        McMessageTemplateEntity entity = this.mcMessageTemplateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        this.mcMessageTemplateService.delete(entity);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult<String> update(@PathVariable(value="id") String id) {
        McMessageTemplateEntity entity = this.mcMessageTemplateService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == 0) {
                entity.setEnabledMark(1);
            } else {
                entity.setEnabledMark(0);
            }
            boolean flag = this.mcMessageTemplateService.update(id, entity);
            if (!flag) {
                return ActionResult.fail((String)MsgCode.FA002.get());
            }
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.success((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u6d4b\u8bd5\u53d1\u9001\u6d88\u606f")
    @PostMapping(value={"/testSendMessage"})
    public ActionResult<String> sendMessage(@RequestBody @Valid SentMessageForm sentMessageForm) throws Exception {
        if (ObjectUtil.isEmpty((Object)sentMessageForm)) {
            return ActionResult.fail((String)"\u6d4b\u8bd5\u53d1\u9001\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01");
        }
        if (CollectionUtil.isEmpty(sentMessageForm.getToUserIds())) {
            return ActionResult.fail((String)"\u6d4b\u8bd5\u53d1\u9001\u5931\u8d25\uff0c\u63a5\u6536\u4eba\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        this.mcMessageTemplateService.testSendMessage(sentMessageForm);
        return ActionResult.success((String)MsgCode.SU012.get());
    }

    @GetMapping(value={"/getMessageTemplateByEncode/{enCode}"})
    public ActionResult getMessageTemplateByEncode(@PathVariable(value="enCode") String enCode) throws BaseException {
        McMessageTemplateEntity messageTemplateByEncode = this.mcMessageTemplateService.getMessageTemplateByEncode(enCode);
        return ActionResult.success((Object)messageTemplateByEncode);
    }
}

