/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.msgCenter.entity.McSmsTemplateEntity;
import com.bringspring.system.msgCenter.model.SmsModel2;
import com.bringspring.system.msgCenter.model.mcSmsTemplate.McSmsTemplateCrForm;
import com.bringspring.system.msgCenter.model.mcSmsTemplate.McSmsTemplateListVO;
import com.bringspring.system.msgCenter.model.mcSmsTemplate.McSmsTemplateSelector;
import com.bringspring.system.msgCenter.model.mcSmsTemplate.McSmsTemplateUpForm;
import com.bringspring.system.msgCenter.model.mcSmsTemplate.McSmsTemplateVO;
import com.bringspring.system.msgCenter.service.McSmsTemplateService;
import com.bringspring.system.msgCenter.util.SmsUtil2;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="McSmsTemplateController", tags={"\u6d88\u606f\u4e2d\u5fc3-\u77ed\u4fe1\u6a21\u677f\u63a7\u5236\u7c7b"})
@RestController
@RequestMapping(value={"/api/msgCenter/mcSmsTemplate"})
public class McSmsTemplateController {
    @Autowired
    private McSmsTemplateService mcSmsTemplateService;

    @ApiOperation(value="\u77ed\u4fe1\u6a21\u677f\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<McSmsTemplateListVO>> list(Pagination pagination) {
        List<McSmsTemplateEntity> list = this.mcSmsTemplateService.getList(pagination);
        List listVO = JsonUtil.getJsonToList(list, McSmsTemplateListVO.class);
        for (McSmsTemplateListVO mcSmsTemplateListVO : listVO) {
            if ("1".equals(mcSmsTemplateListVO.getCompany())) {
                mcSmsTemplateListVO.setCompany("\u963f\u91cc");
                continue;
            }
            if (!"2".equals(mcSmsTemplateListVO.getCompany())) continue;
            mcSmsTemplateListVO.setCompany("\u817e\u8baf");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u77ed\u4fe1\u6a21\u677f\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<McSmsTemplateSelector>> selector() {
        List<McSmsTemplateEntity> list = this.mcSmsTemplateService.getList();
        List jsonToList = JsonUtil.getJsonToList(list, McSmsTemplateSelector.class);
        for (McSmsTemplateSelector mcSmsTemplateSelector : jsonToList) {
            if ("1".equals(mcSmsTemplateSelector.getCompany())) {
                mcSmsTemplateSelector.setCompany("\u963f\u91cc");
                continue;
            }
            if (!"2".equals(mcSmsTemplateSelector.getCompany())) continue;
            mcSmsTemplateSelector.setCompany("\u817e\u8baf");
        }
        ListVO listVO = new ListVO();
        listVO.setList(jsonToList);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u77ed\u4fe1\u6a21\u677f")
    @GetMapping(value={"/{id}"})
    public ActionResult<McSmsTemplateVO> info(@PathVariable(value="id") String id) {
        McSmsTemplateEntity entity = this.mcSmsTemplateService.getInfo(id);
        McSmsTemplateVO vo = (McSmsTemplateVO)JsonUtil.getJsonToBean((Object)entity, McSmsTemplateVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa")
    @PostMapping
    public ActionResult<String> create(@RequestBody @Valid McSmsTemplateCrForm mcSmsTemplateCrForm) {
        McSmsTemplateEntity entity = (McSmsTemplateEntity)JsonUtil.getJsonToBean((Object)mcSmsTemplateCrForm, McSmsTemplateEntity.class);
        if (this.mcSmsTemplateService.isExistByTemplateName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.mcSmsTemplateService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.mcSmsTemplateService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/{id}"})
    public ActionResult<String> update(@PathVariable(value="id") String id, @RequestBody @Valid McSmsTemplateUpForm smsTemplateUpForm2) {
        McSmsTemplateEntity entity = (McSmsTemplateEntity)JsonUtil.getJsonToBean((Object)smsTemplateUpForm2, McSmsTemplateEntity.class);
        if (this.mcSmsTemplateService.isExistByTemplateName(entity.getFullName(), id)) {
            return ActionResult.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.mcSmsTemplateService.isExistByEnCode(entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.mcSmsTemplateService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult<String> delete(@PathVariable(value="id") String id) {
        McSmsTemplateEntity entity = this.mcSmsTemplateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        this.mcSmsTemplateService.delete(entity);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult<String> update(@PathVariable(value="id") String id) {
        McSmsTemplateEntity entity = this.mcSmsTemplateService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == 0) {
                entity.setEnabledMark(1);
            } else {
                entity.setEnabledMark(0);
            }
            boolean flag = this.mcSmsTemplateService.update(id, entity);
            if (!flag) {
                return ActionResult.fail((String)MsgCode.FA002.get());
            }
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u53c2\u6570")
    @PostMapping(value={"/getTemplate"})
    public ActionResult<?> testConnect(@RequestBody McSmsTemplateCrForm mcSmsTemplateCrForm) {
        List<String> list = null;
        if (mcSmsTemplateCrForm != null) {
            SmsModel2 smsModel2 = this.mcSmsTemplateService.getSmsConfig();
            list = SmsUtil2.querySmsTemplateRequest(mcSmsTemplateCrForm.getCompany(), smsModel2, mcSmsTemplateCrForm.getEndpoint(), mcSmsTemplateCrForm.getRegion(), mcSmsTemplateCrForm.getTemplateId());
        }
        if (list == null) {
            return ActionResult.fail((String)"\u77ed\u4fe1\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u77ed\u4fe1\u6a21\u677f\u53c2\u6570")
    @GetMapping(value={"/getTemplate/{id}"})
    public ActionResult<?> getTemplateById(@PathVariable(value="id") String id) {
        List<Object> list = new ArrayList();
        McSmsTemplateEntity entity = this.mcSmsTemplateService.getInfo(id);
        if (entity != null && entity.getCompany() != null) {
            SmsModel2 smsModel2 = this.mcSmsTemplateService.getSmsConfig();
            list = SmsUtil2.querySmsTemplateRequest(entity.getCompany(), smsModel2, entity.getEndpoint(), entity.getRegion(), entity.getTemplateId());
        }
        if (list == null) {
            return ActionResult.success(new ArrayList());
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u53d1\u9001\u6d4b\u8bd5\u77ed\u4fe1")
    @PostMapping(value={"/testSent"})
    public ActionResult testSentSms(@RequestBody McSmsTemplateCrForm mcSmsTemplateCrForm) {
        if (mcSmsTemplateCrForm.getCompany() != null) {
            SmsModel2 smsModel2 = this.mcSmsTemplateService.getSmsConfig();
            String sentCode = SmsUtil2.sentSms(mcSmsTemplateCrForm.getCompany(), smsModel2, mcSmsTemplateCrForm.getEndpoint(), mcSmsTemplateCrForm.getRegion(), mcSmsTemplateCrForm.getPhoneNumbers(), mcSmsTemplateCrForm.getSignContent(), mcSmsTemplateCrForm.getTemplateId(), mcSmsTemplateCrForm.getParameters());
            if ("OK".equalsIgnoreCase(sentCode)) {
                return ActionResult.success((String)"\u9a8c\u8bc1\u901a\u8fc7");
            }
        }
        return ActionResult.fail((String)"\u9a8c\u8bc1\u5931\u8d25");
    }
}

