/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgCenter.entity.McMessageEntity;
import com.bringspring.system.msgCenter.entity.McMessageReceiveEntity;
import com.bringspring.system.msgCenter.entity.McMessageTemplateEntity;
import com.bringspring.system.msgCenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgCenter.mapper.McMessageMapper;
import com.bringspring.system.msgCenter.model.mcMessage.McMessagePagination;
import com.bringspring.system.msgCenter.model.mcMessageReceive.McMessageReceiveListQuery;
import com.bringspring.system.msgCenter.service.McMessageReceiveService;
import com.bringspring.system.msgCenter.service.McMessageService;
import com.bringspring.system.msgCenter.service.McMessageTemplateService;
import com.bringspring.system.msgCenter.util.WxCpMessageUtils;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessageSendResult;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendResult;
import org.apache.commons.collections4.SetUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McMessageServiceImpl
extends ServiceImpl<McMessageMapper, McMessageEntity>
implements McMessageService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private McMessageTemplateService mcMessageTemplateService;
    @Autowired
    private UserService userService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private WxCpConfiguration wxCpConfiguration;
    @Autowired
    private McMessageReceiveService mcMessageReceiveService;
    @Autowired
    private WxCpMessageUtils wxCpMessageUtils;

    @Override
    public List<McMessageEntity> getList(McMessagePagination mcMessagePagination) {
        Object mcMessageObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcMessageNum = 0;
        QueryWrapper mcMessageQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            mcMessageObj = this.authorizeService.getCondition(new AuthorizeConditionModel(mcMessageQueryWrapper, mcMessagePagination.getMenuId(), "mc_message"));
            if (ObjectUtil.isEmpty((Object)mcMessageObj)) {
                return new ArrayList<McMessageEntity>();
            }
            mcMessageQueryWrapper = (QueryWrapper)mcMessageObj;
            ++mcMessageNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            mcMessageObj = this.authorizeService.getCondition(new AuthorizeConditionModel(mcMessageQueryWrapper, mcMessagePagination.getMenuId(), "mc_message"));
            if (ObjectUtil.isEmpty((Object)mcMessageObj)) {
                return new ArrayList<McMessageEntity>();
            }
            mcMessageQueryWrapper = (QueryWrapper)mcMessageObj;
            ++mcMessageNum;
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getTaskCode())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().like(McMessageEntity::getTaskCode, (Object)mcMessagePagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getMsgType())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getMsgType, (Object)mcMessagePagination.getMsgType());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getTemplateCode())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().like(McMessageEntity::getTemplateCode, (Object)mcMessagePagination.getTemplateCode());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getToUserIds())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getToUserIds, (Object)mcMessagePagination.getToUserIds());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getToDeptIds())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getToDeptIds, (Object)mcMessagePagination.getToDeptIds());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getEnabledMark())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getEnabledMark, (Object)mcMessagePagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getCreatorUserId())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getCreatorUserId, (Object)mcMessagePagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty(mcMessagePagination.getCreatorTime())) {
            ++mcMessageNum;
            List<String> CreatorTimeList = mcMessagePagination.getCreatorTime();
            String fir = CreatorTimeList.get(0);
            String sec = CreatorTimeList.get(1);
            ((LambdaQueryWrapper)mcMessageQueryWrapper.lambda().ge(McMessageEntity::getCreatorTime, (Object)fir)).le(McMessageEntity::getCreatorTime, (Object)sec);
        }
        if (AllIdList.size() > 0) {
            mcMessageQueryWrapper.lambda().in(McMessageEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)mcMessagePagination.getSidx())) {
            mcMessageQueryWrapper.lambda().orderByDesc(McMessageEntity::getCreatorTime);
        } else {
            try {
                String sidx = mcMessagePagination.getSidx();
                McMessageEntity mcMessageEntity = new McMessageEntity();
                Field declaredField = mcMessageEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                mcMessageQueryWrapper = "asc".equals(mcMessagePagination.getSort().toLowerCase()) ? (QueryWrapper)mcMessageQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)mcMessageQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(mcMessagePagination.getCurrentPage(), mcMessagePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)mcMessageQueryWrapper);
            return mcMessagePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return mcMessagePagination.setData(list, list.size());
    }

    @Override
    public List<McMessageEntity> getTypeList(McMessagePagination mcMessagePagination, String dataType) {
        Object mcMessageObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcMessageNum = 0;
        QueryWrapper mcMessageQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            mcMessageObj = this.authorizeService.getCondition(new AuthorizeConditionModel(mcMessageQueryWrapper, mcMessagePagination.getMenuId(), "mc_message"));
            if (ObjectUtil.isEmpty((Object)mcMessageObj)) {
                return new ArrayList<McMessageEntity>();
            }
            mcMessageQueryWrapper = (QueryWrapper)mcMessageObj;
            ++mcMessageNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            mcMessageObj = this.authorizeService.getCondition(new AuthorizeConditionModel(mcMessageQueryWrapper, mcMessagePagination.getMenuId(), "mc_message"));
            if (ObjectUtil.isEmpty((Object)mcMessageObj)) {
                return new ArrayList<McMessageEntity>();
            }
            mcMessageQueryWrapper = (QueryWrapper)mcMessageObj;
            ++mcMessageNum;
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getTaskCode())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().like(McMessageEntity::getTaskCode, (Object)mcMessagePagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getMsgType())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getMsgType, (Object)mcMessagePagination.getMsgType());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getTemplateCode())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().like(McMessageEntity::getTemplateCode, (Object)mcMessagePagination.getTemplateCode());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getToUserIds())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getToUserIds, (Object)mcMessagePagination.getToUserIds());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getToDeptIds())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getToDeptIds, (Object)mcMessagePagination.getToDeptIds());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getEnabledMark())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getEnabledMark, (Object)mcMessagePagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)mcMessagePagination.getCreatorUserId())) {
            ++mcMessageNum;
            mcMessageQueryWrapper.lambda().eq(McMessageEntity::getCreatorUserId, (Object)mcMessagePagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty(mcMessagePagination.getCreatorTime())) {
            ++mcMessageNum;
            List<String> CreatorTimeList = mcMessagePagination.getCreatorTime();
            String fir = CreatorTimeList.get(0);
            String sec = CreatorTimeList.get(1);
            ((LambdaQueryWrapper)mcMessageQueryWrapper.lambda().ge(McMessageEntity::getCreatorTime, (Object)fir)).le(McMessageEntity::getCreatorTime, (Object)sec);
        }
        if (AllIdList.size() > 0) {
            mcMessageQueryWrapper.lambda().in(McMessageEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)mcMessagePagination.getSidx())) {
            mcMessageQueryWrapper.lambda().orderByDesc(McMessageEntity::getCreatorTime);
        } else {
            try {
                String sidx = mcMessagePagination.getSidx();
                McMessageEntity mcMessageEntity = new McMessageEntity();
                Field declaredField = mcMessageEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                mcMessageQueryWrapper = "asc".equals(mcMessagePagination.getSort().toLowerCase()) ? (QueryWrapper)mcMessageQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)mcMessageQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(mcMessagePagination.getCurrentPage(), mcMessagePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)mcMessageQueryWrapper);
                return mcMessagePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return mcMessagePagination.setData(list, list.size());
        }
        return this.list((Wrapper)mcMessageQueryWrapper);
    }

    @Override
    public McMessageEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMessageEntity::getId, (Object)id);
        return (McMessageEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(McMessageEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, McMessageEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(McMessageEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public boolean sendMessage(McMessageEntity entity) throws WxErrorException {
        String tempCode = StringUtils.isEmpty((String)entity.getTemplateCode()) ? "default_templtate" : entity.getTemplateCode();
        McMessageTemplateEntity templateEntity = this.mcMessageTemplateService.getInfoByEnCode(tempCode);
        HashSet<String> channelSet = new HashSet<String>(5);
        channelSet.add(ChannelTypeEnum.SYS_MSG.getCode());
        if (templateEntity != null) {
            if (templateEntity.getIsStationLetter() == 1) {
                channelSet.add(ChannelTypeEnum.SYS_MSG.getCode());
            }
            if (templateEntity.getIsEmail() == 1) {
                channelSet.add(ChannelTypeEnum.MAIL_MSG.getCode());
            }
            if (templateEntity.getIsSms() == 1) {
                channelSet.add(ChannelTypeEnum.SMS_MSG.getCode());
            }
            if (templateEntity.getIsDingTalk() == 1) {
                channelSet.add(ChannelTypeEnum.DING_MSG.getCode());
            }
            if (templateEntity.getIsWecom() == 1) {
                channelSet.add(ChannelTypeEnum.QY_MSG.getCode());
            }
        }
        this.addMesReceive(entity, channelSet);
        boolean sendRes = this.channelMsgSendByMesReceive(entity, channelSet, 0);
        return sendRes;
    }

    @DSTransactional
    private boolean addMesReceive(McMessageEntity info, Set<String> channelSet) {
        List<String> orgIds;
        List<UserEntity> userList;
        if (ObjectUtil.isEmpty((Object)info) || CollectionUtil.isEmpty(channelSet)) {
            return false;
        }
        boolean allUsers = false;
        SetUtils.SetView userSet = new HashSet();
        String toUserIds = info.getToUserIds();
        if (StringUtils.isNotEmpty((String)toUserIds)) {
            if ("@ALL".equals(toUserIds)) {
                allUsers = true;
                userSet.add(toUserIds);
            } else {
                String[] toUserArr = toUserIds.split(",");
                Collections.addAll(userSet, toUserArr);
            }
        }
        String toDeptIds = info.getToDeptIds();
        if (!allUsers && StringUtils.isNotEmpty((String)toDeptIds) && CollectionUtil.isNotEmpty(userList = this.userService.getUserByOrgIds(orgIds = Arrays.asList(toDeptIds.split(","))))) {
            Set deptUserSet = userList.stream().map(UserEntity::getId).collect(Collectors.toSet());
            userSet = SetUtils.union(userSet, deptUserSet);
        }
        if (CollectionUtil.isNotEmpty(userSet)) {
            ArrayList receiveEntityList = new ArrayList();
            for (String channelType : channelSet) {
                ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(channelType);
                switch (typeEnum) {
                    case SYS_MSG: {
                        userSet.stream().forEach(s -> {
                            McMessageReceiveEntity receiveEntity = new McMessageReceiveEntity();
                            receiveEntity.setMessageId(info.getId());
                            receiveEntity.setTaskCode(info.getTaskCode());
                            receiveEntity.setChannelType(ChannelTypeEnum.SYS_MSG.getCode());
                            receiveEntity.setReceiveUserId((String)s);
                            receiveEntity.setEnabledMark(0);
                            receiveEntity.setRemark(null);
                            receiveEntityList.add(receiveEntity);
                        });
                        break;
                    }
                    case MAIL_MSG: {
                        break;
                    }
                    case SMS_MSG: {
                        break;
                    }
                    case DING_MSG: {
                        break;
                    }
                    case QY_MSG: {
                        Boolean isLinkedCorp = this.wxCpConfiguration.getIsLinkedCorp();
                        List<SynThirdInfoEntity> thirdInfoList = this.synThirdInfoService.getInfoBySysObjIdList("1", "2", (Set<String>)userSet, isLinkedCorp);
                        thirdInfoList.stream().forEach(s -> {
                            McMessageReceiveEntity receiveEntity = new McMessageReceiveEntity();
                            receiveEntity.setMessageId(info.getId());
                            receiveEntity.setTaskCode(info.getTaskCode());
                            receiveEntity.setChannelType(ChannelTypeEnum.QY_MSG.getCode());
                            receiveEntity.setReceiveUserId(s.getId());
                            if (StringUtils.isEmpty((String)s.getThirdObjectId())) {
                                receiveEntity.setEnabledMark(2);
                                receiveEntity.setRemark("\u521b\u5efa\uff0cThirdObjectId\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u20182\u4e0b\u53d1\u5931\u8d25\u2019");
                            } else {
                                receiveEntity.setEnabledMark(0);
                                receiveEntity.setRemark("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u20180\u5f85\u4e0b\u53d1\u2019");
                            }
                            receiveEntityList.add(receiveEntity);
                        });
                        break;
                    }
                }
            }
            return this.mcMessageReceiveService.saveBatch(receiveEntityList);
        }
        return false;
    }

    private boolean channelMsgSendByMesReceive(McMessageEntity info, Set<String> channelSet, Integer enabledMark) throws WxErrorException {
        if (ObjectUtil.isEmpty((Object)info) || CollectionUtil.isEmpty(channelSet)) {
            return false;
        }
        String infoId = info.getId();
        McMessageReceiveListQuery msgReceiveListQuery = new McMessageReceiveListQuery();
        msgReceiveListQuery.setMessageId(infoId);
        if (ObjectUtil.isNotEmpty((Object)enabledMark)) {
            msgReceiveListQuery.setEnabledMark(enabledMark.toString());
        }
        for (String channelType : channelSet) {
            msgReceiveListQuery.setChannelType(channelType);
            List<McMessageReceiveEntity> list = this.mcMessageReceiveService.getList(msgReceiveListQuery);
            if (!CollectionUtil.isNotEmpty(list)) continue;
            ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(channelType);
            switch (typeEnum) {
                case SYS_MSG: {
                    list.stream().forEach(s -> {
                        s.setEnabledMark(1);
                        s.setSendTime(new Date());
                        s.setSendUserId(this.userProvider.get().getUserId());
                    });
                    this.mcMessageReceiveService.updateBatchById(list);
                    break;
                }
                case MAIL_MSG: {
                    break;
                }
                case SMS_MSG: {
                    break;
                }
                case DING_MSG: {
                    break;
                }
                case QY_MSG: {
                    Boolean isLinkedCorp = this.wxCpConfiguration.getIsLinkedCorp();
                    if (isLinkedCorp.booleanValue()) {
                        WxCpLinkedCorpMessageSendResult wxCpLinkedCorpMessageSendResult = this.wxCpMessageUtils.sendLinkedCorpMessage(info, list);
                        System.out.println("~\u00b7~\u4e92\u8054\u4f01\u4e1a\u53d1\u9001\u6d88\u606f\uff1a" + wxCpLinkedCorpMessageSendResult);
                        this.wxCpLinkedCorpSendMessageResult(info, wxCpLinkedCorpMessageSendResult);
                        break;
                    }
                    Map<String, WxCpMessageSendResult> resultMap = this.wxCpMessageUtils.sendMessage(info, list);
                    this.wxCpSendMessageResult(info, resultMap);
                    break;
                }
            }
        }
        return false;
    }

    public void wxCpSendMessageResult(McMessageEntity info, Map<String, WxCpMessageSendResult> resultMap) {
        McMessageReceiveListQuery msgReceiveListQuery = new McMessageReceiveListQuery();
        msgReceiveListQuery.setMessageId(info.getId());
        msgReceiveListQuery.setChannelType(ChannelTypeEnum.QY_MSG.getCode());
        msgReceiveListQuery.setEnabledMark("0");
        List<McMessageReceiveEntity> stayList = this.mcMessageReceiveService.getList(msgReceiveListQuery);
        if (CollectionUtil.isNotEmpty(stayList)) {
            stayList.stream().forEach(s -> {
                s.setEnabledMark(1);
                s.setSendTime(new Date());
                s.setSendUserId(this.userProvider.get().getUserId());
                s.setRemark("1\u4e0b\u53d1\u6210\u529f\uff1a");
            });
            this.mcMessageReceiveService.updateBatchById(stayList);
        }
        if (CollectionUtil.isNotEmpty(resultMap)) {
            for (Map.Entry<String, WxCpMessageSendResult> entry : resultMap.entrySet()) {
                String corpId = entry.getKey();
                WxCpMessageSendResult result = entry.getValue();
                if (!ObjectUtil.isNotEmpty((Object)result) || !CollectionUtil.isNotEmpty((Collection)result.getInvalidUserList())) continue;
                List invalidUserList = result.getInvalidUserList();
                List<SynThirdInfoEntity> thirdInfoList = this.synThirdInfoService.getListByThirdObjIds("1", "2", corpId, invalidUserList);
                List<String> thirdIds = thirdInfoList.stream().map(s -> s.getId()).collect(Collectors.toList());
                McMessageReceiveListQuery msgReceiveListQuery2 = new McMessageReceiveListQuery();
                msgReceiveListQuery2.setMessageId(info.getId());
                msgReceiveListQuery2.setChannelType(ChannelTypeEnum.QY_MSG.getCode());
                msgReceiveListQuery2.setReceiveUserIds(thirdIds);
                List<McMessageReceiveEntity> list = this.mcMessageReceiveService.getList(msgReceiveListQuery2);
                if (!CollectionUtil.isNotEmpty(list)) continue;
                list.stream().forEach(s -> {
                    s.setEnabledMark(2);
                    s.setSendTime(new Date());
                    s.setSendUserId(this.userProvider.get().getUserId());
                    s.setRemark("\u4e0b\u53d1\u5931\u8d25\uff1a\u4e0d\u5408\u6cd5\u7684userid");
                });
                this.mcMessageReceiveService.updateBatchById(list);
            }
        }
        info.setEnabledMark(2);
        this.update(info.getId(), info);
    }

    public void wxCpLinkedCorpSendMessageResult(McMessageEntity info, WxCpLinkedCorpMessageSendResult result) {
        Map<String, WeComModel> weComModels;
        Optional<WeComModel> firstValue;
        String[] invalidUser;
        McMessageReceiveListQuery msgReceiveListQuery = new McMessageReceiveListQuery();
        msgReceiveListQuery.setMessageId(info.getId());
        msgReceiveListQuery.setChannelType(ChannelTypeEnum.QY_MSG.getCode());
        msgReceiveListQuery.setEnabledMark("0");
        List<McMessageReceiveEntity> stayList = this.mcMessageReceiveService.getList(msgReceiveListQuery);
        if (CollectionUtil.isNotEmpty(stayList)) {
            stayList.stream().forEach(s -> {
                s.setEnabledMark(1);
                s.setSendTime(new Date());
                s.setSendUserId(this.userProvider.get().getUserId());
                s.setRemark("1\u4e0b\u53d1\u6210\u529f\uff1a");
            });
            this.mcMessageReceiveService.updateBatchById(stayList);
        }
        if (ObjectUtil.isNotEmpty((Object)result) && ObjectUtil.isNotEmpty((Object)(invalidUser = result.getInvalidUser())) && invalidUser.length != 0 && (firstValue = (weComModels = this.wxCpConfiguration.getWeComModels()).values().stream().findFirst()).isPresent()) {
            String qyhCorpId = firstValue.get().getQyhCorpId();
            ArrayList<String> invalidUserList = new ArrayList<String>();
            for (int i = 0; i < invalidUser.length; ++i) {
                if (!invalidUser[i].contains("/")) {
                    invalidUserList.add(qyhCorpId + "/" + invalidUser[i]);
                    continue;
                }
                invalidUserList.add(invalidUser[i]);
            }
            List<SynThirdInfoEntity> thirdInfoList = this.synThirdInfoService.getListByThirdObjIds("1", "2", qyhCorpId, invalidUserList);
            List<String> thirdIds = thirdInfoList.stream().map(s -> s.getId()).collect(Collectors.toList());
            McMessageReceiveListQuery msgReceiveListQuery2 = new McMessageReceiveListQuery();
            msgReceiveListQuery2.setMessageId(info.getId());
            msgReceiveListQuery2.setChannelType(ChannelTypeEnum.QY_MSG.getCode());
            msgReceiveListQuery2.setReceiveUserIds(thirdIds);
            List<McMessageReceiveEntity> list = this.mcMessageReceiveService.getList(msgReceiveListQuery2);
            if (CollectionUtil.isNotEmpty(list)) {
                list.stream().forEach(s -> {
                    s.setEnabledMark(2);
                    s.setSendTime(new Date());
                    s.setSendUserId(this.userProvider.get().getUserId());
                    s.setRemark("\u4e0b\u53d1\u5931\u8d25\uff1a\u4e0d\u5408\u6cd5\u7684userid");
                });
                this.mcMessageReceiveService.updateBatchById(list);
            }
        }
        info.setEnabledMark(2);
        this.update(info.getId(), info);
    }
}

