/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMessageTemplateEntity;
import com.bringspring.system.msgCenter.mapper.McMessageTemplateMapper;
import com.bringspring.system.msgCenter.model.mcMessageTemplate.McMessageTemplatePagination;
import com.bringspring.system.msgCenter.model.message.SentMessageForm;
import com.bringspring.system.msgCenter.service.McMessageTemplateService;
import com.bringspring.system.msgCenter.util.SentMessageUtil2;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McMessageTemplateServiceImpl
extends ServiceImpl<McMessageTemplateMapper, McMessageTemplateEntity>
implements McMessageTemplateService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SentMessageUtil2 sentMessageUtil2;

    @Override
    public List<McMessageTemplateEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMessageTemplateEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByDesc(McMessageTemplateEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<McMessageTemplateEntity> getList(McMessageTemplatePagination pagination) {
        Object mcMessageTemplateObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcMessageTemplateNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            mcMessageTemplateObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "MC_MESSAGE_TEMPLATE"));
            if (ObjectUtil.isEmpty((Object)mcMessageTemplateObj)) {
                return new ArrayList<McMessageTemplateEntity>();
            }
            queryWrapper = (QueryWrapper)mcMessageTemplateObj;
            ++mcMessageTemplateNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            mcMessageTemplateObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "MC_MESSAGE_TEMPLATE"));
            if (ObjectUtil.isEmpty((Object)mcMessageTemplateObj)) {
                return new ArrayList<McMessageTemplateEntity>();
            }
            queryWrapper = (QueryWrapper)mcMessageTemplateObj;
            ++mcMessageTemplateNum;
        }
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(McMessageTemplateEntity::getFullName, (Object)pagination.getKeyword())).or()).like(McMessageTemplateEntity::getTitle, (Object)pagination.getKeyword())).or()).like(McMessageTemplateEntity::getEnCode, (Object)pagination.getKeyword());
            });
            ++mcMessageTemplateNum;
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMessageTemplateEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMessageTemplateEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMessageTemplateEntity mcMessageTemplateEntity = new McMessageTemplateEntity();
                Field declaredField = mcMessageTemplateEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public McMessageTemplateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMessageTemplateEntity::getId, (Object)id);
        return (McMessageTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public McMessageTemplateEntity getInfoByEnCode(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMessageTemplateEntity::getEnCode, (Object)enCode);
        return (McMessageTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McMessageTemplateEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, McMessageTemplateEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(McMessageTemplateEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMessageTemplateEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(McMessageTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMessageTemplateEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(McMessageTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void testSendMessage(SentMessageForm sentMessageForm) throws Exception {
        sentMessageForm.setType(3);
        sentMessageForm.setBodyText(new HashMap<String, String>());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        JSONObject map = JSONObject.parseObject((String)sentMessageForm.getTemplateJson());
        parameterMap.putAll((Map<String, String>)map);
        sentMessageForm.setParameterMap(parameterMap);
        this.sentMessageUtil2.sendMessage(sentMessageForm);
    }

    @Override
    public McMessageTemplateEntity getMessageTemplateByEncode(String encode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMessageTemplateEntity::getEnCode, (Object)encode);
        return (McMessageTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }
}

