/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgCenter.entity.McSmsTemplateEntity;
import com.bringspring.system.msgCenter.mapper.McSmsTemplateMapper;
import com.bringspring.system.msgCenter.model.SmsModel2;
import com.bringspring.system.msgCenter.service.McSmsTemplateService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McSmsTemplateServiceImpl
extends ServiceImpl<McSmsTemplateMapper, McSmsTemplateEntity>
implements McSmsTemplateService {
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<McSmsTemplateEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McSmsTemplateEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByDesc(McSmsTemplateEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<McSmsTemplateEntity> getList(Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(McSmsTemplateEntity::getTemplateId, (Object)pagination.getKeyword())).or()).like(McSmsTemplateEntity::getFullName, (Object)pagination.getKeyword())).or()).like(McSmsTemplateEntity::getEnCode, (Object)pagination.getKeyword());
            });
        }
        queryWrapper.lambda().orderByDesc(McSmsTemplateEntity::getCreatorTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public McSmsTemplateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McSmsTemplateEntity::getId, (Object)id);
        return (McSmsTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(McSmsTemplateEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, McSmsTemplateEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(McSmsTemplateEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public boolean isExistByTemplateName(String templateName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McSmsTemplateEntity::getFullName, (Object)templateName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(McSmsTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McSmsTemplateEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(McSmsTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public SmsModel2 getSmsConfig() {
        List<SysConfigEntity> configList = this.sysConfigService.getList();
        HashMap<String, String> objModel = new HashMap<String, String>(16);
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        SmsModel2 smsModel2 = (SmsModel2)JsonUtil.getJsonToBean(objModel, SmsModel2.class);
        return smsModel2;
    }
}

